/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest;

import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.decoder.RESTCoverage;
import it.geosolutions.geoserver.rest.decoder.RESTCoverageStore;
import it.geosolutions.geoserver.rest.decoder.RESTStyleList;
import it.geosolutions.geoserver.rest.decoder.utils.NameLinkElem;
import it.geosolutions.geoserver.rest.encoder.GSBackupEncoder;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.GSLayerGroupEncoder;
import it.geosolutions.geoserver.rest.encoder.GSNamespaceEncoder;
import it.geosolutions.geoserver.rest.encoder.GSPostGISDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.GSWorkspaceEncoder;
import it.geosolutions.geoserver.rest.encoder.coverage.GSCoverageEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStructuredGridCoverageReaderManager;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStyleManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.zip.ZipFile;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerRESTPublisher {
    public static final String DEFAULT_CRS = "EPSG:4326";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerRESTPublisher.class);
    private final String restURL;
    private final String gsuser;
    private final String gspass;
    private final GeoServerRESTStyleManager styleManager;

    public GeoServerRESTPublisher(String restURL, String username, String password) {
        this.restURL = HTTPUtils.decurtSlash(restURL);
        this.gsuser = username;
        this.gspass = password;
        URL url = null;
        try {
            url = new URL(restURL);
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Bad URL: Calls to GeoServer are going to fail", (Throwable)ex);
        }
        this.styleManager = new GeoServerRESTStyleManager(url, username, password);
    }

    public String backup(String backupDir) throws IllegalArgumentException {
        return this.backup(backupDir, false, false, false);
    }

    public String backup(String backupDir, boolean includedata, boolean includegwc, boolean includelog) throws IllegalArgumentException {
        if (backupDir == null || backupDir.isEmpty()) {
            throw new IllegalArgumentException("The backup_dir must not be null or empty");
        }
        StringBuilder bkpUrl = new StringBuilder(this.restURL);
        bkpUrl.append("/rest/bkprst/backup");
        GSBackupEncoder bkpenc = new GSBackupEncoder(backupDir);
        bkpenc.setIncludeData(includedata);
        bkpenc.setIncludeGwc(includegwc);
        bkpenc.setIncludeLog(includelog);
        String result = HTTPUtils.post(bkpUrl.toString(), bkpenc.toString(), "text/xml", this.gsuser, this.gspass);
        return result;
    }

    public String restore(String backupDir) throws IllegalArgumentException {
        if (backupDir == null || backupDir.isEmpty()) {
            throw new IllegalArgumentException("The backup_dir must not be null or empty");
        }
        StringBuilder bkpUrl = new StringBuilder(this.restURL);
        bkpUrl.append("/rest/bkprst/restore");
        GSBackupEncoder bkpenc = new GSBackupEncoder(backupDir);
        String result = HTTPUtils.post(bkpUrl.toString(), bkpenc.toString(), "text/xml", this.gsuser, this.gspass);
        return result;
    }

    public boolean createWorkspace(String workspace) {
        GSWorkspaceEncoder wsenc;
        String wsxml;
        String sUrl = this.restURL + "/rest/workspaces";
        String result = HTTPUtils.postXml(sUrl, wsxml = (wsenc = new GSWorkspaceEncoder(workspace)).toString(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean createWorkspace(String name, URI uri) {
        return this.createNamespace(name, uri);
    }

    public boolean createNamespace(String prefix, URI uri) {
        GSNamespaceEncoder nsenc;
        String nsxml;
        String sUrl = this.restURL + "/rest/namespaces";
        String result = HTTPUtils.postXml(sUrl, nsxml = (nsenc = new GSNamespaceEncoder(prefix, uri)).toString(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateNamespace(String prefix, URI uri) {
        GSNamespaceEncoder nsenc;
        String nsxml;
        String sUrl = this.restURL + "/rest/namespaces/" + this.encode(prefix);
        String result = HTTPUtils.put(sUrl, nsxml = (nsenc = new GSNamespaceEncoder(prefix, uri)).toString(), "application/xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean removeNamespace(String prefix, boolean recurse) {
        return this.removeWorkspace(prefix, recurse);
    }

    public boolean publishStyle(String sldBody) {
        return this.styleManager.publishStyle(sldBody);
    }

    public boolean publishStyle(String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.publishStyle(sldBody, name);
    }

    public boolean publishStyle(File sldFile) {
        return this.styleManager.publishStyle(sldFile);
    }

    public boolean publishStyle(File sldFile, String name) {
        return this.styleManager.publishStyle(sldFile, name);
    }

    public boolean publishStyle(String sldBody, String name, boolean raw) {
        return this.styleManager.publishStyle(sldBody, name, raw);
    }

    public boolean publishStyle(File sldFile, String name, boolean raw) {
        return this.styleManager.publishStyle(sldFile, name, raw);
    }

    public boolean updateStyle(File sldFile, String name, boolean raw) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldFile, name, raw);
    }

    public boolean updateStyle(String sldBody, String name, boolean raw) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldBody, name, raw);
    }

    public boolean updateStyle(String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldBody, name);
    }

    public boolean updateStyle(File sldFile, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldFile, name);
    }

    public boolean removeStyle(String styleName, boolean purge) throws IllegalArgumentException {
        return this.styleManager.removeStyle(styleName, purge);
    }

    public boolean removeStyle(String styleName) {
        return this.styleManager.removeStyle(styleName);
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody) {
        return this.styleManager.publishStyleInWorkspace(workspace, sldBody);
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.publishStyleInWorkspace(workspace, sldBody, name);
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile) {
        return this.styleManager.publishStyleInWorkspace(workspace, sldFile);
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile, String name) {
        return this.styleManager.publishStyleInWorkspace(workspace, sldFile, name);
    }

    public boolean updateStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyleInWorkspace(workspace, sldBody, name);
    }

    public boolean updateStyleInWorkspace(String workspace, File sldFile, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyleInWorkspace(workspace, sldFile, name);
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName, boolean purge) throws IllegalArgumentException {
        return this.styleManager.removeStyleInWorkspace(workspace, styleName, purge);
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName) {
        return this.styleManager.removeStyleInWorkspace(workspace, styleName);
    }

    private boolean createStore(String workspace, StoreType dsType, String storeName, UploadMethod method, Enum extension, String mimeType, URI uri, ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        if (workspace == null || dsType == null || storeName == null || method == null || extension == null || mimeType == null || uri == null) {
            throw new IllegalArgumentException("Null argument");
        }
        StringBuilder sbUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/").append((Object)dsType).append("/").append(storeName).append("/").append((Object)method).append(".").append(extension);
        if (configure != null) {
            String paramString;
            sbUrl.append("?configure=").append((Object)configure);
            if (params != (NameValuePair[])null && !(paramString = this.appendParameters(params)).isEmpty()) {
                sbUrl.append("&").append(paramString);
            }
        }
        String sentResult = null;
        if (method.equals((Object)UploadMethod.FILE)) {
            File file = new File(uri);
            if (!file.exists()) {
                throw new FileNotFoundException("unable to locate file: " + file);
            }
            sentResult = HTTPUtils.put(sbUrl.toString(), file, mimeType, this.gsuser, this.gspass);
        } else if (method.equals((Object)UploadMethod.EXTERNAL)) {
            sentResult = HTTPUtils.put(sbUrl.toString(), uri.toString(), mimeType, this.gsuser, this.gspass);
        } else if (method.equals((Object)UploadMethod.URL)) {
            sentResult = HTTPUtils.put(sbUrl.toString(), uri.toString(), mimeType, this.gsuser, this.gspass);
        }
        if (sentResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Store successfully created using ( " + uri + " )");
            }
            return true;
        }
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Error in creating store using: " + uri);
        }
        return false;
    }

    private boolean createDataStore(String workspace, String storeName, UploadMethod method, DataStoreExtension extension, String mimeType, URI uri, ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        return this.createStore(workspace, StoreType.DATASTORES, storeName, method, extension, mimeType, uri, configure, params);
    }

    private boolean createCoverageStore(String workspace, String storeName, UploadMethod method, CoverageStoreExtension extension, String mimeType, URI uri, ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        return this.createStore(workspace, StoreType.COVERAGESTORES, storeName, method, extension, mimeType, uri, configure, params);
    }

    public boolean createPostGISDatastore(String workspace, GSPostGISDatastoreEncoder datastoreEncoder) {
        String xml;
        String sUrl = this.restURL + "/rest/workspaces/" + workspace + "/datastores/";
        String result = HTTPUtils.postXml(sUrl, xml = datastoreEncoder.toString(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishDBLayer(String workspace, String storename, String layername, String srs, String defaultStyle) {
        GSFeatureTypeEncoder fte = new GSFeatureTypeEncoder();
        fte.setProjectionPolicy(GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED);
        fte.addKeyword("KEYWORD");
        fte.setTitle(layername);
        fte.setName(layername);
        fte.setSRS(srs);
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(defaultStyle);
        return this.publishDBLayer(workspace, storename, fte, layerEncoder);
    }

    public boolean publishDBLayer(String workspace, String storename, GSFeatureTypeEncoder fte, GSLayerEncoder layerEncoder) {
        String ftypeXml = fte.toString();
        StringBuilder postUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/datastores/").append(storename).append("/featuretypes");
        String layername = fte.getName();
        if (layername == null || layername.isEmpty()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("GSFeatureTypeEncoder has no valid name associated, try using GSFeatureTypeEncoder.setName(String)");
            }
            return false;
        }
        String configuredResult = HTTPUtils.postXml(postUrl.toString(), ftypeXml, this.gsuser, this.gspass);
        boolean published = configuredResult != null;
        boolean configured = false;
        if (!published) {
            LOGGER.warn("Error in publishing (" + configuredResult + ") " + workspace + ":" + storename + "/" + layername);
        } else {
            LOGGER.info("DB layer successfully added (layer:" + layername + ")");
            if (layerEncoder == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("GSLayerEncoder is null: Unable to find the defaultStyle for this layer");
                }
                return false;
            }
            configured = this.configureLayer(workspace, layername, layerEncoder);
            if (!configured) {
                LOGGER.warn("Error in configuring (" + configuredResult + ") " + workspace + ":" + storename + "/" + layername);
            } else {
                LOGGER.info("DB layer successfully configured (layer:" + layername + ")");
            }
        }
        return published && configured;
    }

    public boolean publishShp(String workspace, String storename, String datasetname, File zipFile) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storename, new NameValuePair[0], datasetname, UploadMethod.FILE, zipFile.toURI(), DEFAULT_CRS, null);
    }

    public boolean publishShp(String workspace, String storeName, NameValuePair[] storeParams, String datasetName, UploadMethod method, URI shapefile, String srs, String nativeCRS, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        String mimeType;
        boolean nativeSrsNull;
        if (workspace == null || storeName == null || shapefile == null || datasetName == null || policy == null) {
            throw new IllegalArgumentException("Unable to run: null parameter");
        }
        boolean srsNull = srs == null || srs.length() == 0;
        boolean bl = nativeSrsNull = nativeCRS == null || nativeCRS.length() == 0;
        if (policy == GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED && (nativeSrsNull || srsNull)) {
            throw new IllegalArgumentException("Unable to run: you can't ask GeoServer to reproject while not specifying a native CRS");
        }
        if (policy == GSResourceEncoder.ProjectionPolicy.NONE && nativeSrsNull) {
            throw new IllegalArgumentException("Unable to run: you can't ask GeoServer to use a native srs which is null");
        }
        if (policy == GSResourceEncoder.ProjectionPolicy.FORCE_DECLARED && srsNull) {
            throw new IllegalArgumentException("Unable to run: you can't force GeoServer to use an srs which is null");
        }
        switch (method) {
            case EXTERNAL: 
            case external: {
                mimeType = "text/plain";
                break;
            }
            case URL: 
            case FILE: 
            case file: 
            case url: {
                mimeType = "application/zip";
                break;
            }
            default: {
                mimeType = null;
            }
        }
        if (!this.createDataStore(workspace, storeName != null ? storeName : FilenameUtils.getBaseName((String)shapefile.toString()), method, DataStoreExtension.SHP, mimeType, shapefile, ParameterConfigure.NONE, storeParams)) {
            LOGGER.error("Unable to create data store for shapefile: " + shapefile);
            return false;
        }
        GSFeatureTypeEncoder featureTypeEncoder = new GSFeatureTypeEncoder();
        featureTypeEncoder.setName(datasetName);
        featureTypeEncoder.setTitle(datasetName);
        if (!srsNull) {
            featureTypeEncoder.setSRS(srs);
        } else {
            featureTypeEncoder.setSRS(nativeCRS);
        }
        if (!nativeSrsNull) {
            featureTypeEncoder.setNativeCRS(nativeCRS);
        }
        featureTypeEncoder.setProjectionPolicy(policy);
        if (!this.createResource(workspace, StoreType.DATASTORES, storeName, featureTypeEncoder)) {
            LOGGER.error("Unable to create a coverage store for coverage: " + shapefile);
            return false;
        }
        GSLayerEncoder layerEncoder = this.configureDefaultStyle(defaultStyle);
        return this.configureLayer(workspace, datasetName, layerEncoder);
    }

    private GSLayerEncoder configureDefaultStyle(String defaultStyle) {
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        if (defaultStyle != null && !defaultStyle.isEmpty()) {
            if (defaultStyle.indexOf(":") != -1) {
                String[] wsAndName = defaultStyle.split(":");
                layerEncoder.setDefaultStyle(wsAndName[0], wsAndName[1]);
            } else {
                layerEncoder.setDefaultStyle(defaultStyle);
            }
        }
        return layerEncoder;
    }

    public boolean publishShp(String workspace, String storeName, NameValuePair[] storeParams, String datasetName, UploadMethod method, URI shapefile, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storeName, storeParams, datasetName, method, shapefile, srs, null, policy, defaultStyle);
    }

    public boolean publishShp(String workspace, String storeName, NameValuePair[] storeParams, String datasetName, UploadMethod method, URI shapefile, String srs, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storeName, storeParams, datasetName, method, shapefile, srs, null, GSResourceEncoder.ProjectionPolicy.FORCE_DECLARED, defaultStyle);
    }

    public boolean publishShp(String workspace, String storename, String layerName, File zipFile, String srs, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storename, (NameValuePair[])null, layerName, UploadMethod.FILE, zipFile.toURI(), srs, defaultStyle);
    }

    public boolean publishShp(String workspace, String storename, String layername, File zipFile, String srs) throws FileNotFoundException {
        return this.publishShp(workspace, storename, (NameValuePair[])null, layername, UploadMethod.FILE, zipFile.toURI(), srs, null);
    }

    public boolean publishShp(String workspace, String storename, String layername, File zipFile, String srs, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storename, params, layername, UploadMethod.FILE, zipFile.toURI(), srs, null);
    }

    public boolean publishShpCollection(String workspace, String storeName, URI resource) throws FileNotFoundException {
        UploadMethod method = null;
        String mime = null;
        if (resource.getScheme().equals("file") || !resource.isAbsolute()) {
            File f = new File(resource);
            if (f.exists() && f.isFile() && f.toString().endsWith(".zip")) {
                method = UploadMethod.FILE;
                mime = "application/zip";
            } else if (f.isDirectory()) {
                method = UploadMethod.EXTERNAL;
                mime = "text/plain";
            }
        } else {
            try {
                if (resource.toURL() != null) {
                    method = UploadMethod.URL;
                    mime = "text/plain";
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Resource is not recognized as a zip file, or a directory, or a valid URL", e);
            }
        }
        return this.createStore(workspace, StoreType.DATASTORES, storeName, method, DataStoreExtension.SHP, mime, resource, ParameterConfigure.ALL, new NameValuePair[0]);
    }

    private boolean publishCoverage(String workspace, String coveragestore, CoverageStoreExtension extension, String mimeType, File file, ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException {
        return this.createCoverageStore(workspace, coveragestore, UploadMethod.FILE, extension, mimeType, file.toURI(), configure, params);
    }

    private boolean publishExternalCoverage(String workspace, String coveragestore, CoverageStoreExtension extension, String mimeType, File file, ParameterConfigure configure, ParameterUpdate update) throws FileNotFoundException, IllegalArgumentException {
        NameValuePair[] nameValuePairArray;
        URI uRI = file.toURI();
        if (update != null) {
            NameValuePair[] nameValuePairArray2 = new NameValuePair[1];
            nameValuePairArray = nameValuePairArray2;
            nameValuePairArray2[0] = new NameValuePair("update", update.toString());
        } else {
            nameValuePairArray = null;
        }
        return this.createCoverageStore(workspace, coveragestore, UploadMethod.EXTERNAL, extension, mimeType, uRI, configure, nameValuePairArray);
    }

    public boolean publishArcGrid(String workspace, String storeName, File arcgrid) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, CoverageStoreExtension.ARCGRID, "image/arcgrid", arcgrid, ParameterConfigure.FIRST, null);
    }

    public boolean publishArcGrid(String workspace, String storeName, String coverageName, File arcgrid) throws FileNotFoundException, IllegalArgumentException {
        NameValuePair[] nameValuePairArray;
        if (workspace == null || arcgrid == null) {
            throw new IllegalArgumentException("Unable to proceed, some arguments are null");
        }
        String string = storeName != null ? storeName : FilenameUtils.getBaseName((String)arcgrid.getAbsolutePath());
        if (coverageName != null) {
            NameValuePair[] nameValuePairArray2 = new NameValuePair[1];
            nameValuePairArray = nameValuePairArray2;
            nameValuePairArray2[0] = new NameValuePair("coverageName", coverageName);
        } else {
            nameValuePairArray = null;
        }
        return this.publishCoverage(workspace, string, CoverageStoreExtension.ARCGRID, "image/arcgrid", arcgrid, ParameterConfigure.FIRST, nameValuePairArray);
    }

    public boolean publishArcGrid(String workspace, String storeName, String coverageName, File arcgrid, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox) throws FileNotFoundException, IllegalArgumentException {
        if (workspace == null || storeName == null || arcgrid == null || coverageName == null || srs == null || policy == null || defaultStyle == null) {
            throw new IllegalArgumentException("Unable to run: null parameter");
        }
        if (!this.createCoverageStore(workspace, storeName != null ? storeName : FilenameUtils.getBaseName((String)arcgrid.getAbsolutePath()), UploadMethod.FILE, CoverageStoreExtension.ARCGRID, "image/arcgrid", arcgrid.toURI(), ParameterConfigure.NONE, null)) {
            LOGGER.error("Unable to create coverage store for coverage: " + arcgrid);
            return false;
        }
        GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
        coverageEncoder.setName(coverageName);
        coverageEncoder.setTitle(coverageName);
        coverageEncoder.setSRS(srs);
        coverageEncoder.setNativeFormat("ArcGrid");
        coverageEncoder.addSupportedFormats("ARCGRID");
        coverageEncoder.addKeyword("arcGrid");
        coverageEncoder.addKeyword("WCS");
        coverageEncoder.setNativeCRS(srs);
        coverageEncoder.setProjectionPolicy(policy);
        coverageEncoder.setRequestSRS(srs);
        coverageEncoder.setResponseSRS(srs);
        if (bbox != null && bbox.length == 4) {
            coverageEncoder.setLatLonBoundingBox(bbox[0], bbox[1], bbox[2], bbox[3], DEFAULT_CRS);
        }
        if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
            LOGGER.error("Unable to create a coverage store for coverage: " + arcgrid);
            return false;
        }
        GSLayerEncoder layerEncoder = this.configureDefaultStyle(defaultStyle);
        return this.configureLayer(workspace, coverageName, layerEncoder);
    }

    public boolean publishExternalArcGrid(String workspace, String storeName, File arcgrid, String coverageName, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        if (workspace == null || storeName == null || arcgrid == null || coverageName == null || srs == null || policy == null || defaultStyle == null) {
            throw new IllegalArgumentException("Unable to run: null parameter");
        }
        GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
        coverageEncoder.setName(coverageName);
        coverageEncoder.setTitle(coverageName);
        coverageEncoder.setSRS(srs);
        coverageEncoder.setProjectionPolicy(policy);
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(defaultStyle);
        return this.publishExternalArcGrid(workspace, storeName, arcgrid, coverageEncoder, layerEncoder) != null;
    }

    public RESTCoverageStore publishExternalArcGrid(String workspace, String storeName, File arcgrid, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws IllegalArgumentException, FileNotFoundException {
        if (workspace == null || arcgrid == null || storeName == null || layerEncoder == null || coverageEncoder == null) {
            throw new IllegalArgumentException("Unable to run: null parameter");
        }
        String coverageName = coverageEncoder.getName();
        if (coverageName.isEmpty()) {
            throw new IllegalArgumentException("Unable to run: empty coverage store name");
        }
        boolean store = this.publishExternalCoverage(workspace, storeName, CoverageStoreExtension.ARCGRID, "text/plain", arcgrid, ParameterConfigure.NONE, ParameterUpdate.OVERWRITE);
        if (!store) {
            return null;
        }
        if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to create a coverage for the store:" + coverageName);
            }
            return null;
        }
        if (this.configureLayer(workspace, coverageName, layerEncoder)) {
            try {
                GeoServerRESTReader reader = new GeoServerRESTReader(this.restURL, this.gsuser, this.gspass);
                return reader.getCoverageStore(workspace, storeName);
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean publishGeoTIFF(String workspace, String storeName, File geotiff) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, CoverageStoreExtension.GEOTIFF, "image/geotiff", geotiff, ParameterConfigure.FIRST, null);
    }

    public boolean publishGeoTIFF(String workspace, String storeName, String coverageName, File geotiff) throws FileNotFoundException, IllegalArgumentException {
        NameValuePair[] nameValuePairArray;
        if (workspace == null || geotiff == null) {
            throw new IllegalArgumentException("Unable to proceed, some arguments are null");
        }
        String string = storeName != null ? storeName : FilenameUtils.getBaseName((String)geotiff.getAbsolutePath());
        if (coverageName != null) {
            NameValuePair[] nameValuePairArray2 = new NameValuePair[1];
            nameValuePairArray = nameValuePairArray2;
            nameValuePairArray2[0] = new NameValuePair("coverageName", coverageName);
        } else {
            nameValuePairArray = null;
        }
        return this.publishCoverage(workspace, string, CoverageStoreExtension.GEOTIFF, "image/geotiff", geotiff, ParameterConfigure.FIRST, nameValuePairArray);
    }

    public boolean publishGeoTIFF(String workspace, String storeName, String resourceName, File geotiff, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishGeoTIFF(workspace, storeName, resourceName, geotiff, srs, policy, defaultStyle, null);
    }

    public boolean publishGeoTIFF(String workspace, String storeName, String coverageName, File geotiff, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox) throws FileNotFoundException, IllegalArgumentException {
        if (workspace == null || storeName == null || geotiff == null || coverageName == null || srs == null || policy == null || defaultStyle == null) {
            throw new IllegalArgumentException("Unable to run: null parameter");
        }
        if (!this.createCoverageStore(workspace, storeName != null ? storeName : FilenameUtils.getBaseName((String)geotiff.getAbsolutePath()), UploadMethod.FILE, CoverageStoreExtension.GEOTIFF, "image/geotiff", geotiff.toURI(), ParameterConfigure.NONE, null)) {
            LOGGER.error("Unable to create coverage store for coverage: " + geotiff);
            return false;
        }
        GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
        coverageEncoder.setName(coverageName);
        coverageEncoder.setTitle(coverageName);
        coverageEncoder.setSRS(srs);
        coverageEncoder.setNativeFormat("GeoTIFF");
        coverageEncoder.addSupportedFormats("GEOTIFF");
        coverageEncoder.addKeyword("geoTiff");
        coverageEncoder.addKeyword("WCS");
        coverageEncoder.setNativeCRS(srs);
        coverageEncoder.setProjectionPolicy(policy);
        coverageEncoder.setRequestSRS(srs);
        coverageEncoder.setResponseSRS(srs);
        if (bbox != null && bbox.length == 4) {
            coverageEncoder.setLatLonBoundingBox(bbox[0], bbox[1], bbox[2], bbox[3], DEFAULT_CRS);
        }
        if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
            LOGGER.error("Unable to create a coverage store for coverage: " + geotiff);
            return false;
        }
        GSLayerEncoder layerEncoder = this.configureDefaultStyle(defaultStyle);
        return this.configureLayer(workspace, coverageName, layerEncoder);
    }

    public boolean publishExternalGeoTIFF(String workspace, String storeName, File geotiff, String coverageName, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        if (workspace == null || storeName == null || geotiff == null || coverageName == null || srs == null || policy == null || defaultStyle == null) {
            throw new IllegalArgumentException("Unable to run: null parameter");
        }
        GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
        coverageEncoder.setName(coverageName);
        coverageEncoder.setTitle(coverageName);
        coverageEncoder.setSRS(srs);
        coverageEncoder.setProjectionPolicy(policy);
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(defaultStyle);
        return this.publishExternalGeoTIFF(workspace, storeName, geotiff, coverageEncoder, layerEncoder) != null;
    }

    public RESTCoverageStore publishExternalGeoTIFF(String workspace, String storeName, File geotiff, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws IllegalArgumentException, FileNotFoundException {
        if (workspace == null || geotiff == null || storeName == null || layerEncoder == null || coverageEncoder == null) {
            throw new IllegalArgumentException("Unable to run: null parameter");
        }
        String coverageName = coverageEncoder.getName();
        if (coverageName.isEmpty()) {
            throw new IllegalArgumentException("Unable to run: empty coverage store name");
        }
        boolean store = this.publishExternalCoverage(workspace, storeName, CoverageStoreExtension.GEOTIFF, "text/plain", geotiff, ParameterConfigure.NONE, ParameterUpdate.OVERWRITE);
        if (!store) {
            return null;
        }
        if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to create a coverage for the store:" + coverageName);
            }
            return null;
        }
        if (this.configureLayer(workspace, coverageName, layerEncoder)) {
            try {
                GeoServerRESTReader reader = new GeoServerRESTReader(this.restURL, this.gsuser, this.gspass);
                return reader.getCoverageStore(workspace, storeName);
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean publishWorldImage(String workspace, String coveragestore, File zipFile) throws FileNotFoundException {
        return this.publishWorldImage(workspace, coveragestore, zipFile, ParameterConfigure.FIRST, new NameValuePair[]{null});
    }

    public boolean publishWorldImage(String workspace, String coveragestore, File zipFile, ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException {
        return this.publishCoverage(workspace, coveragestore, CoverageStoreExtension.WORLDIMAGE, "application/zip", zipFile, configure, params);
    }

    public boolean publishImageMosaic(String workspace, String storeName, File zipFile) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, CoverageStoreExtension.IMAGEMOSAIC, "application/zip", zipFile, ParameterConfigure.FIRST, null);
    }

    public boolean publishImageMosaic(String workspace, String storeName, File zipFile, ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, CoverageStoreExtension.IMAGEMOSAIC, "application/zip", zipFile, configure, params);
    }

    public RESTCoverageStore createExternaMosaicDatastore(String workspace, String storeName, File mosaicDir, ParameterConfigure configure, ParameterUpdate update) throws FileNotFoundException {
        if (!mosaicDir.isDirectory() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Directory '" + mosaicDir + "' not exists locally. Continue: please check existance on the remote server.");
        }
        String sUrl = this.restURL + "/rest/workspaces/" + workspace + "/coveragestores/" + storeName + "/external.imagemosaic?configure=" + configure.toString() + "&update=" + update.toString();
        String sendResult = HTTPUtils.put(sUrl, mosaicDir.toURI().toString(), "text/plain", this.gsuser, this.gspass);
        return RESTCoverageStore.build(sendResult);
    }

    public boolean publishExternalMosaic(String workspace, String storeName, File mosaicDir, String srs, String defaultStyle) throws FileNotFoundException {
        GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
        coverageEncoder.setSRS(srs);
        String name = FilenameUtils.getBaseName((String)mosaicDir.getName());
        coverageEncoder.setName(name);
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(defaultStyle);
        return this.publishExternalMosaic(workspace, storeName, mosaicDir, coverageEncoder, layerEncoder);
    }

    public boolean createExternalMosaic(String workspace, String storeName, File mosaicDir, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws FileNotFoundException {
        return this.publishExternalMosaic(workspace, storeName, mosaicDir, coverageEncoder, layerEncoder);
    }

    public boolean publishExternalMosaic(String workspace, String storeName, File mosaicDir, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws FileNotFoundException, IllegalArgumentException {
        if (coverageEncoder == null) {
            throw new IllegalArgumentException("no coverageEncoder provided for mosaic " + mosaicDir);
        }
        if (layerEncoder == null) {
            throw new IllegalArgumentException("no layerEncoder provided for " + mosaicDir);
        }
        RESTCoverageStore store = this.createExternaMosaicDatastore(workspace, storeName, mosaicDir, ParameterConfigure.NONE, ParameterUpdate.OVERWRITE);
        if (store == null) {
            return false;
        }
        String coverageName = coverageEncoder.getName();
        if (coverageName == null) {
            coverageName = mosaicDir.getName();
            coverageEncoder.setName(coverageName);
        }
        if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to create a coverage for the store:" + coverageName);
            }
            return false;
        }
        if (!this.configureLayer(workspace, coverageName, layerEncoder)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to configure the Layer for the coverage:" + coverageName);
            }
            return false;
        }
        return true;
    }

    public boolean unpublishCoverage(String workspace, String storename, String layerName) {
        try {
            boolean covDeleted;
            boolean layerDeleted;
            String fqLayerName;
            if (workspace == null) {
                fqLayerName = layerName;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Null workspace while configuring layer : " + layerName + " -- This behavior is deprecated.");
                }
            } else {
                fqLayerName = workspace + ":" + layerName;
            }
            URL deleteLayerUrl = new URL(this.restURL + "/rest/layers/" + fqLayerName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Going to delete /rest/layers/" + fqLayerName);
            }
            if (!(layerDeleted = HTTPUtils.delete(deleteLayerUrl.toExternalForm(), this.gsuser, this.gspass))) {
                LOGGER.warn("Could not delete layer '" + fqLayerName + "'");
                return false;
            }
            URL deleteCovUrl = new URL(this.restURL + "/rest/workspaces/" + workspace + "/coveragestores/" + storename + "/coverages/" + layerName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Going to delete /rest/workspaces/" + workspace + "/coveragestores/" + storename + "/coverages/" + layerName);
            }
            if (!(covDeleted = HTTPUtils.delete(deleteCovUrl.toExternalForm(), this.gsuser, this.gspass))) {
                LOGGER.warn("Could not delete coverage " + workspace + ":" + storename + "/" + layerName + ", but layer was deleted.");
            } else {
                LOGGER.info("Coverage successfully deleted " + workspace + ":" + storename + "/" + layerName);
            }
            return covDeleted;
        }
        catch (MalformedURLException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean unpublishFeatureType(String workspace, String storename, String layerName) {
        try {
            URL deleteLayerUrl;
            boolean layerDeleted;
            String fqLayerName;
            if (workspace == null) {
                fqLayerName = layerName;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Null workspace while configuring layer : " + layerName + " -- This behavior is deprecated.");
                }
            } else {
                fqLayerName = workspace + ":" + layerName;
            }
            if (!(layerDeleted = HTTPUtils.delete((deleteLayerUrl = new URL(this.restURL + "/rest/layers/" + fqLayerName)).toExternalForm(), this.gsuser, this.gspass))) {
                LOGGER.warn("Could not delete layer '" + fqLayerName + "'");
                return false;
            }
            URL deleteFtUrl = new URL(this.restURL + "/rest/workspaces/" + workspace + "/datastores/" + storename + "/featuretypes/" + layerName);
            boolean ftDeleted = HTTPUtils.delete(deleteFtUrl.toExternalForm(), this.gsuser, this.gspass);
            if (!ftDeleted) {
                LOGGER.warn("Could not delete featuretype " + workspace + ":" + storename + "/" + layerName + ", but layer was deleted.");
            } else {
                LOGGER.info("FeatureType successfully deleted " + workspace + ":" + storename + "/" + layerName);
            }
            return ftDeleted;
        }
        catch (MalformedURLException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean removeDatastore(String workspace, String storename) {
        try {
            return this.removeDatastore(workspace, storename, true);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Arguments may not be null or empty!", (Throwable)e);
            }
            return false;
        }
    }

    public boolean removeDatastore(String workspace, String storename, boolean recurse) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, StoreType.DATASTORES, recurse, Purge.NONE);
    }

    public boolean removeDatastore(String workspace, String storename, boolean recurse, Purge purge) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, StoreType.DATASTORES, recurse, purge);
    }

    public boolean removeCoverageStore(String workspace, String storename) {
        return this.removeCoverageStore(workspace, storename, true);
    }

    public boolean removeCoverageStore(String workspace, String storename, boolean recurse) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, StoreType.COVERAGESTORES, recurse, Purge.NONE);
    }

    public boolean removeCoverageStore(String workspace, String storename, boolean recurse, Purge purge) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, StoreType.COVERAGESTORES, recurse, purge);
    }

    private boolean removeStore(String workspace, String storename, StoreType type, boolean recurse, Purge purge) throws IllegalArgumentException {
        try {
            URL deleteStore;
            boolean deleted;
            if (workspace == null || storename == null) {
                throw new IllegalArgumentException("Arguments may not be null!");
            }
            if (workspace.isEmpty() || storename.isEmpty()) {
                throw new IllegalArgumentException("Arguments may not be empty!");
            }
            StringBuilder url = new StringBuilder(this.restURL);
            url.append("/rest/workspaces/").append(workspace).append("/").append((Object)type).append("/").append(storename);
            url.append("?recurse=").append(recurse);
            if (purge != null) {
                url.append("&purge=").append((Object)purge);
            }
            if (!(deleted = HTTPUtils.delete((deleteStore = new URL(url.toString())).toExternalForm(), this.gsuser, this.gspass))) {
                LOGGER.warn("Could not delete store " + workspace + ":" + storename);
            } else {
                LOGGER.info("Store successfully deleted " + workspace + ":" + storename);
            }
            return deleted;
        }
        catch (MalformedURLException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean removeWorkspace(String workspace) {
        return this.removeWorkspace(workspace, false);
    }

    public boolean removeWorkspace(String workspace, boolean recurse) throws IllegalArgumentException {
        workspace = this.sanitize(workspace);
        try {
            if (workspace == null) {
                throw new IllegalArgumentException("Arguments may not be null!");
            }
            if (workspace.isEmpty()) {
                throw new IllegalArgumentException("Arguments may not be empty!");
            }
            StringBuffer url = new StringBuffer(this.restURL).append("/rest/workspaces/").append(workspace);
            if (recurse) {
                url.append("?recurse=true");
            }
            this.deleteStylesForWorkspace(workspace);
            URL deleteUrl = new URL(url.toString());
            boolean deleted = HTTPUtils.delete(deleteUrl.toExternalForm(), this.gsuser, this.gspass);
            if (!deleted) {
                LOGGER.warn("Could not delete Workspace " + workspace);
            } else {
                LOGGER.info("Workspace successfully deleted " + workspace);
            }
            return deleted;
        }
        catch (MalformedURLException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    private void deleteStylesForWorkspace(String workspace) {
        RESTStyleList styles = this.styleManager.getStyles(workspace);
        if (styles == null) {
            return;
        }
        for (NameLinkElem nameLinkElem : styles) {
            this.removeStyleInWorkspace(workspace, nameLinkElem.getName(), true);
        }
    }

    public boolean removeLayerGroup(String workspace, String name) {
        String url = this.restURL + "/rest";
        url = workspace == null ? url + "/layergroups/" + name : url + "/workspaces/" + workspace + "/layergroups/" + name;
        try {
            URL deleteUrl = new URL(url);
            boolean deleted = HTTPUtils.delete(deleteUrl.toExternalForm(), this.gsuser, this.gspass);
            if (!deleted) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Could not delete layergroup " + name);
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Layergroup successfully deleted: " + name);
            }
            return deleted;
        }
        catch (MalformedURLException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean removeLayerGroup(String name) {
        return this.removeLayerGroup(null, name);
    }

    public boolean removeLayer(String workspace, String layerName) {
        String fqLayerName;
        if (workspace == null) {
            fqLayerName = layerName;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Null workspace while removing layer : " + layerName + " -- This behavior is deprecated.");
            }
        } else {
            fqLayerName = workspace + ":" + layerName;
        }
        if (layerName == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Null layerName : " + layerName);
            }
            return false;
        }
        String url = this.restURL + "/rest/layers/" + fqLayerName;
        boolean result = HTTPUtils.delete(url, this.gsuser, this.gspass);
        if (result) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Layer successfully removed: " + fqLayerName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error removing layer " + fqLayerName);
        }
        return result;
    }

    public boolean reloadStore(String workspace, String storeName, StoreType storeType) throws IllegalArgumentException, MalformedURLException {
        String url = HTTPUtils.append(this.restURL, "/rest/workspaces/", workspace, "/", storeType.toString(), "/", storeName, ".xml").toString();
        String store = HTTPUtils.get(url, this.gsuser, this.gspass);
        if (store != null) {
            String storeTag = storeType.getTypeName();
            String startTag = "<" + storeTag + ">";
            int start = store.indexOf(startTag);
            String endTag = "</" + storeTag + ">";
            int stop = store.indexOf(endTag) + endTag.length();
            return HTTPUtils.putXml(url, store.subSequence(0, start) + store.substring(stop), this.gsuser, this.gspass) != null;
        }
        return false;
    }

    public boolean reload() {
        String sUrl = this.restURL + "/rest/reload";
        String result = HTTPUtils.post(sUrl, "", "text/plain", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean reset() {
        String sUrl = this.restURL + "/rest/reset";
        String result = HTTPUtils.post(sUrl, "", "text/plain", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean configureLayer(String workspace, String resourceName, GSLayerEncoder layer) throws IllegalArgumentException {
        String layerXml;
        if (workspace == null || resourceName == null || layer == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (workspace.isEmpty() || resourceName.isEmpty() || layer.isEmpty()) {
            throw new IllegalArgumentException("Empty argument");
        }
        String fqLayerName = workspace + ":" + resourceName;
        String url = this.restURL + "/rest/layers/" + fqLayerName;
        String sendResult = HTTPUtils.putXml(url, layerXml = layer.toString(), this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Layer successfully configured: " + fqLayerName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring layer " + fqLayerName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean createLayerGroup(String name, GSLayerGroupEncoder group) {
        return this.createLayerGroup(null, name, group);
    }

    public boolean createLayerGroup(String workspace, String name, GSLayerGroupEncoder group) {
        String url = this.restURL + "/rest";
        if (workspace == null) {
            url = url + "/layergroups/";
        } else {
            group.setWorkspace(workspace);
            url = url + "/workspaces/" + workspace + "/layergroups/";
        }
        group.setName(name);
        String sendResult = HTTPUtils.postXml(url, group.toString(), this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("LayerGroup successfully configured: " + name);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring LayerGroup " + name + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean configureLayerGroup(String name, GSLayerGroupEncoder group) {
        return this.configureLayerGroup(null, name, group);
    }

    public boolean configureLayerGroup(String workspace, String name, GSLayerGroupEncoder group) {
        String url = this.restURL + "/rest";
        url = workspace == null ? url + "/layergroups/" + name : url + "/workspaces/" + workspace + "/layergroups/" + name;
        String sendResult = HTTPUtils.putXml(url, group.toString(), this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("LayerGroup successfully configured: " + name);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring LayerGroup " + name + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean configureCoverage(GSCoverageEncoder ce, String wsname, String csname) {
        return this.configureCoverage(ce, wsname, csname, ce.getName());
    }

    public boolean configureCoverage(GSCoverageEncoder ce, String wsname, String csname, String coverageName) {
        String xmlBody;
        GeoServerRESTReader reader;
        if (coverageName == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to configure a coverage with no name try using GSCoverageEncoder.setName(String)");
            }
            return false;
        }
        try {
            reader = new GeoServerRESTReader(this.restURL, this.gsuser, this.gspass);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
        RESTCoverage coverage = reader.getCoverage(wsname, csname, coverageName);
        if (coverage == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("No coverages found in new coveragestore " + csname + " called " + coverageName);
            }
            return false;
        }
        String url = this.restURL + "/rest/workspaces/" + wsname + "/coveragestores/" + csname + "/coverages/" + coverageName + ".xml";
        String sendResult = HTTPUtils.putXml(url, xmlBody = ce.toString(), this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Coverage successfully configured " + wsname + ":" + csname + ":" + coverageName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring coverage " + wsname + ":" + csname + ":" + coverageName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean createCoverage(GSCoverageEncoder ce, String wsname, String csname) {
        return this.createCoverage(wsname, csname, ce);
    }

    public boolean createCoverage(String wsname, String storeName, GSCoverageEncoder ce) throws IllegalArgumentException {
        return this.createResource(wsname, StoreType.COVERAGESTORES, storeName, ce);
    }

    private boolean createResource(String workspace, StoreType dsType, String storeName, GSResourceEncoder re) throws IllegalArgumentException {
        if (workspace == null || dsType == null || storeName == null || re == null) {
            throw new IllegalArgumentException("Null argument");
        }
        StringBuilder sbUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/").append((Object)dsType).append("/").append(storeName).append("/").append(dsType.getTypeNameWithFormat(Format.XML));
        String resourceName = re.getName();
        if (resourceName == null) {
            throw new IllegalArgumentException("Unable to configure a coverage using unnamed coverage encoder");
        }
        String xmlBody = re.toString();
        String sendResult = HTTPUtils.postXml(sbUrl.toString(), xmlBody, this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)((Object)dsType) + " successfully created " + workspace + ":" + storeName + ":" + resourceName);
            }
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Error creating coverage " + workspace + ":" + storeName + ":" + resourceName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    protected String sanitize(String s) {
        if (s.indexOf(".") != -1) {
            return s + ".DUMMY";
        }
        return s;
    }

    private String appendParameters(NameValuePair ... params) {
        int paramsSize;
        StringBuilder sbUrl = new StringBuilder();
        if (params != null && (paramsSize = params.length) > 0) {
            String value;
            String name;
            int i = 0;
            NameValuePair param = params[i];
            while (param != null && i++ < paramsSize) {
                name = param.getName();
                value = param.getValue();
                if (name != null && !name.isEmpty() && value != null && !value.isEmpty()) {
                    sbUrl.append(name).append("=").append(value);
                    param = null;
                    continue;
                }
                param = params[i];
            }
            while (i < paramsSize) {
                param = params[i];
                if (param != null) {
                    name = param.getName();
                    value = param.getValue();
                    sbUrl.append(name).append("=").append(value);
                    if (name != null && !name.isEmpty() && value != null && !value.isEmpty()) {
                        sbUrl.append("&").append(name).append("=").append(value);
                    }
                }
                ++i;
            }
        }
        return sbUrl.toString();
    }

    protected String encode(String s) {
        return URLEncoder.encode(s);
    }

    public boolean harvestExternal(String workspace, String coverageStore, String format, String path) {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.restURL), this.gsuser, this.gspass);
                return manager.harvestExternal(workspace, coverageStore, format, path);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean createImageMosaic(String workspace, String coverageStore, String path) {
        return this.createImageMosaic(workspace, coverageStore, path, GeoServerRESTStructuredGridCoverageReaderManager.ConfigureCoveragesOption.ALL);
    }

    public boolean createImageMosaic(String workspace, String coverageStore, String path, GeoServerRESTStructuredGridCoverageReaderManager.ConfigureCoveragesOption configureOpt) {
        GeoServerRESTPublisher.checkString(workspace);
        GeoServerRESTPublisher.checkString(coverageStore);
        GeoServerRESTPublisher.checkString(path);
        File zipFile = new File(path);
        if (!(zipFile.exists() && zipFile.isFile() && zipFile.canRead())) {
            throw new IllegalArgumentException("The provided pathname does not point to a valide zip file: " + path);
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            zip.getName();
        }
        catch (Exception e) {
            LOGGER.trace(e.getLocalizedMessage(), (Object[])e.getStackTrace());
            throw new IllegalArgumentException("The provided pathname does not point to a valide zip file: " + path);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    LOGGER.trace(e.getLocalizedMessage(), (Object[])e.getStackTrace());
                }
            }
        }
        StringBuilder ss = HTTPUtils.append(this.restURL, "/rest/workspaces/", workspace, "/coveragestores/", coverageStore, "/", UploadMethod.EXTERNAL.toString(), ".imagemosaic");
        switch (configureOpt) {
            case ALL: {
                break;
            }
            case NONE: {
                ss.append("?configure=none");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized COnfigureOption: " + (Object)((Object)configureOpt));
            }
        }
        String sUrl = ss.toString();
        String result = HTTPUtils.put(sUrl, zipFile, "application/zip", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean removeGranuleById(String workspace, String coverageStore, String coverage, String granuleId) {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.restURL), this.gsuser, this.gspass);
                return manager.removeGranuleById(workspace, coverageStore, coverage, granuleId);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean removeGranulesByCQL(String workspace, String coverageStore, String coverage, String filter) throws UnsupportedEncodingException {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.restURL), this.gsuser, this.gspass);
                return manager.removeGranulesByCQL(workspace, coverageStore, coverage, filter);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private static void checkString(String string) {
        if (string == null) {
            throw new NullPointerException("Provided string is is null!");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("Provided string is is empty!");
        }
    }

    public static enum Purge {
        NONE,
        METADATA,
        ALL;

    }

    public static enum Format {
        XML,
        JSON,
        HTML,
        SLD,
        SLD_1_1_0;


        public static String getContentType(Format f) {
            switch (f) {
                case XML: {
                    return "application/xml";
                }
                case HTML: {
                    return "application/html";
                }
                case JSON: {
                    return "application/json";
                }
                case SLD: {
                    return "application/vnd.ogc.sld+xml";
                }
                case SLD_1_1_0: {
                    return "application/vnd.ogc.se+xml";
                }
            }
            return null;
        }

        public String getContentType() {
            return Format.getContentType(this);
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum ParameterUpdate {
        APPEND,
        OVERWRITE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum ParameterConfigure {
        FIRST,
        NONE,
        ALL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum CoverageStoreExtension {
        GEOTIFF,
        IMAGEMOSAIC,
        WORLDIMAGE,
        ARCGRID;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum DataStoreExtension {
        SHP,
        PROPERTIES,
        H2,
        SPATIALITE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum UploadMethod {
        FILE,
        file,
        URL,
        url,
        EXTERNAL,
        external;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum StoreType {
        COVERAGESTORES,
        DATASTORES;


        public static String getTypeNameWithFormat(StoreType type, Format format) {
            return StoreType.getTypeName(type) + "." + (Object)((Object)format);
        }

        public String getTypeNameWithFormat(Format format) {
            return StoreType.getTypeName(this).toLowerCase() + "." + (Object)((Object)format);
        }

        public static String getTypeName(StoreType type) {
            switch (type) {
                case COVERAGESTORES: {
                    return "coverages";
                }
                case DATASTORES: {
                    return "featureTypes";
                }
            }
            return "coverages";
        }

        public static String getType(StoreType type) {
            switch (type) {
                case COVERAGESTORES: {
                    return "coverageStore";
                }
                case DATASTORES: {
                    return "dataStore";
                }
            }
            return "coverageStore";
        }

        public String getTypeName() {
            return StoreType.getTypeName(this);
        }

        public String getType() {
            return StoreType.getType(this);
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum DataStoreType {
        COVERAGESTORES,
        DATASTORES;


        public static String getTypeName(StoreType type) {
            return StoreType.getTypeNameWithFormat(type, Format.XML);
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

