/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.RESTLayerList;
import it.geosolutions.geoserver.rest.decoder.RESTPublishedList;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import org.jdom.Element;

public class RESTLayerGroup {
    private final Element rootElem;

    public static RESTLayerGroup build(String response) {
        Element elem = JDOMBuilder.buildElement(response);
        return elem == null ? null : new RESTLayerGroup(elem);
    }

    public RESTLayerGroup(Element layerElem) {
        this.rootElem = layerElem;
    }

    public String getName() {
        return this.rootElem.getChildText("name");
    }

    public String getWorkspace() {
        Element rootLayer = this.rootElem.getChild("workspace");
        if (rootLayer != null) {
            return rootLayer.getChildText("name");
        }
        return null;
    }

    public String getMode() {
        return this.rootElem.getChildText("mode");
    }

    public String getTitle() {
        return this.rootElem.getChildText("title");
    }

    public String getAbstract() {
        return this.rootElem.getChildText("abstractTxt");
    }

    public String getRootLayer() {
        Element rootLayer = this.rootElem.getChild("rootLayer");
        if (rootLayer != null) {
            return rootLayer.getChildText("name");
        }
        return null;
    }

    public RESTLayerList getLayerList() {
        if (this.rootElem.getChild("layers") != null) {
            return new RESTLayerList(this.rootElem.getChild("layers"));
        }
        return null;
    }

    public RESTPublishedList getPublishedList() {
        if (this.rootElem.getChild("publishables") != null) {
            return new RESTPublishedList(this.rootElem.getChild("publishables"));
        }
        return null;
    }

    public String getCRS() {
        Element bounds = this.rootElem.getChild("bounds");
        return bounds.getChildText("crs");
    }

    protected double getBound(String edge) {
        Element bounds = this.rootElem.getChild("bounds");
        return Double.parseDouble(bounds.getChildText(edge));
    }

    public double getMinX() {
        return this.getBound("minx");
    }

    public double getMaxX() {
        return this.getBound("maxx");
    }

    public double getMinY() {
        return this.getBound("miny");
    }

    public double getMaxY() {
        return this.getBound("maxy");
    }
}

