/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.authorityurl.GSAuthorityURLInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.identifier.GSIdentifierInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GSLayerEncoder
extends PropertyXMLEncoder {
    public static final String STYLES = "styles";
    public static final String AUTHORITY_URLS = "authorityURLs";
    public static final String IDENTIFIERS = "identifiers";
    public static final String DEFAULT_STYLE = "defaultStyle";
    private final Element stylesEncoder = new Element("styles");
    private final Element defaultStyleEncoder = new Element("defaultStyle");
    private final Element authorityURLListEncoder = new Element("authorityURLs");
    private final Element identifierListEncoder = new Element("identifiers");
    private static final String QUERYABLE = "queryable";

    public GSLayerEncoder() {
        super("layer");
        this.addEnabled();
        this.addContent((Content)this.stylesEncoder);
        this.addContent((Content)this.authorityURLListEncoder);
        this.addContent((Content)this.identifierListEncoder);
    }

    protected void addEnabled() {
        this.add("enabled", "true");
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.set("enabled", "true");
        } else {
            this.set("enabled", "false");
        }
    }

    protected void addQueryable(String queryable) {
        this.add(QUERYABLE, queryable != null ? queryable.toString() : "true");
    }

    public void setQueryable(Boolean queryable) {
        this.set(QUERYABLE, queryable != null ? queryable.toString() : "true");
    }

    protected void addWmsPath(String path) {
        this.add("path", path);
    }

    public void setWmsPath(String path) throws IllegalArgumentException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Unable to set an empty or null parameter");
        }
        this.set("path", path);
    }

    protected void addDefaultStyle(String defaultStyle) {
        this.add(DEFAULT_STYLE, defaultStyle);
    }

    protected void addDefaultStyle(String workspace, String defaultStyle) {
        this.addContent((Content)this.defaultStyleEncoder);
        Element el = new Element("name");
        el.setText(defaultStyle);
        this.defaultStyleEncoder.addContent((Content)el);
        el = new Element("workspace");
        el.setText(workspace);
        this.defaultStyleEncoder.addContent((Content)el);
    }

    public void setDefaultStyle(String defaultStyle) throws IllegalArgumentException {
        if (defaultStyle == null || defaultStyle.isEmpty()) {
            throw new IllegalArgumentException("Unable to set an empty or null parameter");
        }
        this.set(DEFAULT_STYLE, defaultStyle);
    }

    public void setDefaultStyle(String workspace, String defaultStyle) {
        this.remove(DEFAULT_STYLE);
        this.addDefaultStyle(workspace, defaultStyle);
    }

    public void addStyle(String style) {
        Element el = new Element("style");
        el.setText(style);
        this.stylesEncoder.addContent((Content)el);
    }

    public boolean delStyle(final String style) {
        Element el = new Element("style");
        el.setText(style);
        return this.stylesEncoder.removeContent(new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean matches(Object obj) {
                return ((Element)obj).getText().equals(style);
            }
        }).size() != 0;
    }

    public void setAdvertised(boolean advertised) {
        if (advertised) {
            this.set("advertised", "true");
        } else {
            this.set("advertised", "false");
        }
    }

    public void addAuthorityURL(GSAuthorityURLInfoEncoder authorityURLInfo) {
        this.authorityURLListEncoder.addContent((Content)authorityURLInfo.getRoot());
    }

    public boolean delAuthorityURL(String authorityURL) {
        return this.authorityURLListEncoder.removeContent(GSAuthorityURLInfoEncoder.getFilterByHref(authorityURL)).size() != 0;
    }

    public void addIdentifier(GSIdentifierInfoEncoder identifierInfo) {
        this.identifierListEncoder.addContent((Content)identifierInfo.getRoot());
    }

    public boolean delIdentifier(String authority) {
        return this.identifierListEncoder.removeContent(GSIdentifierInfoEncoder.getFilterByHref(authority)).size() != 0;
    }
}

