/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.coverage;

import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.dimensions.GSCoverageDimensionEncoder;
import it.geosolutions.geoserver.rest.encoder.metadata.GSDimensionInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import org.jdom.Content;
import org.jdom.Element;

public class GSCoverageEncoder
extends GSResourceEncoder {
    public static final String NATIVECOVERAGENAME = "nativeCoverageName";
    private static final String NATIVE_FORMAT = "nativeFormat";
    private static final String SUPPORTED_FORMATS = "supportedFormats";
    private static final String REQUEST_SRS = "requestSRS";
    private static final String RESPONSE_SRS = "responseSRS";
    private final Element supportedFormatsListEncoder = new Element("supportedFormats");
    public static final String DIMENSIONS = "dimensions";
    private final Element dimensionsEncoder = new Element("dimensions");

    public GSCoverageEncoder() {
        super("coverage");
        this.addContent((Content)this.supportedFormatsListEncoder);
    }

    protected void addMetadata(String key, GSDimensionInfoEncoder dimensionInfo) {
        super.addMetadata(key, dimensionInfo);
    }

    public void setMetadata(String key, GSDimensionInfoEncoder dimensionInfo) {
        super.setMetadata(key, dimensionInfo);
    }

    public void setNativeFormat(String format) {
        this.set(NATIVE_FORMAT, format);
    }

    public void addSupportedFormats(String format) {
        Element el = new Element("string");
        el.setText(format);
        this.supportedFormatsListEncoder.addContent((Content)el);
    }

    public void setRequestSRS(String srs) {
        Element el = new Element("string");
        el.setText(srs);
        this.set(REQUEST_SRS, (Content)el);
    }

    public void setResponseSRS(String srs) {
        Element el = new Element("string");
        el.setText(srs);
        this.set(RESPONSE_SRS, (Content)el);
    }

    public void addCoverageDimensionInfo(GSCoverageDimensionEncoder coverageDimensionInfo) {
        if (ElementUtils.contains(this.getRoot(), DIMENSIONS) == null) {
            this.addContent((Content)this.dimensionsEncoder);
        }
        this.dimensionsEncoder.addContent((Content)coverageDimensionInfo.getRoot());
    }

    public void addCoverageDimensionInfo(String name, String description, String rangeMin, String rangeMax, String unit, String dimensionType) {
        GSCoverageDimensionEncoder coverageDimensionEncoder = new GSCoverageDimensionEncoder(name, description, rangeMin, rangeMax, unit, dimensionType);
        this.addCoverageDimensionInfo(coverageDimensionEncoder);
    }

    public boolean delCoverageDimensionInfo(String coverageDimensionName) {
        return this.dimensionsEncoder.removeContent(GSCoverageDimensionEncoder.getFilterByContent(coverageDimensionName)).size() != 0;
    }

    public void addNativeCoverageName(String nativeCoverageName) {
        this.add(NATIVECOVERAGENAME, nativeCoverageName);
    }

    public void setNativeCoverageName(String nativeCoverageName) {
        this.set(NATIVECOVERAGENAME, nativeCoverageName);
    }

    public String getNativeCoverageName() {
        Element nativeCoverageNameNode = ElementUtils.contains(this.getRoot(), NATIVECOVERAGENAME, 1);
        if (nativeCoverageNameNode != null) {
            return nativeCoverageNameNode.getText();
        }
        return null;
    }
}

