/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.dimensions;

import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GSCoverageDimensionEncoder
extends XmlElement {
    public static Filter getFilterByContent(String content) {
        return new filterByContent(content);
    }

    public GSCoverageDimensionEncoder() {
        super("coverageDimension");
    }

    public GSCoverageDimensionEncoder(String name, String description, String rangeMin, String rangeMax, String unit, String dimensionTypeName) {
        super("coverageDimension");
        this.setup(name, description, rangeMin, rangeMax, unit, dimensionTypeName);
    }

    protected void setup(String name, String description, String rangeMin, String rangeMax, String unit, String dimensionTypeName) {
        this.setName(name);
        this.setDescription(description);
        this.setRange(rangeMin, rangeMax);
        this.setUnit(unit);
        this.setDimensionType(dimensionTypeName);
    }

    protected String getMember(String memberName) {
        Element el = this.getRoot().getChild(memberName.toString());
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    protected boolean delMemberIfExists(String memberName) {
        if (ElementUtils.contains(this.getRoot(), memberName) != null) {
            return ElementUtils.remove(this.getRoot(), this.getRoot().getChild(memberName.toString()));
        }
        return false;
    }

    protected void setMember(String memberName, String memberValue) {
        if (memberName != null && !memberName.isEmpty() && memberValue != null && !memberValue.isEmpty()) {
            this.delMemberIfExists(memberName);
            this.addMember(memberName.toString(), memberValue);
        }
    }

    protected void addMember(String memberName, String memberValue) {
        if (memberName != null && !memberName.isEmpty() && memberValue != null && !memberValue.isEmpty()) {
            this.set(memberName.toString(), memberValue);
        }
    }

    public void setName(String name) {
        this.setMember("name", name);
    }

    public boolean delName() {
        return this.delMemberIfExists("name");
    }

    public String getName() {
        return this.getMember("name");
    }

    public void setDescription(String description) {
        this.setMember("description", description);
    }

    public boolean delDescription() {
        return this.delMemberIfExists("description");
    }

    public String getDescription() {
        return this.getMember("description");
    }

    public void setRange(String rangeMin, String rangeMax) {
        if (rangeMin != null && !rangeMin.isEmpty() && rangeMax != null && !rangeMax.isEmpty()) {
            this.remove("range");
            Element rangeElement = new Element("range");
            Element rangeMinElement = new Element("min");
            rangeMinElement.setText(rangeMin);
            Element rangeMaxElement = new Element("max");
            rangeMaxElement.setText(rangeMax);
            rangeElement.addContent((Content)rangeMinElement);
            rangeElement.addContent((Content)rangeMaxElement);
            this.addContent((Content)rangeElement);
        }
    }

    public boolean delRange() {
        return this.delMemberIfExists("range");
    }

    public String getRangeMin() {
        Element range = this.getRoot().getChild("range");
        if (range != null) {
            return range.getChildText("min");
        }
        return null;
    }

    public String getRangeMax() {
        Element range = this.getRoot().getChild("range");
        if (range != null) {
            return range.getChildText("max");
        }
        return null;
    }

    public void setUnit(String unit) {
        this.setMember("unit", unit);
    }

    public boolean delUnit() {
        return this.delMemberIfExists("unit");
    }

    public String getUnit() {
        return this.getMember("unit");
    }

    public void setDimensionType(String dimensionTypeName) {
        if (dimensionTypeName != null && !dimensionTypeName.isEmpty()) {
            this.remove("dimensionType");
            Element dimensionTypeElement = new Element("dimensionType");
            Element dimensionNameElement = new Element("name");
            dimensionNameElement.setText(dimensionTypeName);
            dimensionTypeElement.addContent((Content)dimensionNameElement);
            this.addContent((Content)dimensionTypeElement);
        }
    }

    public boolean delDimensionType() {
        return this.delMemberIfExists("dimensionType");
    }

    public String getDimensionTypeName() {
        Element dimensionType = this.getRoot().getChild("dimensionType");
        if (dimensionType != null) {
            return dimensionType.getChildText("name");
        }
        return null;
    }

    private static class filterByContent
    implements Filter {
        private final String key;
        private static final long serialVersionUID = 1L;

        public filterByContent(String content) {
            this.key = content;
        }

        public boolean matches(Object obj) {
            Element el = ((Element)obj).getChild("name");
            return el != null && el.getTextTrim().equals(this.key);
        }
    }
}

