/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageioimpl.plugins.cog.HttpConfigurationProperties;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class HttpClientFactory {
    private static OkHttpClient client;
    private static HttpConfigurationProperties configProps;

    public static OkHttpClient getClient() {
        if (client != null) {
            return client;
        }
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(configProps.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(configProps.getMaxRequestsPerHost());
        ConnectionPool connectionPool = new ConnectionPool(configProps.getMaxIdleConnections(), (long)configProps.getKeepAliveDuration(), TimeUnit.SECONDS);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(dispatcher).connectionPool(connectionPool);
        client = clientBuilder.build();
        return client;
    }

    static {
        configProps = new HttpConfigurationProperties();
    }
}

