/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.ImageHeaderBox;
import javax.imageio.metadata.IIOMetadataNode;

public class ImageHeaderBoxMetadataNode
extends BaseJP2KBoxMetadataNode {
    private String height;
    private String width;
    private String numComponents;
    private String bitDepth;
    private String bitDepthInterpretation;
    private String compressionType;
    private String intellectualProperty;
    private String unknownColorspace;

    ImageHeaderBoxMetadataNode(ImageHeaderBox box) {
        super(box);
        short nc = box.getNumComponents();
        this.numComponents = Short.toString(nc);
        byte bdepth = box.getBitDepth();
        this.bitDepth = Byte.toString(bdepth);
        byte bdepthInterp = box.getBitDepthInterpretation();
        this.bitDepthInterpretation = Byte.toString(bdepthInterp);
        byte ct = box.getCompressionType();
        this.compressionType = Byte.toString(ct);
        int h = box.getHeight();
        this.height = Integer.toString(h);
        int w = box.getWidth();
        this.width = Integer.toString(w);
        byte ip = box.getIntellectualProperty();
        this.intellectualProperty = Byte.toString(ip);
        byte ucs = box.getUnknownColorspace();
        this.unknownColorspace = Byte.toString(ucs);
        try {
            IIOMetadataNode child = new IIOMetadataNode("Height");
            child.setUserObject(h);
            child.setNodeValue(this.height);
            this.appendChild(child);
            child = new IIOMetadataNode("Width");
            child.setUserObject(w);
            child.setNodeValue(this.width);
            this.appendChild(child);
            child = new IIOMetadataNode("NumComponents");
            child.setUserObject(nc);
            child.setNodeValue(this.numComponents);
            this.appendChild(child);
            child = new IIOMetadataNode("BitDepth");
            child.setUserObject(bdepth);
            child.setNodeValue(this.bitDepth);
            this.appendChild(child);
            child = new IIOMetadataNode("BitDepthInterpretation");
            child.setUserObject(bdepthInterp);
            child.setNodeValue(this.bitDepthInterpretation);
            this.appendChild(child);
            child = new IIOMetadataNode("CompressionType");
            child.setUserObject(ct);
            child.setNodeValue(this.compressionType);
            this.appendChild(child);
            child = new IIOMetadataNode("UnknownColorspace");
            child.setUserObject(ucs);
            child.setNodeValue(this.unknownColorspace);
            this.appendChild(child);
            child = new IIOMetadataNode("IntellectualProperty");
            child.setUserObject(ip);
            child.setNodeValue(this.intellectualProperty);
            this.appendChild(child);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("BoxMetadataNode0");
        }
    }

    public String getHeight() {
        return this.height;
    }

    public String getWidth() {
        return this.width;
    }

    public String getNumComponents() {
        return this.numComponents;
    }

    public String getBitDepth() {
        return this.bitDepth;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public String getIntellectualProperty() {
        return this.intellectualProperty;
    }

    public String getUnknownColorspace() {
        return this.unknownColorspace;
    }

    public String getBitDepthInterpretation() {
        return this.bitDepthInterpretation;
    }
}

