/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import com.sun.media.imageioimpl.common.ImageUtil;
import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UUIDListBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1970041716;
    public static final String NAME = "ulst";
    public static final String JP2K_MD_NAME = "JP2KUUIDListBox";
    private short num;
    private byte[][] uuids;
    private byte[] localData;

    public UUIDListBox(short num, byte[][] uuids) {
        super(10 + (uuids.length << 4), 1970041716, null);
        this.num = num;
        this.uuids = uuids;
    }

    public UUIDListBox(byte[] data) {
        super(8 + data.length, 1970041716, data);
    }

    public UUIDListBox(Node node) throws IIOInvalidTreeException {
        super(node);
        Node child;
        int i;
        NodeList children = node.getChildNodes();
        int index = 0;
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!"NumberUUID".equals(child.getNodeName())) continue;
            this.num = BoxUtilities.getShortElementValue(child);
            this.uuids = new byte[this.num][];
        }
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!"UUID".equals(child.getNodeName()) || index >= this.num) continue;
            this.uuids[index++] = BoxUtilities.getByteArrayElementValue(child);
        }
    }

    @Override
    protected void parse(byte[] data) {
        this.num = (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        this.uuids = new byte[this.num][];
        int pos = 2;
        for (int i = 0; i < this.num; ++i) {
            this.uuids[i] = new byte[16];
            System.arraycopy(data, pos, this.uuids[i], 0, 16);
            pos += 16;
        }
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode(BoxUtilities.getName(this.getType()));
        this.setDefaultAttributes(node);
        IIOMetadataNode child = new IIOMetadataNode("NumberUUID");
        child.setUserObject(new Short(this.num));
        child.setNodeValue("" + this.num);
        node.appendChild(child);
        for (int i = 0; i < this.num; ++i) {
            child = new IIOMetadataNode("UUID");
            child.setUserObject(this.uuids[i]);
            child.setNodeValue(ImageUtil.convertObjectToString((Object)this.uuids[i]));
            node.appendChild(child);
        }
        return node;
    }

    @Override
    protected synchronized byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = new byte[2 + this.num * 16];
        this.localData[0] = (byte)(this.num >> 8);
        this.localData[1] = (byte)(this.num & 0xFF);
        int pos = 2;
        for (int i = 0; i < this.num; ++i) {
            System.arraycopy(this.uuids[i], 0, this.localData, pos, 16);
            pos += 16;
        }
        return this.localData;
    }

    short getNum() {
        return this.num;
    }

    byte[][] getUuids() {
        return this.uuids;
    }
}

