/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.util;

import it.geosolutions.util.Kdu_sysout_message;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import kdu_jni.Jp2_channels;
import kdu_jni.KduException;
import kdu_jni.Kdu_global;
import kdu_jni.Kdu_message;
import kdu_jni.Kdu_message_formatter;

public class KakaduUtilities {
    public static final double DOUBLE_TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.util");
    private static boolean available;
    private static boolean init;
    public static final double BIT_TO_BYTE_FACTOR = 0.125;

    private KakaduUtilities() {
    }

    public static int[] findOptimalResolutionInfo(int sourceDWTLevels, int newSubSamplingFactor) {
        int levels = sourceDWTLevels;
        int optimalSubSamplingFactor = 1;
        int discardLevels = 0;
        for (int level = 0; level < levels + 1; ++level) {
            if (optimalSubSamplingFactor < newSubSamplingFactor) {
                optimalSubSamplingFactor = 1 << level;
                continue;
            }
            if (optimalSubSamplingFactor > newSubSamplingFactor) {
                optimalSubSamplingFactor >>= 1;
                break;
            }
            if (optimalSubSamplingFactor == newSubSamplingFactor) break;
        }
        int decreasingSSF = optimalSubSamplingFactor;
        for (discardLevels = 0; discardLevels < levels && decreasingSSF > 1; decreasingSSF >>= 1, ++discardLevels) {
        }
        return new int[]{optimalSubSamplingFactor, discardLevels};
    }

    public static void initializeKakaduMessagesManagement() {
        try {
            Kdu_sysout_message sysout = new Kdu_sysout_message(false);
            Kdu_sysout_message syserr = new Kdu_sysout_message(true);
            Kdu_message_formatter pretty_sysout = new Kdu_message_formatter((Kdu_message)sysout);
            Kdu_message_formatter pretty_syserr = new Kdu_message_formatter((Kdu_message)syserr);
            Kdu_global.Kdu_customize_warnings((Kdu_message)pretty_sysout);
            Kdu_global.Kdu_customize_errors((Kdu_message)pretty_syserr);
        }
        catch (KduException e) {
            throw new RuntimeException("Error caused by a Kakadu exception during creation of key objects! ", e);
        }
    }

    public static List<ImageReaderWriterSpi> getJDKImageReaderWriterSPI(ServiceRegistry registry, String formatName, boolean isReader) {
        if (registry == null || !(registry instanceof IIORegistry)) {
            throw new IllegalArgumentException("Illegal registry provided");
        }
        IIORegistry iioRegistry = (IIORegistry)registry;
        Class spiClass = isReader ? ImageReaderSpi.class : ImageWriterSpi.class;
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            String[] formatNames = provider.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static BufferedImage subsampleImage(ColorModel cm, BufferedImage bi, int destinationWidth, int destinationHeight, int interpolationType) {
        AffineTransform at = new AffineTransform((float)destinationWidth / (float)bi.getWidth(), 0.0f, 0.0f, (float)destinationHeight / (float)bi.getHeight(), 0.0f, 0.0f);
        int interpolation = interpolationType == 1 ? 1 : 2;
        AffineTransformOp op = new AffineTransformOp(at, interpolation);
        return op.filter(bi, null);
    }

    public static boolean isKakaduAvailable() {
        KakaduUtilities.loadKakadu();
        return available;
    }

    public static synchronized void loadKakadu() {
        if (init) {
            return;
        }
        init = true;
        try {
            System.loadLibrary("kdu_jni");
            available = true;
            String nativeVersion = KakaduUtilities.getKakaduNativeLibVersion();
            String jniVersion = KakaduUtilities.getKakaduJniLibVersion();
            if (jniVersion.equalsIgnoreCase(nativeVersion)) {
                LOGGER.info(String.format("Kakadu native library: %s, JNI library: %s", nativeVersion, jniVersion));
            } else {
                LOGGER.warning(String.format("Kakadu JNI/native version mismatch: native library: %s, JNI library: %s", nativeVersion, jniVersion));
            }
        }
        catch (UnsatisfiedLinkError e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Failed to load the Kakadu native libs. This is not a problem unless you need to use the Kakadu plugin: it won't be enabled. " + e.toString());
            }
            available = false;
        }
    }

    public static void computeRegions(Rectangle sourceBounds, Dimension destSize, ImageWriteParam param) {
        int periodX = 1;
        int periodY = 1;
        if (param != null) {
            int[] sourceBands = param.getSourceBands();
            if (sourceBands != null && (sourceBands.length != 1 || sourceBands[0] != 0)) {
                throw new IllegalArgumentException("Cannot sub-band image!");
            }
            Rectangle sourceRegion = param.getSourceRegion();
            if (sourceRegion != null) {
                sourceRegion = sourceRegion.intersection(sourceBounds);
                sourceBounds.setBounds(sourceRegion);
            }
            periodX = param.getSourceXSubsampling();
            periodY = param.getSourceYSubsampling();
            int gridX = param.getSubsamplingXOffset();
            int gridY = param.getSubsamplingYOffset();
            sourceBounds.x += gridX;
            sourceBounds.y += gridY;
            sourceBounds.width -= gridX;
            sourceBounds.height -= gridY;
        }
        destSize.setSize((sourceBounds.width + periodX - 1) / periodX, (sourceBounds.height + periodY - 1) / periodY);
        if (destSize.width <= 0 || destSize.height <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
    }

    public static boolean notEqual(double value, double reference) {
        return Math.abs(value - reference) > 1.0E-6;
    }

    public static String readTerminatedString(byte[] contents) {
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < contents.length; ++i) {
            int c = contents[i];
            if (c == 0 || c == -1) {
                if (i == contents.length - 1) break;
                c = 10;
            }
            builder.append((char)c);
        }
        return builder.toString();
    }

    public static String getKakaduJniLibVersion() {
        String v = "v5.2.6";
        return v;
    }

    public static int getKakaduJniMajorVersion() {
        String versionString = KakaduUtilities.getKakaduJniLibVersion();
        return KakaduUtilities.parseMajorVersion(versionString);
    }

    public static String getKakaduNativeLibVersion() {
        String kduCoreVersion;
        try {
            kduCoreVersion = Kdu_global.Kdu_get_core_version();
        }
        catch (KduException e) {
            throw new RuntimeException("Error querying kakadu version ", e);
        }
        return kduCoreVersion;
    }

    private static int parseMajorVersion(String versionString) {
        String majorString = versionString.substring(0, versionString.indexOf(46));
        majorString = majorString.replaceAll("v", "");
        int majorVersion = Integer.parseInt(majorString);
        return majorVersion;
    }

    public static void initializeRGBChannels(Jp2_channels channels) throws KduException {
        Object[] args3;
        Object[] args2;
        Object[] args1;
        Method setColourMapping;
        int numColours = 3;
        channels.Init(3);
        int major = KakaduUtilities.getKakaduJniMajorVersion();
        try {
            if (major < 7) {
                setColourMapping = Jp2_channels.class.getMethod("Set_colour_mapping", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                args1 = new Object[]{0, 0, 0};
                args2 = new Object[]{1, 0, 1};
                args3 = new Object[]{2, 0, 2};
            } else {
                setColourMapping = Jp2_channels.class.getMethod("Set_colour_mapping", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                boolean _codestream_idx = false;
                boolean _data_format = false;
                args1 = new Object[]{0, 0, 0, 0, 0};
                args2 = new Object[]{1, 0, 1, 0, 0};
                args3 = new Object[]{2, 0, 2, 0, 0};
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Unable to acquire method Jp2_channels.Set_colour_mapping reflectively", e);
        }
        try {
            setColourMapping.invoke((Object)channels, args1);
            setColourMapping.invoke((Object)channels, args2);
            setColourMapping.invoke((Object)channels, args3);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Error calling Jp2_channels.Set_colour_mapping(...)", e);
        }
    }

    static {
        init = false;
    }
}

