/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.aop.Advised;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.CacheInterceptor;
import org.jboss.cache.aop.CachedListInterceptor;
import org.jboss.cache.aop.CachedMapInterceptor;
import org.jboss.cache.aop.CachedSetInterceptor;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.CollectionInterceptorUtil;
import org.jboss.cache.aop.TreeCacheAopMBean;
import org.jboss.cache.eviction.AopEvictionPolicy;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.JChannel;

public class TreeCacheAop
extends TreeCache
implements TreeCacheAopMBean {
    protected Map cachedTypes = new WeakHashMap();
    public static final String CLASS_INTERNAL = "jboss:internal:class";
    public static final Fqn JBOSS_INTERNAL = new Fqn("JBossInternal");
    public static final String DUMMY = "dummy";
    TransactionManager localTm_ = BatchModeTransactionManager.getInstance();
    static /* synthetic */ Class class$org$jboss$aop$Advised;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;

    public TreeCacheAop(String cluster_name, String props, long state_fetch_timeout) throws Exception {
        super(cluster_name, props, state_fetch_timeout);
    }

    public TreeCacheAop() throws Exception {
    }

    public TreeCacheAop(JChannel channel) throws Exception {
        super(channel);
    }

    public void setEvictionPolicyClass(String eviction_policy_class) {
        this.eviction_policy_class = eviction_policy_class;
        if (eviction_policy_class == null || eviction_policy_class.length() == 0) {
            return;
        }
        try {
            Object obj = this.getClass().getClassLoader().loadClass(eviction_policy_class).newInstance();
            if (!(obj instanceof AopEvictionPolicy)) {
                throw new RuntimeException("TreeCacheAop.setEvictionPolicyClass(). Eviction policy provider:" + eviction_policy_class + " is not an instance of AopEvictionPolicy.");
            }
            this.eviction_policy_provider = (TreeCacheListener)obj;
            this.addTreeCacheListener(this.eviction_policy_provider);
        }
        catch (RuntimeException ex) {
            this.log.error((Object)("setEvictionPolicyClass(): failed creating instance of  " + eviction_policy_class), (Throwable)ex);
            throw ex;
        }
        catch (Throwable t) {
            this.log.error((Object)("setEvictionPolicyClass(): failed creating instance of  " + eviction_policy_class), t);
        }
    }

    public Object putObject(String fqn, Object obj) throws CacheException {
        return this.putObject(Fqn.fromString(fqn), obj);
    }

    public Object putObject(Fqn fqn, Object obj) throws CacheException {
        if (this.hasCurrentTransaction()) {
            return this._putObject(fqn, obj);
        }
        try {
            this.localTm_.begin();
            this.put(fqn, (Object)DUMMY, (Object)DUMMY);
            Object objOld = this._putObject(fqn, obj);
            this.remove(fqn, (Object)DUMMY);
            Object object = objOld;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.localTm_.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            throw new NestedRuntimeException("TreeCacheAop.putObject(): ", (Throwable)e);
        }
        finally {
            this.endTransaction();
        }
    }

    protected void endTransaction() {
        try {
            if (this.localTm_.getTransaction().getStatus() != 1) {
                this.localTm_.commit();
            } else {
                this.localTm_.rollback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NestedRuntimeException("TreeCacheAop.endTransaction(): ", (Throwable)e);
        }
    }

    public Object _putObject(Fqn fqn, Object obj) throws CacheException {
        this.checkObjectType(obj);
        AOPInstance aopInstance = (AOPInstance)this.peek(fqn, AOPInstance.KEY);
        boolean isSameClass = false;
        Object oldValue = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putObject(): fqn: " + fqn));
        }
        if (aopInstance != null) {
            if (aopInstance.get() == obj) {
                return obj;
            }
            if (obj == null) {
                return this.removeObject(fqn);
            }
            this.log.debug((Object)("putObject(): old class type: " + aopInstance.get()));
            if (obj.getClass().isInstance(aopInstance.get())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"putObject(): obj is same class type as the old one");
                }
                oldValue = this.getObject(fqn);
                isSameClass = true;
            } else {
                oldValue = this.removeObject(fqn);
            }
        } else {
            Class claz1 = (Class)this.peek(fqn, CLASS_INTERNAL);
            if (claz1 != null && obj.getClass().getName().equals(claz1.getName())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"putObject(): obj is same class type as the old one");
                }
                isSameClass = true;
            }
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof Advised) {
            CachedType type = this.getCachedType(obj.getClass());
            Fqn internalFqn = null;
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            internalFqn = this.checkCircularReference(fqn, advisor, obj);
            if (internalFqn != null) {
                this.removeObject(fqn);
                aopInstance = new AOPInstance();
                aopInstance.setRefFqn(internalFqn.toString());
                this.put(fqn, AOPInstance.KEY, (Object)aopInstance);
                this.put(fqn, (Object)CLASS_INTERNAL, (Object)type.getType());
                return oldValue;
            }
            internalFqn = this.handleObjectGraph(fqn, advisor, type, obj);
            if (internalFqn != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("putObject(): detected multiple references. Will use as a reference instead. Current fqn: " + fqn + " Reference fqn: " + internalFqn));
                }
                this.removeObject(fqn);
                aopInstance = new AOPInstance();
                this.setRefFqn(aopInstance, internalFqn.toString());
                this.put(fqn, AOPInstance.KEY, (Object)aopInstance);
                this.put(fqn, (Object)CLASS_INTERNAL, (Object)type.getType());
                return oldValue;
            }
            if (advisor == null) {
                advisor = new ClassInstanceAdvisor(obj);
                ((Advised)obj)._setInstanceAdvisor(advisor);
            }
            advisor.appendInterceptor((Interceptor)new CacheInterceptor(this, fqn, type));
            this.put(fqn, (Object)CLASS_INTERNAL, (Object)type.getType());
            Iterator i = type.getFields().iterator();
            while (i.hasNext()) {
                Field field = (Field)i.next();
                Object value = null;
                try {
                    value = field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new CacheException("field access failed", e);
                }
                CachedType fieldType = this.getCachedType(field.getType());
                if (fieldType.isImmediate()) {
                    this.put(fqn, (Object)field.getName(), value);
                    continue;
                }
                Fqn tmpFqn = new Fqn(fqn, field.getName());
                this._putObject(tmpFqn, value);
                if (!(value instanceof Map) && !(value instanceof List) && !(value instanceof Set)) continue;
                Object newValue = this.getObject(tmpFqn);
                try {
                    field.set(obj, newValue);
                }
                catch (IllegalAccessException e) {
                    this.log.error((Object)("_putObject(): Can't swap out the Collection class of field " + field.getName() + "Exception " + e));
                    throw new CacheException("_putObject(): Can't swap out the Collection class of field \" +field.getName()," + e);
                }
            }
            this.put(fqn, AOPInstance.KEY, (Object)new AOPInstance(obj));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("putObject(): inserting with fqn: " + fqn.toString()));
            }
        } else if (obj instanceof Map) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("putObject(): aspectized obj is a Map type of size: " + ((Map)obj).size()));
            }
            this.removeObject(fqn);
            this.put(fqn, (Object)CLASS_INTERNAL, obj.getClass());
            Object oldObj = obj;
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createProxy(clazz, new CachedMapInterceptor(this, fqn, clazz));
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            Map map = (Map)oldObj;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this._putObject(new Fqn(fqn, entry.getKey()), entry.getValue());
            }
            this.put(fqn, AOPInstance.KEY, (Object)new AOPInstance(obj));
        } else if (obj instanceof List) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("putObject(): aspectized obj is a List type of size: " + ((List)obj).size()));
            }
            List list = (List)obj;
            this.removeObject(fqn);
            this.put(fqn, (Object)CLASS_INTERNAL, obj.getClass());
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createProxy(clazz, new CachedListInterceptor(this, fqn, clazz));
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            int idx = 0;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this._putObject(new Fqn(fqn, new Integer(idx++)), i.next());
            }
            this.put(fqn, AOPInstance.KEY, (Object)new AOPInstance(obj));
        } else if (obj instanceof Set) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("putObject(): aspectized obj is a Set type of size: " + ((Set)obj).size()));
            }
            Set set = (Set)obj;
            this.removeObject(fqn);
            this.put(fqn, (Object)CLASS_INTERNAL, obj.getClass());
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createProxy(clazz, new CachedSetInterceptor(this, fqn, clazz));
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            int idx = 0;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                this._putObject(new Fqn(fqn, new Integer(idx++)), i.next());
            }
            this.put(fqn, AOPInstance.KEY, (Object)new AOPInstance(obj));
        } else if (obj instanceof Serializable) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("putObject(): obj (" + obj.getClass() + ") is non-advisable but is Serializable. "));
            }
            if (!isSameClass) {
                this.put(fqn, (Object)CLASS_INTERNAL, obj.getClass());
            }
            this.put(fqn, AOPInstance.KEY, (Object)new AOPInstance(obj));
            this.put(fqn, (Object)"value", obj);
        }
        return oldValue;
    }

    protected void checkObjectType(Object obj) {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof Advised) && !(obj instanceof Serializable)) {
            throw new IllegalArgumentException("TreeCacheAop.putObject(): Object type is neither  aspectized nor Serializable. Object class name is " + obj.getClass().getName());
        }
    }

    protected Fqn checkCircularReference(Fqn fqn, InstanceAdvisor advisor, Object obj) {
        if (advisor == null) {
            return null;
        }
        Fqn originalFqn = null;
        Interceptor interceptor = this.findCacheInterceptor(advisor);
        if (interceptor == null) {
            return null;
        }
        originalFqn = ((CacheInterceptor)interceptor).getFqn();
        if (fqn.isChildOf(originalFqn)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("checkCircularReference(): is child for circular ref fqn " + originalFqn));
            }
            return originalFqn;
        }
        return null;
    }

    protected Fqn handleObjectGraph(Fqn fqn, InstanceAdvisor advisor, CachedType type, Object obj) throws CacheException {
        if (advisor == null) {
            return null;
        }
        Fqn originalFqn = null;
        Fqn internalFqn = null;
        Interceptor interceptor = this.findCacheInterceptor(advisor);
        if (interceptor == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("handleMultipleReference(): No multiple refernce found for fqn: " + fqn));
            }
            return null;
        }
        originalFqn = ((CacheInterceptor)interceptor).getFqn();
        if (fqn.equals(originalFqn)) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("handleObjectGraph(): Found multiple refernce at original fqn: " + originalFqn));
        }
        if (originalFqn.isChildOf(JBOSS_INTERNAL)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("handleObjectGraph(): is child for fqn " + originalFqn));
            }
            return originalFqn;
        }
        internalFqn = this.createInternalNode(originalFqn);
        Object oldValue = this.removeObject(originalFqn);
        this.putObject(internalFqn, obj);
        AOPInstance instance = new AOPInstance();
        this.setRefFqn(instance, internalFqn.toString());
        this.put(originalFqn, AOPInstance.KEY, (Object)instance);
        this.put(originalFqn, (Object)CLASS_INTERNAL, (Object)type.getType());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("handleObjectGraph(): relocate the original fqn: " + originalFqn + " to JBossInternal: " + internalFqn + " with obj: " + oldValue));
        }
        return internalFqn;
    }

    protected Interceptor findCacheInterceptor(InstanceAdvisor advisor, Fqn fqn) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            CacheInterceptor inter;
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof CacheInterceptor) || (inter = (CacheInterceptor)interceptor) == null || !inter.getFqn().equals(fqn)) continue;
            return interceptor;
        }
        return null;
    }

    protected Interceptor findCacheInterceptor(InstanceAdvisor advisor) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof CacheInterceptor)) continue;
            return interceptor;
        }
        return null;
    }

    protected Fqn createInternalNode(Fqn storedFqn) {
        Fqn fqn = new Fqn(JBOSS_INTERNAL, storedFqn);
        return fqn;
    }

    public Object getObject(String fqn) throws CacheException {
        return this.getObject(Fqn.fromString(fqn));
    }

    protected boolean hasCurrentTransaction() {
        try {
            if (this.getCurrentTransaction() != null || this.localTm_.getTransaction() != null) {
                return true;
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Object getObject(Fqn fqn) throws CacheException {
        if (this.hasCurrentTransaction()) {
            Object obj = this._getObject(fqn);
            return obj;
        }
        try {
            this.localTm_.begin();
            this.put(fqn, (Object)DUMMY, (Object)DUMMY);
            Object obj = this._getObject(fqn);
            this.remove(fqn, (Object)DUMMY);
            Object object = obj;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.localTm_.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            throw new NestedRuntimeException("TreeCacheAop.getObject(): ", (Throwable)e);
        }
        finally {
            this.endTransaction();
        }
    }

    private Object _getObject(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = (AOPInstance)this.peek(fqn, AOPInstance.KEY);
        if (aopInstance != null && aopInstance.get() != null) {
            return aopInstance.get();
        }
        Class clazz = (Class)this.peek(fqn, CLASS_INTERNAL);
        if (clazz == null || aopInstance == null) {
            return null;
        }
        CachedType type = this.getCachedType(clazz);
        Object obj = null;
        if ((class$org$jboss$aop$Advised == null ? (class$org$jboss$aop$Advised = TreeCacheAop.class$("org.jboss.aop.Advised")) : class$org$jboss$aop$Advised).isAssignableFrom(clazz)) {
            String refFqn = aopInstance.getRefFqn();
            if (refFqn == null) {
                try {
                    obj = clazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("failed creating instance of " + clazz.getName(), e);
                }
                InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
                advisor.appendInterceptor((Interceptor)new CacheInterceptor(this, fqn, type));
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("getObject(): obtain value from reference fqn: " + refFqn));
                }
                obj = this.getObject(refFqn);
            }
        } else {
            try {
                obj = (class$java$util$Map == null ? (class$java$util$Map = TreeCacheAop.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz) ? CollectionInterceptorUtil.createProxy(clazz, new CachedMapInterceptor(this, fqn, clazz)) : ((class$java$util$List == null ? (class$java$util$List = TreeCacheAop.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz) ? CollectionInterceptorUtil.createProxy(clazz, new CachedListInterceptor(this, fqn, clazz)) : ((class$java$util$Set == null ? (class$java$util$Set = TreeCacheAop.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(clazz) ? CollectionInterceptorUtil.createProxy(clazz, new CachedSetInterceptor(this, fqn, clazz)) : this.peek(fqn, "value")));
            }
            catch (Exception e) {
                throw new CacheException("failure creating proxy", e);
            }
        }
        if (aopInstance == null) {
            throw new RuntimeException("getObject(): aopInstance is null");
        }
        aopInstance.set(obj);
        return obj;
    }

    public Object removeObject(String fqn) throws CacheException {
        return this.removeObject(Fqn.fromString(fqn));
    }

    public Object removeObject(Fqn fqn) throws CacheException {
        if (this.hasCurrentTransaction()) {
            return this._removeObject(fqn, true);
        }
        try {
            this.localTm_.begin();
            this.put(fqn, (Object)DUMMY, (Object)DUMMY);
            Object obj = this._removeObject(fqn, true);
            this.remove(fqn, (Object)DUMMY);
            Object object = obj;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.localTm_.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            throw new NestedRuntimeException("TreeCacheAop.removeObject(): ", (Throwable)e);
        }
        finally {
            this.endTransaction();
        }
    }

    protected Object _removeObject(Fqn fqn, boolean removeCacheInterceptor) throws CacheException {
        Class clazz;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removeObject(): removing object from fqn: " + fqn));
        }
        if ((clazz = (Class)this.peek(fqn, CLASS_INTERNAL)) == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removeObject(): clasz is null. fqn: " + fqn));
            }
            return null;
        }
        Object result = this.getObject(fqn);
        AOPInstance aopInstance = (AOPInstance)this.peek(fqn, AOPInstance.KEY);
        if ((class$org$jboss$aop$Advised == null ? (class$org$jboss$aop$Advised = TreeCacheAop.class$("org.jboss.aop.Advised")) : class$org$jboss$aop$Advised).isAssignableFrom(clazz)) {
            String refFqn = aopInstance.getRefFqn();
            InstanceAdvisor advisor = ((Advised)result)._getInstanceAdvisor();
            if (refFqn != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("removeObject(): removing object fqn: " + fqn + " but is actually from ref fqn: " + refFqn));
                }
                this.removeRefFqn(aopInstance, refFqn, removeCacheInterceptor);
            } else {
                CacheInterceptor interceptor;
                CachedType type = this.getCachedType(clazz);
                Iterator i = type.getFields().iterator();
                while (i.hasNext()) {
                    Object obj;
                    Field field = (Field)i.next();
                    CachedType fieldType = this.getCachedType(field.getType());
                    if (!fieldType.isImmediate() && (obj = this._removeObject(new Fqn(fqn, field.getName()), removeCacheInterceptor)) != null) continue;
                }
                if (removeCacheInterceptor && (interceptor = (CacheInterceptor)this.findCacheInterceptor(advisor)) != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("removeObject(): removed cache interceptor fqn: " + fqn + " interceptor: " + interceptor));
                    }
                    advisor.removeInterceptor(interceptor.getName());
                }
            }
        } else if ((class$java$util$Map == null ? (class$java$util$Map = TreeCacheAop.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            Map values = this.get(fqn).getChildren();
            if (values != null) {
                ArrayList list = new ArrayList(values.keySet());
                for (int i = 0; i < list.size(); ++i) {
                    Object key = list.get(i);
                    this._removeObject(new Fqn(fqn, key), removeCacheInterceptor);
                }
            }
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = TreeCacheAop.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            Map values = this.get(fqn).getChildren();
            int size = values == null ? 0 : values.size();
            for (int i = 0; i < size; ++i) {
                this._removeObject(new Fqn(fqn, new Integer(i)), removeCacheInterceptor);
            }
        }
        this.remove(fqn);
        return result;
    }

    public synchronized CachedType getCachedType(Class clazz) {
        CachedType type = (CachedType)this.cachedTypes.get(clazz);
        if (type == null) {
            type = new CachedType(clazz);
            this.cachedTypes.put(clazz, type);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRefFqn(AOPInstance instance, String refFqn) throws CacheException {
        AOPInstance refInstance = (AOPInstance)this.peek(Fqn.fromString(refFqn), AOPInstance.KEY);
        TreeCacheAop treeCacheAop = this;
        synchronized (treeCacheAop) {
            refInstance.incrementRefCount();
            this.put(refFqn, AOPInstance.KEY, (Object)refInstance);
        }
        instance.setRefFqn(refFqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRefFqn(AOPInstance instance, String refFqn, boolean removeCacheInterceptor) throws CacheException {
        AOPInstance refInstance = (AOPInstance)this.peek(Fqn.fromString(refFqn), AOPInstance.KEY);
        TreeCacheAop treeCacheAop = this;
        synchronized (treeCacheAop) {
            if (refInstance.decrementRefCount() == 0) {
                this._removeObject(Fqn.fromString(refFqn), removeCacheInterceptor);
            } else {
                this.put(refFqn, AOPInstance.KEY, (Object)refInstance);
            }
        }
        instance.removeRefFqn();
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops) throws CacheException {
        Object result = super._put(tx, fqn, key, value, create_undo_ops);
        if (key == AOPInstance.KEY) {
            return result;
        }
        AOPInstance aopInstance = (AOPInstance)this._get(fqn, AOPInstance.KEY, false);
        Object instance = null;
        if (aopInstance == null || (instance = aopInstance.get()) == null) {
            return result;
        }
        CachedType type = this.getCachedType((Class)this._get(fqn, CLASS_INTERNAL, false));
        if (type.isImmediate()) {
            return result;
        }
        Field f = type.getField((String)key);
        if (f == null) {
            return result;
        }
        try {
            f.set(instance, value);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        return result;
    }

    public void evict(Fqn fqn) throws CacheException {
        if (this.isAopNode(fqn)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("evict(): evicting whole aop node " + fqn));
            }
            boolean removeCacheInterceptor = false;
            this._removeObject(fqn, removeCacheInterceptor);
        } else {
            super.evict(fqn);
        }
    }

    private boolean isAopNode(Fqn fqn) {
        try {
            return this.peek(fqn, AOPInstance.KEY) != null;
        }
        catch (Exception e) {
            this.log.warn((Object)("isAopNode(): cache get operation generated exception " + e));
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

