/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jgroups.blocks.MethodCall;

public class CreateIfNotExistsInterceptor
extends Interceptor {
    private final ReentrantLock put_lock = new ReentrantLock();
    private final ReentrantLock remove_lock = new ReentrantLock();
    static final List putMethods = new ArrayList(3);
    private final ArrayList put_list = new ArrayList();
    private final ArrayList remove_list = new ArrayList();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Method meth = m.getMethod();
        boolean isPut = putMethods.contains(meth);
        boolean isRemove = TreeCache.removeNodeMethodLocal.equals(meth);
        boolean isEvict = TreeCache.evictNodeMethodLocal.equals(meth);
        if (isPut || isRemove || isEvict) {
            Object object;
            Object[] args = m.getArgs();
            Fqn fqn = (Fqn)(args != null ? (isEvict ? args[0] : args[1]) : null);
            if (fqn == null) {
                throw new CacheException("failed extracting FQN from method " + m);
            }
            if (isPut) {
                try {
                    this.addFqnToPutList(fqn, this.put_lock);
                    this.findAndBlockOnRemove(fqn, this.remove_lock);
                    if (!this.cache.exists(fqn)) {
                        GlobalTransaction gtx = this.cache.getCurrentTransaction();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("creating node " + fqn));
                        }
                        this.createNode(fqn, gtx);
                    }
                    Object object2 = super.invoke(m);
                    return object2;
                }
                finally {
                    this.removeFqnFromPutList(fqn, this.put_lock);
                }
            }
            try {
                this.findAndBlockOnPut(fqn, this.put_lock);
                this.addFqnToRemoveList(fqn, this.remove_lock);
                this.put_lock.release();
                object = super.invoke(m);
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (this.put_lock.holds() > 0L) {
                    this.put_lock.release();
                }
                this.removeFqnFromRemoveList(fqn, this.remove_lock);
                throw throwable;
            }
            if (this.put_lock.holds() > 0L) {
                this.put_lock.release();
            }
            this.removeFqnFromRemoveList(fqn, this.remove_lock);
            return object;
        }
        return super.invoke(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAndBlockOnPut(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        while (true) {
            lock.acquire();
            Fqn tmp = this.findFqnInPutList(fqn);
            if (tmp == null) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("found " + tmp + " in put-list, waiting"));
            }
            Fqn fqn2 = tmp;
            synchronized (fqn2) {
                lock.release();
                tmp.wait();
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("wait() for put-list on " + tmp + " got notified"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAndBlockOnRemove(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        while (true) {
            try {
                lock.acquire();
                Fqn tmp = this.findFqnInRemoveList(fqn);
                if (tmp == null) {
                    return;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("found " + tmp + " in remove-list, waiting"));
                }
                Fqn fqn2 = tmp;
                synchronized (fqn2) {
                    lock.release();
                    tmp.wait();
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("wait() for remove-list on " + tmp + " got notified"));
                continue;
            }
            finally {
                if (lock.holds() <= 0L) continue;
                lock.release();
                continue;
            }
            break;
        }
    }

    private Fqn findFqnInPutList(Fqn fqn) {
        Iterator it = this.put_list.iterator();
        while (it.hasNext()) {
            Fqn tmp = (Fqn)it.next();
            if (!tmp.isChildOf(fqn) && !tmp.equals(fqn)) continue;
            return tmp;
        }
        return null;
    }

    private Fqn findFqnInRemoveList(Fqn fqn) {
        Iterator it = this.remove_list.iterator();
        while (it.hasNext()) {
            Fqn tmp = (Fqn)it.next();
            if (!fqn.isChildOf(tmp) && !fqn.equals(tmp)) continue;
            return tmp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFqnToPutList(Fqn fqn, ReentrantLock lock) {
        try {
            lock.acquire();
            if (!this.put_list.contains(fqn)) {
                this.put_list.add(fqn);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("adding " + fqn + " to put-list (size=" + this.put_list.size() + ")"));
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (lock.holds() > 0L) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFqnToRemoveList(Fqn fqn, ReentrantLock lock) {
        try {
            lock.acquire();
            if (!this.remove_list.contains(fqn)) {
                this.remove_list.add(fqn);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("adding " + fqn + " to remove-list (size=" + this.remove_list.size() + ")"));
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (lock.holds() > 0L) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFqnFromPutList(Fqn fqn, ReentrantLock lock) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removing " + fqn + " from put-list (size=" + this.put_list.size() + ")"));
            }
            lock.acquire();
            this.put_list.remove(fqn);
            lock.release();
            Fqn fqn2 = fqn;
            synchronized (fqn2) {
                fqn.notifyAll();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (lock.holds() > 0L) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFqnFromRemoveList(Fqn fqn, ReentrantLock lock) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removing " + fqn + " from remove-list (size=" + this.remove_list.size() + ")"));
            }
            lock.acquire();
            this.remove_list.remove(fqn);
            lock.release();
            Fqn fqn2 = fqn;
            synchronized (fqn2) {
                fqn.notifyAll();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (lock.holds() > 0L) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNode(Fqn fqn, GlobalTransaction tx) {
        Fqn tmp_fqn = new Fqn();
        if (fqn == null) {
            return;
        }
        CreateIfNotExistsInterceptor createIfNotExistsInterceptor = this;
        synchronized (createIfNotExistsInterceptor) {
            int treeNodeSize = fqn.size();
            Node n = this.cache.getRoot();
            for (int i = 0; i < treeNodeSize; ++i) {
                Object child_name = fqn.get(i);
                tmp_fqn = new Fqn(tmp_fqn, child_name);
                Node child_node = n.getChild(child_name);
                if (child_node == null) {
                    Fqn copy = (Fqn)tmp_fqn.clone();
                    child_node = n.createChild(child_name, copy, n);
                    if (tx != null) {
                        this.cache.addNode(tx, (Fqn)tmp_fqn.clone());
                    }
                    this.cache.notifyNodeCreated(copy);
                }
                n = child_node;
            }
        }
    }

    static {
        putMethods.add(TreeCache.putDataEraseMethodLocal);
        putMethods.add(TreeCache.putDataMethodLocal);
        putMethods.add(TreeCache.putKeyValMethodLocal);
        putMethods.add(TreeCache.putFailFastKeyValueMethodLocal);
    }
}

