/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.logging.Logger;

public abstract class DelegatingCacheLoader
implements CacheLoader {
    Logger log = Logger.getLogger(this.getClass());
    HashMap transactions = new HashMap();

    public abstract void setConfig(Properties var1);

    public abstract void setCache(TreeCache var1);

    public Set getChildrenNames(Fqn fqn) throws Exception {
        Set retval = this.delegateGetChildrenNames(fqn);
        return retval == null ? null : (retval.size() == 0 ? null : retval);
    }

    public Object get(Fqn name, Object key) throws Exception {
        return this.delegateGet(name, key);
    }

    public Map get(Fqn name) throws Exception {
        Map attributes = null;
        Node n = this.delegateGet(name);
        if (n == null || (attributes = n.getData()) == null || attributes.size() == 0) {
            return null;
        }
        return new HashMap(attributes);
    }

    public boolean exists(Fqn name) throws Exception {
        return this.delegateExists(name);
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        return this.delegatePut(name, key, value);
    }

    public void put(Fqn name, Map attributes) throws Exception {
        this.delegatePut(name, attributes);
    }

    public void put(Fqn fqn, Map attributes, boolean erase) throws Exception {
        if (erase) {
            this.removeData(fqn);
        }
        this.put(fqn, attributes);
    }

    public void put(List modifications) throws Exception {
        if (modifications == null) {
            return;
        }
        Iterator it = modifications.iterator();
        block8: while (it.hasNext()) {
            Modification m = (Modification)it.next();
            switch (m.getType()) {
                case 2: {
                    this.put(m.getFqn(), m.getData());
                    continue block8;
                }
                case 3: {
                    this.put(m.getFqn(), m.getData(), true);
                    continue block8;
                }
                case 1: {
                    this.put(m.getFqn(), m.getKey(), m.getValue());
                    continue block8;
                }
                case 6: {
                    this.removeData(m.getFqn());
                    continue block8;
                }
                case 5: {
                    this.remove(m.getFqn(), m.getKey());
                    continue block8;
                }
                case 4: {
                    this.remove(m.getFqn());
                    continue block8;
                }
            }
            this.log.error((Object)("modification type " + m.getType() + " not known"));
        }
    }

    public Object remove(Fqn name, Object key) throws Exception {
        return this.delegateRemove(name, key);
    }

    public void remove(Fqn name) throws Exception {
        this.delegateRemove(name);
    }

    public void removeData(Fqn name) throws Exception {
        this.delegateRemoveData(name);
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        if (one_phase) {
            this.put(modifications);
        } else {
            this.transactions.put(tx, modifications);
        }
    }

    public void commit(Object tx) throws Exception {
        List modifications = (List)this.transactions.get(tx);
        if (modifications == null) {
            throw new Exception("transaction " + tx + " not found in transaction table");
        }
        this.put(modifications);
    }

    public void rollback(Object tx) {
        this.transactions.remove(tx);
    }

    public byte[] loadEntireState() throws Exception {
        return this.delegateLoadEntireState();
    }

    public void storeEntireState(byte[] state) throws Exception {
        this.delegateStoreEntireState(state);
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    protected abstract Set delegateGetChildrenNames(Fqn var1) throws Exception;

    protected abstract Object delegateGet(Fqn var1, Object var2) throws Exception;

    protected abstract Node delegateGet(Fqn var1) throws Exception;

    protected abstract boolean delegateExists(Fqn var1) throws Exception;

    protected abstract Object delegatePut(Fqn var1, Object var2, Object var3) throws Exception;

    protected abstract void delegatePut(Fqn var1, Map var2) throws Exception;

    protected abstract Object delegateRemove(Fqn var1, Object var2) throws Exception;

    protected abstract void delegateRemove(Fqn var1) throws Exception;

    protected abstract void delegateRemoveData(Fqn var1) throws Exception;

    protected abstract byte[] delegateLoadEntireState() throws Exception;

    protected abstract void delegateStoreEntireState(byte[] var1) throws Exception;
}

