/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.LocalDelegatingCacheLoader;

public class InterceptorConfigurationTest
extends TestCase {
    TreeCache cache = null;
    static /* synthetic */ Class class$org$jboss$cache$interceptors$UnlockInterceptor;
    static /* synthetic */ Class class$org$jboss$cache$interceptors$LockInterceptor;
    static /* synthetic */ Class class$org$jboss$cache$interceptors$CallInterceptor;
    static /* synthetic */ Class class$org$jboss$cache$interceptors$CacheStoreInterceptor;
    static /* synthetic */ Class class$org$jboss$cache$interceptors$ReplicationInterceptor;
    static /* synthetic */ Class class$org$jboss$cache$interceptors$CacheLoaderInterceptor;
    static /* synthetic */ Class class$org$jboss$cache$tests$InterceptorConfigurationTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = new TreeCache();
        this.cache.setCacheMode(1);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.cache != null) {
            this.cache.stopService();
            this.cache.destroyService();
        }
    }

    public void testBareConfig() throws Exception {
        this.cache.createService();
        this.cache.startService();
        System.out.println("interceptors are:\n" + this.cache.getInterceptorChain());
        List list = this.cache.getInterceptors();
        InterceptorConfigurationTest.assertNotNull((Object)list);
        InterceptorConfigurationTest.assertEquals((int)3, (int)list.size());
        InterceptorConfigurationTest.assertEquals(list.get(0).getClass(), (Object)(class$org$jboss$cache$interceptors$UnlockInterceptor == null ? (class$org$jboss$cache$interceptors$UnlockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.UnlockInterceptor")) : class$org$jboss$cache$interceptors$UnlockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(1).getClass(), (Object)(class$org$jboss$cache$interceptors$LockInterceptor == null ? (class$org$jboss$cache$interceptors$LockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.LockInterceptor")) : class$org$jboss$cache$interceptors$LockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(2).getClass(), (Object)(class$org$jboss$cache$interceptors$CallInterceptor == null ? (class$org$jboss$cache$interceptors$CallInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CallInterceptor")) : class$org$jboss$cache$interceptors$CallInterceptor));
    }

    public void testTxConfig() throws Exception {
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.createService();
        this.cache.startService();
        System.out.println("interceptors are:\n" + this.cache.getInterceptorChain());
        List list = this.cache.getInterceptors();
        InterceptorConfigurationTest.assertNotNull((Object)list);
        InterceptorConfigurationTest.assertEquals((int)3, (int)list.size());
        InterceptorConfigurationTest.assertEquals(list.get(0).getClass(), (Object)(class$org$jboss$cache$interceptors$UnlockInterceptor == null ? (class$org$jboss$cache$interceptors$UnlockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.UnlockInterceptor")) : class$org$jboss$cache$interceptors$UnlockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(1).getClass(), (Object)(class$org$jboss$cache$interceptors$LockInterceptor == null ? (class$org$jboss$cache$interceptors$LockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.LockInterceptor")) : class$org$jboss$cache$interceptors$LockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(2).getClass(), (Object)(class$org$jboss$cache$interceptors$CallInterceptor == null ? (class$org$jboss$cache$interceptors$CallInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CallInterceptor")) : class$org$jboss$cache$interceptors$CallInterceptor));
    }

    public void testSharedCacheLoaderConfig() throws Exception {
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.setCacheLoader(new LocalDelegatingCacheLoader(null));
        this.cache.setCacheLoaderShared(true);
        this.cache.setCacheMode(2);
        this.cache.setFetchStateOnStartup(false);
        this.cache.createService();
        this.cache.startService();
        System.out.println("interceptors are:\n" + this.cache.getInterceptorChain());
        List list = this.cache.getInterceptors();
        InterceptorConfigurationTest.assertNotNull((Object)list);
        InterceptorConfigurationTest.assertEquals((int)6, (int)list.size());
        InterceptorConfigurationTest.assertEquals(list.get(0).getClass(), (Object)(class$org$jboss$cache$interceptors$CacheStoreInterceptor == null ? (class$org$jboss$cache$interceptors$CacheStoreInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CacheStoreInterceptor")) : class$org$jboss$cache$interceptors$CacheStoreInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(1).getClass(), (Object)(class$org$jboss$cache$interceptors$ReplicationInterceptor == null ? (class$org$jboss$cache$interceptors$ReplicationInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.ReplicationInterceptor")) : class$org$jboss$cache$interceptors$ReplicationInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(2).getClass(), (Object)(class$org$jboss$cache$interceptors$UnlockInterceptor == null ? (class$org$jboss$cache$interceptors$UnlockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.UnlockInterceptor")) : class$org$jboss$cache$interceptors$UnlockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(3).getClass(), (Object)(class$org$jboss$cache$interceptors$CacheLoaderInterceptor == null ? (class$org$jboss$cache$interceptors$CacheLoaderInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CacheLoaderInterceptor")) : class$org$jboss$cache$interceptors$CacheLoaderInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(4).getClass(), (Object)(class$org$jboss$cache$interceptors$LockInterceptor == null ? (class$org$jboss$cache$interceptors$LockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.LockInterceptor")) : class$org$jboss$cache$interceptors$LockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(5).getClass(), (Object)(class$org$jboss$cache$interceptors$CallInterceptor == null ? (class$org$jboss$cache$interceptors$CallInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CallInterceptor")) : class$org$jboss$cache$interceptors$CallInterceptor));
    }

    public void testUnsharedCacheLoaderConfig() throws Exception {
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.setCacheLoader(new LocalDelegatingCacheLoader(null));
        this.cache.setCacheLoaderShared(false);
        this.cache.setCacheMode(2);
        this.cache.setFetchStateOnStartup(false);
        this.cache.createService();
        this.cache.startService();
        System.out.println("interceptors are:\n" + this.cache.getInterceptorChain());
        List list = this.cache.getInterceptors();
        InterceptorConfigurationTest.assertNotNull((Object)list);
        InterceptorConfigurationTest.assertEquals((int)6, (int)list.size());
        InterceptorConfigurationTest.assertEquals(list.get(0).getClass(), (Object)(class$org$jboss$cache$interceptors$ReplicationInterceptor == null ? (class$org$jboss$cache$interceptors$ReplicationInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.ReplicationInterceptor")) : class$org$jboss$cache$interceptors$ReplicationInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(1).getClass(), (Object)(class$org$jboss$cache$interceptors$UnlockInterceptor == null ? (class$org$jboss$cache$interceptors$UnlockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.UnlockInterceptor")) : class$org$jboss$cache$interceptors$UnlockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(2).getClass(), (Object)(class$org$jboss$cache$interceptors$CacheLoaderInterceptor == null ? (class$org$jboss$cache$interceptors$CacheLoaderInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CacheLoaderInterceptor")) : class$org$jboss$cache$interceptors$CacheLoaderInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(3).getClass(), (Object)(class$org$jboss$cache$interceptors$CacheStoreInterceptor == null ? (class$org$jboss$cache$interceptors$CacheStoreInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CacheStoreInterceptor")) : class$org$jboss$cache$interceptors$CacheStoreInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(4).getClass(), (Object)(class$org$jboss$cache$interceptors$LockInterceptor == null ? (class$org$jboss$cache$interceptors$LockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.LockInterceptor")) : class$org$jboss$cache$interceptors$LockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(5).getClass(), (Object)(class$org$jboss$cache$interceptors$CallInterceptor == null ? (class$org$jboss$cache$interceptors$CallInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CallInterceptor")) : class$org$jboss$cache$interceptors$CallInterceptor));
    }

    public void testTxAndRepl() throws Exception {
        this.cache.setCacheMode("repl_sync");
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.createService();
        this.cache.startService();
        System.out.println("interceptors are:\n" + this.cache.getInterceptorChain());
        List list = this.cache.getInterceptors();
        InterceptorConfigurationTest.assertNotNull((Object)list);
        InterceptorConfigurationTest.assertEquals((int)4, (int)list.size());
        InterceptorConfigurationTest.assertEquals(list.get(0).getClass(), (Object)(class$org$jboss$cache$interceptors$ReplicationInterceptor == null ? (class$org$jboss$cache$interceptors$ReplicationInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.ReplicationInterceptor")) : class$org$jboss$cache$interceptors$ReplicationInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(1).getClass(), (Object)(class$org$jboss$cache$interceptors$UnlockInterceptor == null ? (class$org$jboss$cache$interceptors$UnlockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.UnlockInterceptor")) : class$org$jboss$cache$interceptors$UnlockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(2).getClass(), (Object)(class$org$jboss$cache$interceptors$LockInterceptor == null ? (class$org$jboss$cache$interceptors$LockInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.LockInterceptor")) : class$org$jboss$cache$interceptors$LockInterceptor));
        InterceptorConfigurationTest.assertEquals(list.get(3).getClass(), (Object)(class$org$jboss$cache$interceptors$CallInterceptor == null ? (class$org$jboss$cache$interceptors$CallInterceptor = InterceptorConfigurationTest.class$("org.jboss.cache.interceptors.CallInterceptor")) : class$org$jboss$cache$interceptors$CallInterceptor));
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$InterceptorConfigurationTest == null ? (class$org$jboss$cache$tests$InterceptorConfigurationTest = InterceptorConfigurationTest.class$("org.jboss.cache.tests.InterceptorConfigurationTest")) : class$org$jboss$cache$tests$InterceptorConfigurationTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)InterceptorConfigurationTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

