/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala_maven.ScalaCompilerSupport;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ScalaTestCompileMojo
extends ScalaCompilerSupport {
    @Parameter(property="maven.test.skip")
    protected boolean skip;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testOutputDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala")
    protected File testSourceDir;
    @Parameter(property="testAnalysisCacheFile", defaultValue="${project.build.directory}/analysis/test-compile")
    protected File testAnalysisCacheFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        super.execute();
    }

    @Override
    protected List<String> getClasspathElements() throws Exception {
        List back = this.project.getTestClasspathElements();
        back.remove(this.project.getBuild().getTestOutputDirectory());
        return back;
    }

    @Override
    protected List<Dependency> getDependencies() {
        return this.project.getTestDependencies();
    }

    @Override
    protected File getOutputDir() throws Exception {
        return this.testOutputDir.getAbsoluteFile();
    }

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        List sources = this.project.getTestCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = this.testSourceDir.getAbsolutePath())) {
            sources.add(scalaSourceDir);
        }
        return this.normalize(sources);
    }

    @Override
    protected File getAnalysisCacheFile() throws Exception {
        return this.testAnalysisCacheFile.getAbsoluteFile();
    }
}

