/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.util.Arrays;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.lang.Nullable;

public class DesensitizationUtil {
    @Nullable
    public static String chineseName(@Nullable String fullName) {
        if (StringUtil.isBlank(fullName)) {
            return "";
        }
        return DesensitizationUtil.sensitive(fullName, 1, 0, '*');
    }

    @Nullable
    public static String idCardNum(@Nullable String id) {
        if (StringUtil.isBlank(id)) {
            return "";
        }
        return DesensitizationUtil.sensitive(id, 0, 4, '*');
    }

    @Nullable
    public static String phoneNo(@Nullable String num) {
        if (StringUtil.isBlank(num)) {
            return "";
        }
        return DesensitizationUtil.sensitive(num, 0, 4, '*');
    }

    @Nullable
    public static String mobileNo(@Nullable String num) {
        if (StringUtil.isBlank(num)) {
            return "";
        }
        return DesensitizationUtil.sensitive(num, 3, 4, '*');
    }

    @Nullable
    public static String address(@Nullable String address, int sensitiveSize) {
        if (StringUtil.isBlank(address)) {
            return "";
        }
        return DesensitizationUtil.sensitive(address, 0, sensitiveSize, '*');
    }

    @Nullable
    public static String email(@Nullable String email) {
        if (StringUtil.isBlank(email)) {
            return "";
        }
        int index = email.indexOf(64);
        if (index <= 1) {
            return email;
        }
        return DesensitizationUtil.sensitive(email, 1, email.length() - index, '*');
    }

    @Nullable
    public static String bankCard(@Nullable String cardNum) {
        if (StringUtil.isBlank(cardNum)) {
            return "";
        }
        return DesensitizationUtil.sensitive(cardNum, 6, 4, '*');
    }

    @Nullable
    public static String cnapsCode(@Nullable String code) {
        if (StringUtil.isBlank(code)) {
            return "";
        }
        return DesensitizationUtil.sensitive(code, 2, 0, '*');
    }

    @Nullable
    public static String right(@Nullable String sensitiveStr) {
        if (StringUtil.isBlank(sensitiveStr)) {
            return "";
        }
        int length = sensitiveStr.length();
        return DesensitizationUtil.sensitive(sensitiveStr, length / 2, 0, '*');
    }

    @Nullable
    public static String left(@Nullable String sensitiveStr) {
        if (StringUtil.isBlank(sensitiveStr)) {
            return "";
        }
        int length = sensitiveStr.length();
        return DesensitizationUtil.sensitive(sensitiveStr, 0, length / 2, '*');
    }

    @Nullable
    public static String middle(@Nullable String sensitiveStr) {
        if (StringUtil.isBlank(sensitiveStr)) {
            return "";
        }
        int length = sensitiveStr.length();
        if (length < 3) {
            return StringUtil.leftPad("", length, '*');
        }
        char[] chars = new char[length];
        int last = length - 1;
        Arrays.fill(chars, 1, last, '*');
        chars[0] = sensitiveStr.charAt(0);
        chars[last] = sensitiveStr.charAt(last);
        return new String(chars);
    }

    @Nullable
    public static String all(@Nullable String sensitiveStr) {
        if (StringUtil.isBlank(sensitiveStr)) {
            return "";
        }
        return DesensitizationUtil.sensitive(sensitiveStr, 0, 0, '*');
    }

    private static String sensitive(String str, int fromIndex, int lastSize, char padChar) {
        int length = str.length();
        if (fromIndex == 0 && lastSize == 0) {
            return StringUtil.repeat('*', length);
        }
        int toIndex = length - lastSize;
        if (fromIndex == 0) {
            String tail = str.substring(toIndex);
            return StringUtil.repeat(padChar, toIndex - fromIndex).concat(tail);
        }
        if (toIndex == length) {
            String head = str.substring(0, fromIndex);
            return head.concat(StringUtil.repeat(padChar, toIndex - fromIndex));
        }
        String head = str.substring(0, fromIndex);
        String tail = str.substring(toIndex);
        return head + StringUtil.repeat(padChar, toIndex - fromIndex) + tail;
    }
}

