/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import net.dreamlu.mica.core.http.HttpRequestInfo;
import net.dreamlu.mica.core.utils.Exceptions;

public final class HttpRequestParser {
    /*
     * Enabled aggressive exception aggregation
     */
    public static HttpRequestInfo parser(String httpText) {
        try (StringReader stringReader = new StringReader(httpText);){
            HttpRequestInfo httpRequestInfo;
            try (BufferedReader reader = new BufferedReader(stringReader);){
                httpRequestInfo = HttpRequestParser.httpParser(reader);
            }
            return httpRequestInfo;
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    private static HttpRequestInfo httpParser(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        int countTokens = tokenizer.countTokens();
        if (countTokens < 2) {
            return null;
        }
        HttpRequestInfo httpRequestInfo = new HttpRequestInfo();
        String method = tokenizer.nextToken();
        String url = tokenizer.nextToken();
        httpRequestInfo.setMethod(method.trim());
        httpRequestInfo.setUrl(url.trim());
        while ((line = reader.readLine()) == null || !line.isEmpty()) {
            if (line == null) {
                return httpRequestInfo;
            }
            tokenizer = new StringTokenizer(line, ":");
            if (tokenizer.countTokens() <= 1) continue;
            String name = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            httpRequestInfo.addHeader(name.trim(), value.trim());
        }
        StringBuilder bodyBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            bodyBuilder.append(line);
        }
        String body = bodyBuilder.toString();
        if (!body.isEmpty()) {
            httpRequestInfo.setBody(body.trim());
        }
        return httpRequestInfo;
    }

    private HttpRequestParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

