/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTAbstractManager;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStoreManager;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStructuredGridCoverageReaderManager;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStyleManager;
import java.net.URL;

public class GeoServerRESTManager
extends GeoServerRESTAbstractManager {
    private final GeoServerRESTPublisher publisher;
    private final GeoServerRESTReader reader;
    private final GeoServerRESTStoreManager storeManager;
    private final GeoServerRESTStyleManager styleManager;
    private final GeoServerRESTStructuredGridCoverageReaderManager structuredGridCoverageReader;

    public GeoServerRESTManager(URL restURL, String username, String password) throws IllegalArgumentException {
        super(restURL, username, password);
        this.publisher = new GeoServerRESTPublisher(restURL.toString(), username, password);
        this.reader = new GeoServerRESTReader(restURL, username, password);
        this.structuredGridCoverageReader = new GeoServerRESTStructuredGridCoverageReaderManager(restURL, username, password);
        this.storeManager = new GeoServerRESTStoreManager(restURL, this.gsuser, this.gspass);
        this.styleManager = new GeoServerRESTStyleManager(restURL, this.gsuser, this.gspass);
    }

    public GeoServerRESTPublisher getPublisher() {
        return this.publisher;
    }

    public GeoServerRESTReader getReader() {
        return this.reader;
    }

    public GeoServerRESTStoreManager getStoreManager() {
        return this.storeManager;
    }

    public GeoServerRESTStyleManager getStyleManager() {
        return this.styleManager;
    }

    public GeoServerRESTStructuredGridCoverageReaderManager getStructuredGridCoverageReader() {
        return this.structuredGridCoverageReader;
    }
}

