/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.RESTBoundingBox;
import it.geosolutions.geoserver.rest.decoder.RESTCoverage;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.encoder.dimensions.GSCoverageDimensionEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.FeatureTypeAttribute;
import it.geosolutions.geoserver.rest.encoder.feature.GSAttributeEncoder;
import it.geosolutions.geoserver.rest.encoder.metadatalink.GSMetadataLinkInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.metadatalink.ResourceMetadataLinkInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;

public class RESTResource {
    protected final Element rootElem;

    public static RESTResource build(String response) {
        Element elem = JDOMBuilder.buildElement(response);
        return elem == null ? null : new RESTCoverage(elem);
    }

    public RESTResource(Element resource) {
        this.rootElem = resource;
    }

    public String getName() {
        return this.rootElem.getChildText("name");
    }

    public String getTitle() {
        return this.rootElem.getChildText("title");
    }

    public String getNativeName() {
        return this.rootElem.getChildText("nativeName");
    }

    public String getAbstract() {
        return this.rootElem.getChildText("abstract");
    }

    public List<String> getKeywords() {
        List keywords;
        ArrayList<String> kwdsList = null;
        Element keywordsRoot = this.rootElem.getChild("keywords");
        if (keywordsRoot != null && (keywords = keywordsRoot.getChildren()) != null) {
            kwdsList = new ArrayList<String>(keywords.size());
            for (Element keyword : keywords) {
                kwdsList.add(keyword.getValue());
            }
        }
        return kwdsList;
    }

    public String getNameSpace() {
        return this.rootElem.getChild("namespace").getChildText("name");
    }

    public String getStoreName() {
        return this.rootElem.getChild("store").getChildText("name");
    }

    public String getStoreType() {
        return this.rootElem.getChild("store").getAttributeValue("class");
    }

    public String getStoreUrl() {
        Element store = this.rootElem.getChild("store");
        Element atom = store.getChild("link", Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom"));
        return atom.getAttributeValue("href");
    }

    public String getNativeCRS() {
        return this.rootElem.getChildText("nativeCRS");
    }

    public RESTBoundingBox getNativeBoundingBox() {
        RESTBoundingBox bbox = null;
        Element bboxElement = this.rootElem.getChild("nativeBoundingBox");
        if (bboxElement != null) {
            bbox = new RESTBoundingBox(bboxElement);
        }
        return bbox;
    }

    public RESTBoundingBox getLatLonBoundingBox() {
        RESTBoundingBox bbox = null;
        Element bboxElement = this.rootElem.getChild("latLonBoundingBox");
        if (bboxElement != null) {
            bbox = new RESTBoundingBox(bboxElement);
        }
        return bbox;
    }

    public String getCRS() {
        RESTBoundingBox bbox = this.getLatLonBoundingBox();
        return bbox.getCRS();
    }

    public double getMinX() {
        return this.getLatLonBoundingBox().getMinX();
    }

    public double getMaxX() {
        return this.getLatLonBoundingBox().getMaxX();
    }

    public double getMinY() {
        return this.getLatLonBoundingBox().getMinY();
    }

    public double getMaxY() {
        return this.getLatLonBoundingBox().getMaxY();
    }

    public List<Map<FeatureTypeAttribute, String>> getAttributeList() {
        throw new UnsupportedOperationException("This method is specific for RESTFeatureType");
    }

    public List<GSAttributeEncoder> getEncodedAttributeList() {
        throw new UnsupportedOperationException("This method is specific for RESTFeatureType");
    }

    public List<GSMetadataLinkInfoEncoder> getEncodedMetadataLinkInfoList() {
        List metaLinks;
        ArrayList<GSMetadataLinkInfoEncoder> metaLinksList = null;
        Element metaLinksRoot = this.rootElem.getChild("metadataLinks");
        if (metaLinksRoot != null && (metaLinks = metaLinksRoot.getChildren()) != null) {
            metaLinksList = new ArrayList<GSMetadataLinkInfoEncoder>(metaLinks.size());
            for (Element metaLink : metaLinks) {
                GSMetadataLinkInfoEncoder metaLinkEnc = new GSMetadataLinkInfoEncoder();
                metaLinkEnc.setType(metaLink.getChildText(ResourceMetadataLinkInfo.type.name()));
                metaLinkEnc.setMetadataType(metaLink.getChildText(ResourceMetadataLinkInfo.metadataType.name()));
                metaLinkEnc.setContent(metaLink.getChildText(ResourceMetadataLinkInfo.content.name()));
                metaLinksList.add(metaLinkEnc);
            }
        }
        return metaLinksList;
    }

    public List<GSCoverageDimensionEncoder> getEncodedDimensionsInfoList() {
        List dimensions;
        ArrayList<GSCoverageDimensionEncoder> dimensionList = null;
        Element dimensionsRoot = this.rootElem.getChild("dimensions");
        if (dimensionsRoot != null && (dimensions = dimensionsRoot.getChildren()) != null) {
            dimensionList = new ArrayList<GSCoverageDimensionEncoder>(dimensions.size());
            for (Element coverageDimension : dimensions) {
                String name = coverageDimension.getChildText("name");
                String description = coverageDimension.getChildText("description");
                String rangeMin = null;
                String rangeMax = null;
                Element rangeElement = coverageDimension.getChild("range");
                if (rangeElement != null) {
                    rangeMin = rangeElement.getChildText("min");
                    rangeMax = rangeElement.getChildText("max");
                }
                String unit = coverageDimension.getChildText("unit");
                String dimensionTypeName = null;
                Element dimensionTypeElement = coverageDimension.getChild("dimensionType");
                if (dimensionTypeElement != null) {
                    dimensionTypeName = dimensionTypeElement.getChildText("name");
                }
                GSCoverageDimensionEncoder coverageDimensionEncoder = new GSCoverageDimensionEncoder(name, description, rangeMin, rangeMax, unit, dimensionTypeName);
                dimensionList.add(coverageDimensionEncoder);
            }
        }
        return dimensionList;
    }
}

