/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class RESTStructuredCoverageGranulesList
implements Iterable<RESTStructuredCoverageGranule> {
    private static final Namespace GML_NAMESPACE = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    private final List<RESTStructuredCoverageGranule> granulesList;
    private final Element bbox;

    public Element getBbox() {
        return this.bbox;
    }

    protected RESTStructuredCoverageGranulesList(Element featureCollection) {
        if (!featureCollection.getName().equals("FeatureCollection")) {
            throw new IllegalStateException("Root element should be wfs:FeatureCollection");
        }
        Element boundedBy = featureCollection.getChild("boundedBy", GML_NAMESPACE);
        if (boundedBy == null) {
            throw new IllegalStateException("Unable to find boundedBy element");
        }
        this.bbox = boundedBy.getChild("Box", GML_NAMESPACE);
        ArrayList<RESTStructuredCoverageGranule> tmpList = new ArrayList<RESTStructuredCoverageGranule>();
        for (Element el : featureCollection.getChildren("featureMember", GML_NAMESPACE)) {
            tmpList.add(new RESTStructuredCoverageGranule(el));
        }
        this.granulesList = Collections.unmodifiableList(tmpList);
    }

    public static RESTStructuredCoverageGranulesList build(String response) {
        if (response == null) {
            return null;
        }
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new RESTStructuredCoverageGranulesList(pb);
        }
        return null;
    }

    public int size() {
        return this.granulesList.size();
    }

    public boolean isEmpty() {
        return this.granulesList.isEmpty();
    }

    public RESTStructuredCoverageGranule get(int index) {
        return this.granulesList.get(index);
    }

    @Override
    public Iterator<RESTStructuredCoverageGranule> iterator() {
        return this.granulesList.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RESTStructuredCoverageGranulesList [");
        if (this.bbox != null) {
            builder.append("bbox=");
            builder.append(this.bbox);
        }
        if (this.granulesList != null) {
            builder.append("granulesList={");
            for (RESTStructuredCoverageGranule granule : this.granulesList) {
                builder.append(granule);
            }
            builder.append("}, ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static class RESTStructuredCoverageGranule {
        protected final Element granule;
        private final String fid;
        private final List<Element> children;

        public RESTStructuredCoverageGranule(Element elem) {
            if (!elem.getName().equals("featureMember")) {
                throw new IllegalStateException("Root element should be gml:featureMember for a granule");
            }
            Element feature = (Element)elem.getChildren().get(0);
            if (feature == null) {
                throw new IllegalStateException("Unable to find feature element for this granule");
            }
            this.granule = feature;
            this.fid = this.granule.getAttribute("fid").getValue();
            this.children = this.granule.getChildren();
        }

        public String getAttributeByName(String name) {
            return this.granule.getChildTextTrim(name, null);
        }

        public String getAttributeByIndex(int index) {
            return this.children.get(index).getValue();
        }

        public Iterator<Element> getAttributesIterator() {
            return this.granule.getChildren().iterator();
        }

        public String getFid() {
            return this.fid;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append('[');
            for (Element c : this.granule.getChildren()) {
                String text = c.getText();
                if (text != null) {
                    text = text.replace("\n", "");
                    text = text.trim();
                }
                sb.append('(').append(c.getName()).append("=").append(text).append(')');
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

