/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import org.jdom.Element;

public class RESTWmsStore {
    private final Element cs;

    public RESTWmsStore(Element cs) {
        this.cs = cs;
    }

    public static RESTWmsStore build(String response) {
        if (response == null) {
            return null;
        }
        if (response.isEmpty()) {
            return new RESTWmsStore(new Element("wmsStore"));
        }
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new RESTWmsStore(pb);
        }
        return null;
    }

    public String getName() {
        return this.cs.getChildText("name");
    }

    public String getType() {
        return this.cs.getChildText("type");
    }

    public Boolean getEnabled() {
        return Boolean.parseBoolean(this.cs.getChildText("enabled"));
    }

    public String getWorkspaceName() {
        return this.cs.getChild("workspace").getChildText("name");
    }

    public Boolean getUseConnectionPooling() {
        Element entry = this.cs.getChild("metadata").getChild("entry");
        return entry.getAttributeValue("key").equals("useConnectionPooling") && Boolean.parseBoolean(entry.getValue());
    }

    public String getCapabilitiesURL() {
        return this.cs.getChildText("capabilitiesURL");
    }

    public String getMaxConnections() {
        return this.cs.getChildText("maxConnections");
    }

    public String getReadTimeout() {
        return this.cs.getChildText("readTimeout");
    }

    public String getConnectTimeout() {
        return this.cs.getChildText("connectTimeout");
    }

    public String getUser() {
        return this.cs.getChildText("user");
    }

    public String getPassword() {
        return this.cs.getChildText("password");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        if (this.cs == null) {
            sb.append("null");
        } else {
            sb.append("name:").append(this.getName()).append(" wsname:").append(this.getWorkspaceName());
        }
        return sb.toString();
    }
}

