/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder.about;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class GSVersionDecoder
extends XmlElement {
    public static final String ABOUT = "about";
    private GSAboutResource geoserver;

    public GSVersionDecoder(String document) {
        Element root = JDOMBuilder.buildElement(document);
        if (root != null) {
            this.setRoot(root);
            this.geoserver = new GSAboutResource(ElementUtils.contains(this.getRoot(), "resource"));
        } else {
            this.create();
        }
    }

    public GSVersionDecoder() {
        this.create();
    }

    private void create() {
        this.setRoot(ABOUT);
        this.geoserver = new GSAboutResource();
        this.addContent((Content)this.geoserver.getRoot());
    }

    public GSAboutResource getGeoServer() {
        return this.geoserver;
    }

    public VERSION getVersion() {
        Element e = ElementUtils.contains(this.geoserver.version, "Version");
        return VERSION.getVersion(e.getTextTrim());
    }

    public int compareTo(VERSION v) {
        return this.getVersion().compareTo(v);
    }

    public static GSVersionDecoder build(String response) {
        return new GSVersionDecoder(response);
    }

    public static enum VERSION {
        v22(22, "2\\.2([^0-9]|$).*"),
        v23(23, "2\\.3([^0-9]|$).*"),
        v24(24, "2\\.4([^0-9]|$).*"),
        v25(25, "2\\.5([^0-9]|$).*"),
        v26(26, "2\\.6([^0-9]|$).*"),
        v27(27, "2\\.7([^0-9]|$).*"),
        v28(28, "2\\.8([^0-9]|$).*"),
        ABOVE(9999, "2\\..+"),
        UNRECOGNIZED(-1, null);

        private final int version;
        private final String pattern;

        private VERSION(int val, String pattern) {
            this.version = val;
            this.pattern = pattern;
        }

        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return Integer.toString(this.version);
        }

        public static VERSION getVersion(String v) {
            if (v == null) {
                return UNRECOGNIZED;
            }
            for (VERSION version : VERSION.values()) {
                if (version.pattern == null || !v.matches(version.pattern)) continue;
                return version;
            }
            return UNRECOGNIZED;
        }

        public static String print() {
            StringBuilder sb = new StringBuilder("[");
            for (VERSION v : VERSION.values()) {
                sb.append(v.toString()).append(' ');
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public class GSAboutResource
    extends XmlElement {
        public static final String RESOURCE = "resource";
        public static final String NAME = "name";
        public static final String VERSION = "Version";
        private Element version;

        public GSAboutResource() {
            this.create();
        }

        private void create() {
            this.setRoot(RESOURCE);
            this.version = new Element(VERSION);
            this.addContent((Content)this.version);
        }

        public void setName(String name) {
            Attribute _name = this.getRoot().getAttribute(NAME);
            if (name != null) {
                _name.setValue(name);
            } else {
                this.getRoot().setAttribute(NAME, name);
            }
        }

        public String getName() {
            Attribute name = this.getRoot().getAttribute(NAME);
            if (name != null) {
                return name.getValue();
            }
            return null;
        }

        public GSAboutResource(Element el) {
            if (el != null) {
                this.setRoot(el);
                this.version = ElementUtils.contains(el, VERSION);
            } else {
                this.create();
                this.setVersion(it.geosolutions.geoserver.rest.decoder.about.GSVersionDecoder$VERSION.UNRECOGNIZED.toString());
            }
        }

        public void setVersion(String v) {
            this.version.setText(v);
        }
    }
}

