/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.datastore;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.decoder.RESTDataStore;
import it.geosolutions.geoserver.rest.encoder.GSAbstractStoreEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.NestedElementEncoder;
import java.util.Map;
import org.jdom.Content;

public abstract class GSAbstractDatastoreEncoder
extends GSAbstractStoreEncoder {
    static final String ROOT = "dataStore";
    NestedElementEncoder connectionParameters = new NestedElementEncoder("connectionParameters");

    GSAbstractDatastoreEncoder(String storeName) {
        super(GeoServerRESTPublisher.StoreType.DATASTORES, ROOT);
        this.ensureValidName(storeName);
        this.setName(storeName);
        this.addContent((Content)this.connectionParameters.getRoot());
    }

    GSAbstractDatastoreEncoder(RESTDataStore store) {
        this(store.getName());
        this.ensureValidType(store.getStoreType());
        this.setDescription(store.getDescription());
        this.setEnabled(store.isEnabled());
        Map<String, String> params = store.getConnectionParameters();
        for (String key : params.keySet()) {
            this.connectionParameters.set(key, params.get(key));
        }
    }

    @Override
    protected abstract String getValidType();
}

