/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.service;

import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class GSServiceSettingsEncoder
extends PropertyXMLEncoder {
    public static final String WORKSPACESTRING = "workspace";
    public static final String NAMESTRING = "name";
    public static final String KEYWORDS = "keywords";
    public static final String METADATA = "metadata";
    private static final String MAINTAINER = "http://www.geonovum.nl/dossiers/pdok";
    private static final String SCHEMABASEURL = "http://schemas.opengis.net";
    private final Element workspaceElement = new Element("workspace");
    private final Element nameElement = new Element("name");
    private final Element keywordsElement = new Element("keywords");
    private final Element metadata = new Element("metadata");

    public GSServiceSettingsEncoder(String type, String serviceMetadataId) {
        super(type.toLowerCase());
        this.addEnabled();
        this.addContent((Content)this.workspaceElement);
        this.nameElement.setText(type.toUpperCase());
        this.addContent((Content)this.nameElement);
        this.addContent((Content)this.keywordsElement);
        this.addContent((Content)this.metadata);
        if ("WMS".equals(type.toUpperCase())) {
            this.addWmsMetadata(serviceMetadataId);
            this.addWmsDefaultFields();
        } else if ("WFS".equals(type.toUpperCase())) {
            this.addWfsMetadata(serviceMetadataId);
            this.addWfsDefaultFields();
        }
    }

    public void addWfsGmlSettings() {
        String[][] data = new String[][]{{"V_11", "URN", "false"}, {"V_20", "URN2", "false"}, {"V_10", "XML", "true"}};
        Element root = new Element("gml");
        for (String[] entryData : data) {
            Element entry = new Element("entry");
            Element version = new Element("version");
            version.setText(entryData[0]);
            entry.addContent((Content)version);
            Element gml = new Element("gml");
            Element style = new Element("srsNameStyle");
            style.setText(entryData[1]);
            gml.addContent((Content)style);
            Element override = new Element("overrideGMLAttributes");
            override.setText(entryData[2]);
            gml.addContent((Content)override);
            entry.addContent((Content)gml);
            root.addContent((Content)entry);
        }
        this.addContent((Content)root);
    }

    private void addWmsMetadata(String wmsMetadataId) {
        String ENTRY = "entry";
        String KEY = "key";
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "15", KEY, "jpegCompression"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "100", KEY, "pngCompression"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "auto", KEY, "kmlSuperoverlayMode"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "1000", KEY, "framesDelay"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "refresh", KEY, "kmlReflectorMode"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "", KEY, "inspire.spatialDatasetIdentifier"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "dut", KEY, "inspire.language"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "40", KEY, "kmlKmscore"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "true", KEY, "svgAntiAlias"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "http://www.nationaalgeoregister.nl/geonetwork/srv/eng/csw?service=CSW&version=2.0.2&request=GetRecordById&outputschema=http://www.isotc211.org/2005/gmd&elementsetname=full&id=" + wmsMetadataId, KEY, "inspire.metadataURL"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "false", KEY, "kmlPlacemark"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "true", KEY, "kmlAttr"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "2147483647", KEY, "maxAllowedFrames"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "[{'name': 'PDOK', 'href' : 'http://www.pdok.nl", KEY, "authorityURLs'"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "application/vnd.ogc.csw.GetRecordByIdResponse_xml", KEY, "inspire.metadataURLType"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "false", KEY, "loopContinuously"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "Batik", KEY, "svgRenderer"));
    }

    private void addWfsMetadata(String wfsMetadataId) {
        String ENTRY = "entry";
        String KEY = "key";
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "false", KEY, "SHAPE-ZIP_DEFAULT_PRJ_IS_ESRI"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, wfsMetadataId, KEY, "inspire.spatialDatasetIdentifier"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "application/vnd.ogc.csw.GetRecordByIdResponse_xml", KEY, "inspire.metadataURLType"));
        this.metadata.addContent((Content)this.createElementWithAttribute(ENTRY, "http://www.nationaalgeoregister.nl/geonetwork/srv/eng/csw?service=CSW&version=2.0.2&request=GetRecordById&outputschema=http://www.isotc211.org/2005/gmd&elementsetname=full&id=" + wfsMetadataId, KEY, "inspire.metadataURL"));
    }

    private void addWmsDefaultFields() {
        this.add("maintainer", MAINTAINER);
        this.add("schemaBaseURL", SCHEMABASEURL);
        this.add("bboxForEachCRS", "true");
        this.addWatermark();
        this.add("interpolation", "Bicubic");
        this.add("maxBuffer", "25");
        this.add("maxRequestMemory", "270336");
        this.add("maxRenderingTime", "60");
        this.add("maxRenderingErrors", "1000");
    }

    private void addWfsDefaultFields() {
        this.add("schemaBaseURL", SCHEMABASEURL);
        this.add("serviceLevel", "BASIC");
        this.add("maxFeatures", "15000");
        this.add("featureBounding", "false");
        this.add("canonicalSchemaLocation", "false");
        this.add("encodeFeatureMember", "false");
        this.addWfsGmlSettings();
    }

    public void setWorkspace(String workspaceName) {
        Element name = new Element(NAMESTRING);
        name.setText(workspaceName);
        this.workspaceElement.addContent((Content)name);
    }

    private void addWatermark() {
        Element watermark = new Element("watermark");
        Element enabled = new Element("enabled");
        enabled.setText("false");
        watermark.addContent((Content)enabled);
        Element position = new Element("position");
        position.setText("BOT_RIGHT");
        watermark.addContent((Content)position);
        Element transparency = new Element("transparency");
        transparency.setText("0");
        watermark.addContent((Content)transparency);
        this.addContent((Content)watermark);
    }

    protected void addEnabled() {
        this.add("enabled", "true");
    }

    public void setTitle(String title) {
        this.add("title", title);
    }

    public void setAbstract(String abstractText) {
        this.add("abstrct", abstractText);
    }

    public void setAccessConstraints(String accessConstraints) {
        this.add("accessConstraints", accessConstraints);
    }

    public void setFees(String fees) {
        this.add("fees", fees);
    }

    public void setSrs(List<String> values) {
        Element srs = new Element("srs");
        for (String value : values) {
            Element valueElement = new Element("string");
            valueElement.setText(value);
            srs.addContent((Content)valueElement);
        }
        this.addContent((Content)srs);
    }

    public void addKeyword(String keyword) {
        Element valueElement = new Element("string");
        valueElement.setText(keyword);
        this.keywordsElement.addContent((Content)valueElement);
    }
}

