/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.utils;

import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class NestedElementEncoder
extends XmlElement {
    public static final String ENTRY = "entry";
    public static final String KEY = "key";

    public NestedElementEncoder(String listName) {
        super(listName);
    }

    @Override
    public void set(String key, String value) {
        Element search = ElementUtils.contains(this.getRoot(), new NestedElementFilter(this.getRoot(), key, null));
        if (search != null) {
            ElementUtils.remove(this.getRoot(), search);
        }
        this.add(key, value);
    }

    public void set(String key, Element value) {
        Element search = ElementUtils.contains(this.getRoot(), new NestedElementFilter(this.getRoot(), key, value.getName()));
        if (search != null) {
            ElementUtils.remove(this.getRoot(), search);
        }
        this.add(key, value);
    }

    public void add(String key, Element value) {
        Element entryElem = new Element(ENTRY);
        if (key != null) {
            entryElem.setAttribute(KEY, key);
        }
        entryElem.addContent((Content)value);
        this.addContent((Content)entryElem);
    }

    @Override
    public void add(String key, String value) {
        Element entryElem = new Element(ENTRY);
        if (key != null) {
            entryElem.setAttribute(KEY, key);
        }
        entryElem.setText(value);
        this.addContent((Content)entryElem);
    }

    public void add(String key, List<Element> list) {
        Element entryElem = new Element(ENTRY);
        if (key != null) {
            entryElem.setAttribute(KEY, key);
        }
        entryElem.addContent(list);
        this.addContent((Content)entryElem);
    }

    public void set(String key, List<Element> value) {
        Element search = ElementUtils.contains(this.getRoot(), new NestedElementFilter(this.getRoot(), key, value.get(0).getValue()));
        if (search != null) {
            ElementUtils.remove(search, search);
        }
        this.add(key, value);
    }

    @Override
    public boolean remove(String key) {
        Element search = ElementUtils.contains(this.getRoot(), new NestedElementFilter(this.getRoot(), key, null));
        if (search != null) {
            return ElementUtils.remove(search, search);
        }
        return false;
    }

    static class NestedElementFilter
    implements Filter {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final String value;
        private final Element root;

        public NestedElementFilter(Element root, String key, String value) {
            this.key = key;
            this.root = root;
            this.value = value;
        }

        public boolean matches(Object obj) {
            Element el;
            if (obj instanceof Element && this.root.isAncestor(el = (Element)obj) && el.getName().equals(NestedElementEncoder.ENTRY)) {
                boolean keyCheck = true;
                if (this.key != null) {
                    keyCheck = el.getAttribute(NestedElementEncoder.KEY).getValue().equals(this.key);
                }
                if (this.value != null) {
                    return keyCheck && NestedElementFilter.checkChilds(el, this.value);
                }
                return keyCheck;
            }
            return false;
        }

        private static boolean checkChilds(Element el, String value) {
            List childList = el.getChildren();
            for (Element child : childList) {
                if (!child.getName().equals(value)) continue;
                return true;
            }
            return false;
        }
    }
}

