/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.manager;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.decoder.RESTStructuredCoverageGranulesList;
import it.geosolutions.geoserver.rest.decoder.RESTStructuredCoverageIndexSchema;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTAbstractManager;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerRESTStructuredGridCoverageReaderManager
extends GeoServerRESTAbstractManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerRESTStructuredGridCoverageReaderManager.class);

    public GeoServerRESTStructuredGridCoverageReaderManager(URL restURL, String username, String password) throws IllegalArgumentException {
        super(restURL, username, password);
    }

    public boolean create(String workspace, String coverageStore, String path) {
        return this.create(workspace, coverageStore, path, ConfigureCoveragesOption.ALL);
    }

    public boolean create(String workspace, String coverageStore, String path, ConfigureCoveragesOption configureOpt) {
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(workspace);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverageStore);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(path);
        File zipFile = new File(path);
        if (!(zipFile.exists() && zipFile.isFile() && zipFile.canRead())) {
            throw new IllegalArgumentException("The provided pathname does not point to a valide zip file: " + path);
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            zip.getName();
        }
        catch (Exception e) {
            LOGGER.trace(e.getLocalizedMessage(), (Object[])e.getStackTrace());
            throw new IllegalArgumentException("The provided pathname does not point to a valide zip file: " + path);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    LOGGER.trace(e.getLocalizedMessage(), (Object[])e.getStackTrace());
                }
            }
        }
        StringBuilder ss = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", workspace, "/coveragestores/", coverageStore, "/file.imagemosaic");
        switch (configureOpt) {
            case ALL: {
                break;
            }
            case NONE: {
                ss.append("?configure=none");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized COnfigureOption: " + (Object)((Object)configureOpt));
            }
        }
        String sUrl = ss.toString();
        String result = HTTPUtils.put(sUrl, zipFile, "application/zip", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean harvestExternal(String workspace, String coverageStore, String format, String path) {
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(workspace);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverageStore);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(format);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(path);
        String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", workspace, "/coveragestores/", coverageStore, "/", GeoServerRESTPublisher.UploadMethod.EXTERNAL.toString(), ".", format).toString();
        String result = HTTPUtils.post(sUrl, "file://" + path, "text/plain", this.gsuser, this.gspass);
        return result != null;
    }

    private static void checkString(String string) {
        if (string == null) {
            throw new NullPointerException("Provided string is is null!");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("Provided string is is empty!");
        }
    }

    public boolean removeGranulesByCQL(String workspace, String coverageStore, String coverage, String filter) throws UnsupportedEncodingException {
        RESTStructuredCoverageGranulesList granulesList;
        block12: {
            block11: {
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(workspace);
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverage);
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(filter);
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverageStore);
                granulesList = null;
                try {
                    granulesList = this.getGranules(workspace, coverageStore, coverage, filter, null, 1);
                }
                catch (MalformedURLException e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(e.getMessage(), (Throwable)e);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOGGER.isTraceEnabled()) break block11;
                    LOGGER.trace(e.getMessage(), (Throwable)e);
                }
            }
            if (granulesList == null || granulesList.isEmpty()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Granules for filter: " + filter + " does not exist for coverage " + coverage);
                }
                return true;
            }
            String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", workspace, "/coveragestores", "/", coverageStore, "/coverages/", coverage, "/index/granules?filter=", URLEncoder.encode(filter, "UTF-8")).toString();
            if (!HTTPUtils.delete(sUrl, this.gsuser, this.gspass)) {
                return false;
            }
            granulesList = null;
            try {
                granulesList = this.getGranules(workspace, coverageStore, coverage, filter, null, 1);
            }
            catch (MalformedURLException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(e.getMessage(), (Throwable)e);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!LOGGER.isTraceEnabled()) break block12;
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        return granulesList == null || granulesList.isEmpty();
    }

    public boolean removeGranuleById(String workspace, String coverageStore, String coverage, String granuleId) {
        RESTStructuredCoverageGranulesList granule;
        block12: {
            block11: {
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(workspace);
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverage);
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(granuleId);
                GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverageStore);
                granule = null;
                try {
                    granule = this.getGranuleById(workspace, coverageStore, coverage, granuleId);
                }
                catch (MalformedURLException e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(e.getMessage(), (Throwable)e);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOGGER.isTraceEnabled()) break block11;
                    LOGGER.trace(e.getMessage(), (Throwable)e);
                }
            }
            if (granule == null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Granule for id: " + granuleId + " does not exist for coverage " + coverage);
                }
                return true;
            }
            String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", workspace, "/coveragestores", "/", coverageStore, "/coverages/", coverage, "/index/granules/", granuleId).toString();
            if (!HTTPUtils.delete(sUrl, this.gsuser, this.gspass)) {
                return false;
            }
            granule = null;
            try {
                granule = this.getGranuleById(workspace, coverageStore, coverage, granuleId);
            }
            catch (MalformedURLException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(e.getMessage(), (Throwable)e);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!LOGGER.isTraceEnabled()) break block12;
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        return granule == null;
    }

    public RESTStructuredCoverageIndexSchema getGranuleIndexSchema(String workspace, String coverageStore, String coverage) throws MalformedURLException {
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(workspace);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverage);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverageStore);
        String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", workspace, "/coveragestores/", coverageStore, "/coverages/", coverage, "/index.xml").toString();
        String result = HTTPUtils.get(sUrl, this.gsuser, this.gspass);
        if (result != null) {
            return RESTStructuredCoverageIndexSchema.build(result);
        }
        return null;
    }

    public RESTStructuredCoverageGranulesList getGranules(String workspace, String coverageStore, String coverage) throws MalformedURLException, UnsupportedEncodingException {
        return this.getGranules(workspace, coverageStore, coverage, null, null, null);
    }

    public RESTStructuredCoverageGranulesList getGranules(String workspace, String coverageStore, String coverage, String filter, Integer offset, Integer limit) throws MalformedURLException, UnsupportedEncodingException {
        String result;
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(workspace);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverage);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverageStore);
        boolean append = false;
        String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", workspace, "/coveragestores/", coverageStore, "/coverages/", coverage, "/index/granules.xml").toString();
        if (filter != null && !filter.isEmpty()) {
            append = true;
            sUrl = HTTPUtils.append(sUrl, "?filter=", URLEncoder.encode(filter, "UTF-8")).toString();
        }
        if (offset != null) {
            if (offset < 0) {
                offset = 0;
            }
            sUrl = HTTPUtils.append(sUrl, append ? "&offset=" : "?offset=", offset.toString()).toString();
            append = true;
        }
        if (limit != null) {
            if (limit < 1) {
                limit = 1;
            }
            sUrl = HTTPUtils.append(sUrl, append ? "&limit=" : "?limit=", limit.toString()).toString();
            append = true;
        }
        if ((result = HTTPUtils.get(sUrl, this.gsuser, this.gspass)) != null) {
            return RESTStructuredCoverageGranulesList.build(result);
        }
        return null;
    }

    public RESTStructuredCoverageGranulesList getGranuleById(String workspace, String coverageStore, String coverage, String id) throws MalformedURLException, UnsupportedEncodingException {
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(workspace);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverage);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(coverageStore);
        GeoServerRESTStructuredGridCoverageReaderManager.checkString(id);
        try {
            Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", workspace, "/coveragestores/", coverageStore, "/coverages/", coverage, "/index/granules/", id, ".xml").toString();
        String result = HTTPUtils.get(sUrl, this.gsuser, this.gspass);
        if (result != null) {
            return RESTStructuredCoverageGranulesList.build(result);
        }
        return null;
    }

    public static enum ConfigureCoveragesOption {
        NONE,
        ALL;


        public static ConfigureCoveragesOption getDefault() {
            return ALL;
        }
    }
}

