/**
　 * <p>Title: asdasd.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月9日
　 * @version 1.0
*/
package com.northpool.commons.collection;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedHashSet;

/**
 * @author matt
 *
 */
public class SetQueue<E> extends AbstractQueue<E> {

    private final LinkedHashSet<E> set = new LinkedHashSet<>();

    @Override
    public Iterator<E> iterator() {
      return this.set.iterator();
    }

    @Override
    public boolean offer(final E o) {
      this.set.add(o);
      return true;
    }

    /**
     *在队列的头部查询元素
     * 队列为空时，返回null
     */
    @Override
    public E peek() {
      final Iterator<E> iterator = iterator();
      if (iterator.hasNext()) {
        final E value = iterator.next();
        return value;
      } else {
        return null;
      }
    }

    /**
     *从队列中删除第一个元素
     * 队列为空时，输出null
     */
    @Override
    public E poll() {
      final Iterator<E> iterator = iterator();
      if (iterator.hasNext()) {
        final E value = iterator.next();
        iterator.remove();
        return value;
      } else {
        return null;
      }
    }

    @Override
    public int size() {
      return this.set.size();
    }
  }