package com.northpool.commons.collection.builder;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

import com.northpool.commons.util.UnsafeFuntion;

import sun.nio.ch.DirectBuffer;

@SuppressWarnings("restriction")
public abstract class AbstractBuilder<HEAP_TYPE> {
	
    protected final int beginSize = 8 * 256;
        
    protected int expansionHeapTimes = 1;

    protected final int directApplySize = 1024 * 1024;
    
    protected HEAP_TYPE heap;
    
    protected int capacity;
    
    protected int size;

    protected Boolean isDirect = false;
    
    protected int typeSize = 0;
    
    protected int directApplySizeNum;
    
    protected ArrayList<ByteBuffer> directBufferArr;
   
    protected ByteBuffer currentDirectByteBuffer = null;

    abstract HEAP_TYPE createHeap(int size);
    
    private static final ByteOrder nativeOrder = ByteOrder.nativeOrder();
    
    public AbstractBuilder() {
        
        this.typeSize = this.getTypeSize();
        this.capacity = this.beginSize / this.typeSize;
        this.heap = this.createHeap(this.capacity);
        this.directApplySizeNum =  directApplySize / this.typeSize;
        
        //this.capacity = 
    }

    abstract int getTypeSize();
    
    public AbstractBuilder(HEAP_TYPE arr) {
        this();
        this.append(arr,0,this.getHeapSize(arr));
    }
    
    public AbstractBuilder(int size){
        this.typeSize = this.getTypeSize();
        this.capacity = size;
        if(directApplySizeNum > size){
            this.heap = this.createHeap(size);
        }else{
            this.isDirect = true;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(size * typeSize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
        }
    }
    
    private void clean(final ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            DirectBuffer db = (DirectBuffer) byteBuffer;
            db.cleaner().clean();
        }
    }
    
    
    public Boolean isDirect() {
        return this.isDirect;
    }

    
    public int size() { 
        return this.size;
    }
    
    /**
     * heap扩容,采取翻倍扩容方案
     * @param arrSize
     */
    private void expansionInHeap(int arrSize) {
        int applySize = this.beginSize * expansionHeapTimes / this.typeSize ;
        this.expansionHeapTimes ++;
        int newSize = (applySize > arrSize) ? this.capacity + applySize : arrSize + arrSize % applySize + this.capacity;
        HEAP_TYPE newHeap = this.createHeap(newSize);
        System.arraycopy(this.heap, 0,
                newHeap, 0, this.size);
        this.heap = newHeap;
        this.capacity = newSize;
    }
    
    private void expansionInDirect(int size) {
        
        //int newSize = (this.directApplySize > size) ? this.capacity * this.typeSize + this.directApplySize : size + size % this.directApplySize + this.capacity;
        if(size > this.directApplySizeNum){
            int times = (int)size / (this.directApplySizeNum) + 1;
            int newCapacity = this.directApplySizeNum * times;
            while(times --> 0){
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
                this.directBufferArr.add(newBuffer);
            }
            this.capacity = newCapacity;
        }else{
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity = this.capacity + this.directApplySizeNum;
        }
    }
    
    protected ByteBuffer getByteBuffer(int index){
        index = (int)(index / this.directApplySize);
        return this.directBufferArr.get(index);
        
    }
    
   // abstract protected void putArrIntoDirectByteBuffer(ByteBuffer buffer, Object arr, int offset, int length);
    
    public ByteOrder order() {
        return ((ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN)
                ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }
    
    protected void putArrIntoDirectByteBuffer(ByteBuffer buffer, Object arr, int offset, int length) {
        if(nativeOrder == ByteOrder.LITTLE_ENDIAN){
            this.putArrIntoDirectByteBufferL(buffer, arr, offset, length);
        }else{
            throw new RuntimeException("暂时不支持大端");
        }
    }
    
    
    
    protected void putArrIntoDirectByteBufferL(ByteBuffer buffer, Object arr, int offset, int length) {

        if(!(buffer instanceof DirectBuffer)){
            throw new RuntimeException("buffer必须是DirectBuffer");
        }
        // TODO Auto-generated method stub
         int pos = buffer.position() / this.typeSize;
         int lim = buffer.limit() / this.typeSize; 
         assert (pos <= lim);
         int rem = (pos <= lim ? lim - pos : 0);
         if (length > rem){
             throw new BufferOverflowException();
         }
         
         DirectBuffer directBuffer = (DirectBuffer)buffer;
         
        // ByteBuffer
         int off = getHeapTypeOff();
         
         long dstAddr = directBuffer.address() + ((long)pos  << off);
         try{
             if (order() != ByteOrder.nativeOrder()){
                 UnsafeFuntion.get().copyFromLongArray(arr, (long)offset << off, dstAddr,  (long)length << off);
             }else{
                 UnsafeFuntion.get().copyFromArray(arr, getHeapTypeOffset(),(long)offset << off, dstAddr,  (long)length << off); 
             }
         }catch(Exception e){
             throw new RuntimeException(e);
         }
         buffer.position((pos + length) * this.typeSize);
    }
    
    abstract protected long getHeapTypeOffset();
    
    abstract protected int getHeapTypeOff();
    
    abstract protected int getHeapSize(HEAP_TYPE heap);
    
    /**
     * 转换为堆外
     * @param size
     */
    private void toDirect(int size) {
        this.isDirect = true;
        ByteBuffer newBuffer;
        int newSize = this.directApplySize;
        this.directBufferArr = new ArrayList<ByteBuffer>();
        
        //判断原有+申请如果大于一次最大的direct容量
        if((size + this.capacity) * this.typeSize > this.directApplySize){
            
            //先计算出有几个direct的容量
            int times = (int)((size + this.capacity) * this.typeSize)/(this.directApplySize) + 1;
            int copyDone = 0;
            //新容量则为申请direct的最大值/typesize
            int newCapacity = this.directApplySize / this.typeSize * times;
            //开始分批申请
            while(times --> 0){
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.directApplySize);
                //申请一批放入direct队列中
                this.directBufferArr.add(byteBuffer);
                //开始拷贝heap中的数据
                int directByteBufferSize = this.directApplySize / this.typeSize;
                if(copyDone < this.size){
                    if(this.size > directByteBufferSize){
                        this.putArrIntoDirectByteBuffer(byteBuffer, this.heap, copyDone, directByteBufferSize);
                    }else{
                        if(this.getHeapSize(this.heap) - copyDone != 0){
                            this.putArrIntoDirectByteBuffer(byteBuffer, this.heap, copyDone, this.size - copyDone);
                        }
                        this.currentDirectByteBuffer = byteBuffer;
                    }
                }
                copyDone = copyDone + directByteBufferSize;
            }
            this.capacity = newCapacity;
            
            
        }else{//如果一次申请小于一个direct的量
            this.capacity = this.directApplySize / this.typeSize;
            newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity = newSize / this.typeSize;
            this.putArrIntoDirectByteBuffer(newBuffer, this.heap, 0, this.size);
            
        }
    }
    
    
    public void trimToSize() {
        if (!this.isDirect) {
            HEAP_TYPE newHeap =  this.createHeap(this.size);
            System.arraycopy(this.heap, 0,
                    newHeap, 0, size);
            this.heap = newHeap;
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentDirectByteBuffer.position());
            this.currentDirectByteBuffer.flip();
            newBuffer.put(this.currentDirectByteBuffer);
            DirectBuffer db = (DirectBuffer) this.currentDirectByteBuffer;
            db.cleaner().clean();
            this.directBufferArr.set(this.directBufferArr.size() - 1, newBuffer);
            this.currentDirectByteBuffer = newBuffer;
        }
    }
    
    
    public void destroy() {
        if (this.isDirect) {
            for(ByteBuffer bf:this.directBufferArr){
                this.clean(bf);
            }
        }
    }
    
    /**
     * 扩容
     * @param size
     */
    protected void ensureCapacityInternal(int size) {
        if (this.isDirect == false) {
            if (((this.capacity + size) * this.typeSize + this.beginSize * this.expansionHeapTimes)  > this.directApplySize) {
                this.toDirect(size);
            } else {
                this.expansionInHeap(size);
            }
        } else {
            this.expansionInDirect(size);
        }
    }

    
    public AbstractBuilder<HEAP_TYPE> append(HEAP_TYPE arr, int offset, int length) {
        if (arr == null) {
            return this;
        }
        
        if (this.capacity <= length - offset + this.size) {
            this.ensureCapacityInternal(length - offset);
        }

        if (this.isDirect) {
            
            int beginBlockIndex = (int)(this.size / this.directApplySizeNum);
            int beginSubIndex = (int)(this.size % this.directApplySizeNum);
            int endBlockIndex = (int)((length - offset + this.size) / this.directApplySizeNum + 1);
            int copyDone = 0;
            for(int i = beginBlockIndex ; i < endBlockIndex ; i ++){
                int copyLength = this.directApplySizeNum;
                ByteBuffer dbb = null;
                try{
                    dbb = this.directBufferArr.get(i);
                }catch(Exception e){
                    e.printStackTrace();
                }
                if(i == beginBlockIndex){
                    copyLength = this.directApplySizeNum - beginSubIndex;
                }
                if(i == endBlockIndex - 1){
                    copyLength = length - offset - copyDone;
                }
                this.putArrIntoDirectByteBuffer(dbb, arr, copyDone, copyLength);
                copyDone = copyDone + copyLength;
            }        
        //  this.putArrIntoDirectByteBuffer(this.directByteBuffer, arr, offset, length);

        } else {
            System.arraycopy(arr, offset,
                    this.heap, this.size, length - offset);
        }
        this.size = this.size + length - offset;
        return this;
    }

    static void checkBounds(int off, int len, int size) {
        if ((off | len | (off + len) | (size - (off + len))) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
    
    
    
    @Override
    public String toString() {
         StringBuffer sb = new StringBuffer();
            sb.append(getClass().getName());
            sb.append("[size=");
            sb.append(this.size);
            sb.append(" cap=");
            sb.append(this.capacity);
            sb.append("]");
            return sb.toString();
    }
    
    public AbstractBuilder<HEAP_TYPE> delete(int start, int end) {
        throw new RuntimeException("没有实现");
        // return this;
    }

    public AbstractBuilder<HEAP_TYPE> deleteAt(int index) {
        throw new RuntimeException("没有实现");
        // return this;
    }
    
   
    public HEAP_TYPE toArray(){
        if(this.isDirect){
            throw new RuntimeException("暂时不支持");
        }else{
            return this.heap;
        }
    }

    
    public void reset(){
        this.size = 0;
        this.capacity = this.beginSize / this.typeSize;
        if(this.isDirect){
            for(ByteBuffer bf:this.directBufferArr){
                this.clean(bf);
            }
            this.directBufferArr = new ArrayList<ByteBuffer>();
            this.isDirect = false;
        }
    }

}
