package com.northpool.commons.event;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;




public class EventContainer<T extends Listener> {
	//ConcurrentLinkedQueue<String> tileKey = new ConcurrentLinkedQueue<String>();  
	
	private final ConcurrentHashMap<String,ConcurrentLinkedQueue<T>> eventMap = new ConcurrentHashMap<String,ConcurrentLinkedQueue<T>>();
	
	
	//private final ConcurrentLinkedQueue<Listener> queue = new ConcurrentLinkedQueue<Listener>();
	
	public void on(String eventName,T listener){
		ConcurrentLinkedQueue<T> queue = eventMap.get(eventName);
		if(queue == null){
			queue = this.createQueue(eventName);
			eventMap.put(eventName,queue);
		}
		queue.add(listener);
	}
	
	
	
	private synchronized ConcurrentLinkedQueue<T> createQueue(String eventName){
		ConcurrentLinkedQueue<T> queue = eventMap.get(eventName);
		if(queue == null){
			queue = new ConcurrentLinkedQueue<T>();
		}
		return queue;
	}
	
	public void un(String eventName,T listener){
		ConcurrentLinkedQueue<T> queue = eventMap.get(eventName);
		if(queue == null){
			return;
		}
		queue.remove(listener);
	}
	
	public void syncFireEvent(String eventName,Object ...parameter){
		ConcurrentLinkedQueue<T> queue = eventMap.get(eventName);
		if(queue == null){
			return;
		}
		queue.forEach(listener -> {
			listener.fire(parameter);
		});
	}
	
	public void asyncFireEvent(String eventName, Executor executor,Object ...parameter){
		ConcurrentLinkedQueue<T> queue = eventMap.get(eventName);
		if(queue == null){
			return;
		}
		queue.forEach(listener -> {
			executor.execute(() ->{
				listener.fire(parameter);
			});
		});
	}
}
