/**
　 * <p>Title: FileChannelWriter.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年9月8日
　 * @version 1.0
*/
package com.northpool.commons.filechannel;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;

import java.util.concurrent.LinkedBlockingQueue;


import com.concurrentli.EpochEvent;
import com.concurrentli.FutureEpochEvent;
import com.northpool.commons.util.FileUtil;

import sun.nio.ch.DirectBuffer;

/**
 * @author matt
 *
 */
@SuppressWarnings("restriction")
public class FileChannelWriter implements AutoCloseable {
    
    private String fileName;
        
    private int buffsize;
    
  //  private int flipLimit; 
    
    private ByteBuffer currentWriterBuffer;
    
    private FileChannel currentWriterChannel;
    
    private RandomAccessFile currentRandomAccessFile;
    
    private long splitSize = -1;
    
    private boolean split = false;
    
    private boolean md5 = false;
    
    //private ThreadPoolExecutor executor;// = new ThreadPoolExecutor(1, 1,0L, TimeUnit.MILLISECONDS,new LinkedBlockingQueue<Runnable>());     
    
    private LinkedBlockingQueue<byte[]> md5BlockLink;
   
    private long fileSize = 0;
    
    private long currentOffset = 0;
    
    private int filePathIndex = 0;
    
    private final EpochEvent epoch = new FutureEpochEvent(0);
    
    private FileInfo fileInfo;
    
    public FileInfo getFileInfo() {
        return fileInfo;
    }


    private SplitFilePart currentSplitFilePart;
    
    private byte[] md5Block;
    
   // private boolean isEnd = false;
    
 //   private final ReentrantLock lock = new ReentrantLock();
  //  private Boolean addHead = false;
    
 //   private byte[] headInfo;
    
    
    
    
    public FileChannelWriter(String fileName,Integer buffsize) throws IOException{
        this.fileName = fileName;
        this.buffsize = buffsize;
       // this.flipLimit = (buffsize / 20 >  512 * 1024) ? buffsize / 20 : 512 * 1024;
       
     
        
        if(this.splitSize > 0){
            split = true;
        }
    }
    
   /* public FileChannelWriter(String fileName,Integer buffsize,Boolean addHead,byte[] headInfo) throws IOException{
        this.fileName = fileName;
        this.buffsize = buffsize;
       // this.flipLimit = (buffsize / 20 >  512 * 1024) ? buffsize / 20 : 512 * 1024;
       
        this.addHead = addHead;
        this.headInfo = headInfo;
        
        if(this.splitSize > 0){
            split = true;
        }
    }*/
    
    
    
    public FileChannelWriter md5(Boolean md5){
        this.md5 = md5;
        this.md5Block = new byte[256 * 1024];
        this.md5BlockLink = new LinkedBlockingQueue<>();
        return this;
    }
    
    public FileChannelWriter setSplitSize(long splitSize){
        this.splitSize = splitSize;
        this.split = true;
        return this;
    }
    
    public FileChannelWriter build() throws IOException{
        this.fileInfo = new FileInfo();
        this.fileInfo.setFileName(Paths.get(this.fileName).getFileName().toString());
        String pathName = null;
        if(split){
            pathName = this.createPathName();
        }else{
            pathName = this.fileName;
        }
        this.createFileMappingBuffer(pathName);
        return this;
    }
    
    private String createPathName(){
        return this.fileName + "." + this.filePathIndex + ".tmp";
    }
    
    private void createFileMappingBuffer(String pathName) throws IOException{
        this.currentRandomAccessFile = new RandomAccessFile(pathName,"rw");
        this.currentWriterChannel = this.currentRandomAccessFile.getChannel();
        this.currentWriterBuffer = ByteBuffer.allocateDirect(this.buffsize);
        this.currentOffset = 0;
        if(this.split){
            SplitFilePart splitFilePart = new SplitFilePart();
            splitFilePart.setIndex(this.filePathIndex);
            splitFilePart.setFileName(Paths.get(pathName).getFileName().toString());
            this.currentSplitFilePart = splitFilePart;
        }
    }
    
    private String createInfoName(){
        return this.fileName + "_info.json"; 
    }
    
    public void end() throws IOException, InterruptedException{
        
        if(this.split){
            this.endPart();
        }else{
            this.closeFileFileChannel();
        }
  //      this.isEnd = true;
        this.fileInfo.setFileSize(this.fileSize);
     
     
        if(this.md5){
           
            this.fileInfo.buildMD5();
            
            FileUtil.byte2File(this.fileInfo.toJson().getBytes("utf-8"), this.createInfoName());
        }
    }
    
   
    private void putMD5BlockData(byte[] block){
        
        
    }
    
    
    private void endPart() throws IOException{
        this.closeFileFileChannel();
        this.currentSplitFilePart.setPartSize(this.currentOffset);
        this.fileInfo.getPart().add(this.currentSplitFilePart);
    }
    
    private void closeFileFileChannel() throws IOException{
        try {
            this.currentWriterBuffer.flip(); 
            this.currentWriterChannel.write(this.currentWriterBuffer);  
            this.clean(this.currentWriterBuffer);
            this.currentWriterChannel.close();
            this.currentRandomAccessFile.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new IOException();
        } finally {
          
        }
    }
    
    private void clean(final ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            DirectBuffer db = (DirectBuffer) byteBuffer;
            db.cleaner().clean();
        }
    }
    
    
    
    
    private void putIntoBuffer(byte[] bytes,int offset, int length){
        this.currentWriterBuffer.put(bytes,offset,length);
        this.currentOffset = this.currentOffset + length;
        if(this.md5){
         
          //  executor.execute(() -> {
                this.fileInfo.putMD5Data(bytes,offset,length);
                if(this.split){
                    this.currentSplitFilePart.putMD5Data(bytes, offset, length);
                }
                /*if(this.isEnd){
                    if(executor.getQueue().isEmpty()){
                        currentThread.interrupt();
                    }
                }*/
        //    });
            
            
           /* executor.execute;*/
        }
    }
    
    //private void 
    
    private synchronized void putSynchronized(byte[] bytes,int offset,int length) throws IOException, InterruptedException {
        int bytesLength = length;
        if(this.currentWriterBuffer.remaining() < bytesLength){//防止BufferOverflowException   
            this.currentWriterBuffer.flip(); 
            this.currentWriterChannel.write(this.currentWriterBuffer);  
            this.currentWriterBuffer.compact();
        }
        if(this.split){
            if(this.currentOffset + bytesLength > this.splitSize){
                int fristPart = (int)((this.splitSize - this.currentOffset));
                if(fristPart == 0){
                    this.endPart();
                    this.filePathIndex ++;
                    this.createFileMappingBuffer(this.createPathName());
                    this.putIntoBuffer(bytes,offset,bytesLength);
                }else{
                    this.putIntoBuffer(bytes, offset, fristPart);
                    this.endPart();
                    this.filePathIndex ++;
                    this.createFileMappingBuffer(this.createPathName());
                    this.putIntoBuffer(bytes, fristPart, bytesLength - fristPart);
                }
            }else{
                this.putIntoBuffer(bytes,offset,bytesLength);
            }
        }else{
            this.putIntoBuffer(bytes,offset,bytesLength);
        }
        this.fileSize = this.fileSize + bytesLength;
    }
    
    public void write(byte[] bytes,int offset,int length)  throws IOException, InterruptedException {
        long sizeBytes = bytes.length;
        if(sizeBytes > buffsize){
            throw new IOException("输入的bytes大小不能大于缓存大小:" + buffsize);
        }
        this.putSynchronized(bytes,offset,length);
    }
    
    
    /**
     * @param bytes
     * @throws IOException 
     * @throws InterruptedException 
     */
    public void write(byte[] bytes) throws IOException, InterruptedException {
        this.write(bytes, 0, bytes.length);
        
    }
    
    
    
  /*  public static void main(String[] args) throws IOException, InterruptedException{
        String fileLine = "1234567890存储超出擦擦擦\r";
        long a = System.currentTimeMillis();
        FileChannelWriter writer = new FileChannelWriter("c:/test/aaa/aaa", 1024 * 1024 * 1).md5(false).setSplitSize(1024 * 1024 * 50).build();
        for(int i = 0 ; i < 100000000 ; i ++){
            writer.write(fileLine.getBytes());
        }
        writer.end();
        FileInfo splitFileInfo = writer.fileInfo;
        System.out.println(System.currentTimeMillis() - a);
        FileUtil.byte2File(splitFileInfo.toJson().getBytes("utf-8"),"c:/test/aaa/aaa.info");
      
    }*/


    /* (non-Javadoc)
     * @see java.lang.AutoCloseable#close()
     */
    @Override
    public void close() throws Exception {
        // TODO Auto-generated method stub
        if(this.currentWriterChannel != null){
            this.currentWriterChannel.close();
            this.currentRandomAccessFile.close();
        }
    }


    
    
}
