/**
　 * <p>Title: SplitFileInfo.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年9月8日
　 * @version 1.0
*/
package com.northpool.commons.filechannel;

import java.util.ArrayList;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.Jsonable;
import com.northpool.commons.util.ThreadLocalMD5;


/**
 * @author matt
 *
 */
public class FileInfo implements Jsonable{
    private String fileName;
    private Long fileSize;
    private String md5;
    transient private ThreadLocalMD5 threadLocalMD5 = new ThreadLocalMD5();
    
    private ArrayList<SplitFilePart> part = new ArrayList<>();
    FileInfo(){
        
    }
    public void buildMD5(){
        this.md5 = this.threadLocalMD5.getMD5();
        for(SplitFilePart part : this.part){
            part.buildMD5();
        }
    }
    
    public void putMD5Data(byte[] bytes,int offset, int length){
        this.threadLocalMD5.put(bytes, offset, length);
    }
    
    public String getMd5() {
        return md5;
    }
    public void setMd5(String md5) {
        this.md5 = md5;
    }
    
    public String getFileName() {
        return fileName;
    }
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    public Long getFileSize() {
        return fileSize;
    }
    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }
    public ArrayList<SplitFilePart> getPart() {
        return part;
    }
    public void setPart(ArrayList<SplitFilePart> part) {
        this.part = part;
    }
    
    @Override
    public String toJson() {
        // TODO Auto-generated method stub
        return JSON.toJSONString(this);
    }
    
    
}
