/**
　 * <p>Title: ClassUnit.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年8月14日
　 * @version 1.0
*/
package com.northpool.commons.javacode.parser;

import java.util.HashMap;
import java.util.Map;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.expr.Name;

/**
 * @author matt
 *
 */
public class ClassUnit {
    PackageDeclaration packageDec;
    ClassBean mainClass;
    CompilationUnit unit;
    Map<String,ClassBean> subClassMap = new HashMap<>();
    ClassUnit(CompilationUnit unit){
        this.unit = unit;
    }
    
    public PackageDeclaration getPackageDec() {
        return packageDec;
    }

    public ClassBean getMainClass() {
        return mainClass;
    }

    public CompilationUnit getUnit() {
        return unit;
    }

    public Map<String, ClassBean> getSubClassMap() {
        return subClassMap;
    }

    public String getPackageName(){
        if(!unit.getPackageDeclaration().isPresent()){
            return null;
        }else{
            return unit.getPackageDeclaration().get().getNameAsString();
        }
    }
    
    public void setPackageName(String packageName){
        if(!unit.getPackageDeclaration().isPresent()){
            PackageDeclaration packageDeclaration = new PackageDeclaration(new Name(packageName));
            unit.setPackageDeclaration(packageDeclaration);
        }else{
            unit.getPackageDeclaration().get().setName(packageName);
        }
    }
    
    public void setMainClassName(String className){
        //改类名
        this.mainClass.setClassName(className);
        //改引用
    }
    
    public String getCode(){
        return this.unit.toString();
    }
    
}
