/**
　 * <p>Title: VisitorAdapter.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年8月14日
　 * @version 1.0
*/
package com.northpool.commons.javacode.parser;





import java.util.HashSet;

import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;

/**
 * @author matt
 *
 */
public class ClassUnitVisitorAdapter extends VoidVisitorAdapter<Object> {
    @Override
    public void visit(final PackageDeclaration cORid, final Object bean) {
        ClassUnit classUnit = (ClassUnit)bean;
        classUnit.packageDec = cORid;
        super.visit(cORid, bean);
    }
    
    @Override
    public void visit(final FieldDeclaration n, final Object bean) {
        ClassBean classBean = (ClassBean)bean;
        FieldBean fieldBean = new FieldBean(n);
        classBean.fieldMap.put(fieldBean.getFieldName(), fieldBean);
        super.visit(n, fieldBean);
    }
    @Override
    public void visit(final ClassOrInterfaceDeclaration cORid, final Object bean) {
        ClassUnit classUnit = (ClassUnit)bean;
        ClassBean classBean = new ClassBean(cORid);
        if(classUnit.mainClass == null){
            classUnit.mainClass = classBean;
        }else{
            classUnit.subClassMap.put(classBean.getClassName(), classBean);
        }
        super.visit(cORid, classBean);
    }
    @Override
    public void visit(final MethodDeclaration md, final Object bean) {
        ClassBean classBean = (ClassBean)bean;
        MethodBean methodBean = new MethodBean(md);
     
        classBean.methodList.add(methodBean);
       
        super.visit(md, methodBean);
    }
    
    
    
    @Override
    public void visit(final VariableDeclarator n, final Object bean) {
     //n.getType()
        super.visit(n, bean);
    }
    
   
}
