/**
　 * <p>Title: JavaParser.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年8月14日
　 * @version 1.0
*/
package com.northpool.commons.javacode.parser;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ParserConfiguration.LanguageLevel;
import com.github.javaparser.ast.CompilationUnit;


/**
 * @author matt
 *
 */
public class JavaParser {
    private Charset charset = Charset.forName("UTF-8");
    
    private LanguageLevel languageLevel = LanguageLevel.JAVA_8;
    
    private com.github.javaparser.JavaParser javaParser;
    
    public JavaParser(){
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setCharacterEncoding(charset);
        parserConfiguration.setLanguageLevel(languageLevel);
        this.javaParser = new com.github.javaparser.JavaParser(parserConfiguration);
    }
    
    public JavaParser(Charset charset,LanguageLevel languageLevel){
        this.charset = charset;
        this.languageLevel = languageLevel;
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setCharacterEncoding(charset);
        parserConfiguration.setLanguageLevel(languageLevel);
        this.javaParser = new com.github.javaparser.JavaParser(parserConfiguration);
    }
    
    
    public ClassUnit parser(final InputStream in){
        
        ParseResult<CompilationUnit> unitParseResult = javaParser.parse(in);

        CompilationUnit unit = unitParseResult.getResult().get();
        
        ClassUnitVisitorAdapter visitor = new ClassUnitVisitorAdapter();
        
        ClassUnit classUnit = new ClassUnit(unit);
        
        visitor.visit(unit, classUnit);
        
        return classUnit;
    }
    
    
}
