/**
　 * <p>Title: FileHandler.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年9月7日
　 * @version 1.0
*/
package com.northpool.commons.pipeline;

import java.io.IOException;

import com.northpool.commons.filechannel.FileChannelWriter;
import com.northpool.commons.filechannel.FileInfo;

/**
 * 文件处理器
 * @author matt
 *
 * @description 用于将数据写入磁盘上的文件，写入操作为单线程
 */
public class FileHandler extends AbstractHandler  implements Handler,AutoCloseable {

	/**
	 * 文件存储路径
	 */
    private String path;
    
    private FileChannelWriter writer;
    
    @SuppressWarnings("resource")
    public FileHandler(String path,Integer buffSize,Boolean md5,Integer splitSize) throws IOException{
        this.path = path;
        if(buffSize == null){
            buffSize = 1024 * 1024;
        }
        if(md5 == null){
            md5 = false;
        }
        this.writer = new FileChannelWriter(this.path, buffSize).md5(md5);
        if(splitSize != null){
            this.writer.setSplitSize(splitSize);
        }
        this.writer.build();
    }

    /* (non-Javadoc)
     * @see com.northpool.commons.pipeline.Handler#end()
     */
    @Override
    public void end() throws Exception {
        // TODO Auto-generated method stub
        
        this.writer.end();
        if(next != null){
            next.end();
        }
      
    }




    /* (non-Javadoc)
     * @see com.northpool.commons.pipeline.Handler#pushData(java.lang.Object)
     * 第二参数buffSize 默认为 1024 * 1024
     */
    @Override
    public <T> void pushData(T data) throws Exception {
        // TODO Auto-generated method stub
        this.writer.write((byte[])data);
        if(next != null){
            next.pushData(data);
        }
    }

    /* (non-Javadoc)
     * @see java.lang.AutoCloseable#close()
     */
    @Override
    public void close() throws Exception {
        // TODO Auto-generated method stub
        writer.close();
    }
    
    public FileInfo getFileInfo(){
        return this.writer.getFileInfo();
    }
   

}
