/**
　 * <p>Title: Pipeline.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年9月7日
　 * @version 1.0
*/
package com.northpool.commons.pipeline;

import java.util.concurrent.atomic.AtomicReference;

import com.northpool.commons.reflect.Bean;

/**
 * @author matt
 *
 */
public class Pipeline implements AutoCloseable {
    private Handler head;
    private Handler tail;
    volatile boolean errorOccurred = false;
    private AtomicReference<RuntimeException> _exception = new AtomicReference<>(null);
    public Pipeline(){
        HeadHandler headHandler = new HeadHandler();
        this.head = headHandler;
        this.tail = headHandler;
    }
    
    public RuntimeException getException(){
        return _exception.get();
    }
    
    public Pipeline pip(Handler handler){
        if(!Bean.isExtends(handler.getClass(), AbstractHandler.class)){
            throw new RuntimeException("handler必须继承AbstractHandler");
        }
        AbstractHandler abstractHandler = (AbstractHandler)handler;
        abstractHandler.setExecutePipeline(this);
        this.tail.setNext(handler);
        this.tail = handler;
        return this;
    }
    
    public void exceptionOccurr(RuntimeException e){
        this.errorOccurred = true;
        this._exception.compareAndSet(null,e);
    }
    
    
    public boolean isErrorOccurred(){
        return this.errorOccurred;
    }
    
    
    public void end() throws Exception{
        this.head.end();
    }
    
    public <T> void push(T data) throws Exception{
        this.head.pushData(data); 
    }  
    
   
    final class HeadHandler extends AbstractHandler implements Handler{

        @Override
        public <T> void pushData(T data) throws Exception {
            // TODO Auto-generated method stub
            if(this.next != null){
                this.next.pushData(data);
            }
        }


        @Override
        public void end() throws Exception {
            // TODO Auto-generated method stub
            if(this.next != null){
                this.next.end();
            }
        }


        @Override
        public void close() throws Exception {
            // TODO Auto-generated method stub
            
        }


       
    }


  
    @Override
    public void close() throws Exception {
        // TODO Auto-generated method stub
        Handler handler = this.head;
        while(true){
            handler.close();
            if(handler.next() == null){
                break;
            }else{
                handler = handler.next();
            }
        }
    }  
    
    
    
    
}
