package com.northpool.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import com.northpool.commons.util.StringUtility;
import com.northpool.exception.CommonException;
import com.northpool.type.Types;

/**
 * 有关于BEAN的静态方法
 * 
 * @author matt
 *
 */
public class Bean {

	/**
	 * 获得beanholder
	 * 
	 * @param clazz
	 * @return
	 */
	public static <T> BeanHolder<T> getBeanHolder(Class<T> clazz) {

		BeanHolderManager manager = Reflect.getBeanHolderManager();

		BeanHolder<T> holder = manager.getBeanHolder(clazz);
		if (holder == null) {
			synchronized (Bean.class) {
				if (holder == null) {
					holder = manager.createBeanHolder(clazz);
					manager.registerBeanHolder(clazz, holder, false);
				}
			}
		}

		return holder;

	}

	public static <T> T newInstance(Class<T> clazz) {

		return Bean.getBeanHolder(clazz).getNewInstance();
	}

	/**
	 * 将一个BEAN转换成map
	 * 
	 * @param obj
	 * @return
	 */
	public static <T> Map<String, Object> getObjectValue(T obj) {
		if (obj instanceof Map) {
			try {
				Map<String, Object> values = (Map<String, Object>) obj;
				return values;
			} catch (Exception e) {
				throw new RuntimeException("map类型只能是Map<String,Object>类型");
			}
		}
		HashMap<String, Object> m = new HashMap<String, Object>();
		BeanHolder<?> holder = Bean.getBeanHolder(obj.getClass());
		Iterator<Entry<String, FieldHolder>> iterator = holder.getFieldMap().entrySet().iterator();
		while (iterator.hasNext()) {

			Entry<String, FieldHolder> e = iterator.next();
			String name = e.getKey();
			Object value = e.getValue().getReaderInvoker().invoke(obj, null);
			m.put(name, value);
		}

		return m;

	}

	/**
	 * 获得字段的类型
	 * 
	 * @param obj
	 * @param fieldName
	 * @return
	 */
	public static <T> Class<?> getObjectTypeByFieldName(T obj, String fieldName) {
		BeanHolder<?> holder = Bean.getBeanHolder(obj.getClass());
		FieldHolder fieldHolder = (FieldHolder) holder.getFieldMap().get(fieldName);
		if (fieldHolder == null) {
			return null;
		}

		return fieldHolder.getFieldType();

	}

	/**
	 * 获得对象制定的字段值
	 * 
	 * @param obj
	 *            对象
	 * @param FieldName
	 *            字段
	 * @return
	 * 
	 */
	public static <T> Object getObjectValueByFieldName(T obj, String fieldName) {
		if (obj instanceof Map) {
			Map<?, ?> m = (Map<?, ?>) obj;
			return m.get(fieldName);
		}
		BeanHolder<?> holder = Bean.getBeanHolder(obj.getClass());
		FieldHolder fieldHolder = (FieldHolder) holder.getFieldMap().get(fieldName);
		if (fieldHolder == null) {
			fieldHolder = holder.getPrivateFieldMap().get(fieldName);
		}
		if(fieldHolder == null){
			return null;
		}
		if(fieldHolder.getReaderInvoker() == null){
			return null;
		}
		return fieldHolder.getReaderInvoker().invoke(obj, null);

	}

	/**
	 * map中取值设置到object中
	 * 
	 * @param <T>
	 * @param obj
	 * @param m
	 * @param checkToObjField
	 *            (作废参数)
	 */

	@Deprecated
	public static <T> void setObjectValueByFieldName(T obj, Map<String, Object> m, Boolean checkToObjField) {

		Bean.setObjectValueByFieldName(obj, m);

	}

	/**
	 * map中取值设置到object中
	 * 
	 * @param <T>
	 * @param obj
	 * @param m
	 *            3字段1000000次注入435
	 */

	public static <T> void setObjectValueByFieldName(T obj, Map<String, ?> m) {

		Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getFieldMap();

		m.forEach((key, value) -> {
			String fieldName = key;
			FieldHolder fieldHolder = filedMap.get(fieldName);
			if (fieldHolder == null) {
				return;
			}
			fieldHolder.getWriteInvoker().invoke(obj, new Object[] { value });
		});

		/*
		 * for(Entry<String,?> entry: entrySet){ String fieldName =
		 * entry.getKey(); FieldHolder fieldHolder = filedMap.get(fieldName);
		 * if(fieldHolder == null){ continue;
		 * 
		 * }
		 * 
		 * 
		 * fieldHolder.getWriteInvoker().invoke(obj, new
		 * Object[]{entry.getValue()});
		 * 
		 * }
		 */

	}

	public static <T> void setSingleObjectValueByPrivateFieldName(T obj, String fieldName, Object value)
			throws Exception {
		Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getPrivateFieldMap();
		FieldHolder fieldHolder = filedMap.get(fieldName);
		if (fieldHolder == null) {
			throw new ReflectFindException("没有找到" + fieldName);
		}

		if (value == null) {
			fieldHolder.getWriteInvoker().invoke(obj, new Object[] { null });
			return;
		}

		Class<?> clazz = fieldHolder.getFieldType();
		Class<?> clazz1 = value.getClass();
		if (clazz.getName().equals(clazz1.getName())) {
			fieldHolder.getWriteInvoker().invoke(obj, new Object[] { value });
		} else {
			Object newValue = Types.convert(value, clazz);
			fieldHolder.getWriteInvoker().invoke(obj, new Object[] { newValue });
		}
	}

	/**
	 * 单个字段注入
	 * 
	 * @param <T>
	 * @param obj
	 * @param fieldName
	 * @param value
	 * @throws Exception
	 */
	public static <T> void setSingleObjectValueByFieldName(T obj, String fieldName, Object value) throws Exception {
		Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getFieldMap();
		FieldHolder fieldHolder = filedMap.get(fieldName);
		if (fieldHolder == null) {
			throw new ReflectFindException("没有找到" + fieldName);
		}

		if (value == null) {
			fieldHolder.getWriteInvoker().invoke(obj, new Object[] { null });
			return;
		}

		Class<?> clazz = fieldHolder.getFieldType();

		Class<?> clazz1 = value.getClass();
		if (clazz.getName().equals(clazz1.getName())) {
			fieldHolder.getWriteInvoker().invoke(obj, new Object[] { value });
		} else {
			Object newValue = Types.convert(value, clazz);
			fieldHolder.getWriteInvoker().invoke(obj, new Object[] { newValue });
		}

	}

	/**
	 * map中取值设置到object中
	 * 
	 * @param <T>
	 * @param obj
	 * @param m
	 * @param includeNull
	 *            NULL的值是否要赋值 3字段1字段转换1000000次注入623
	 * @throws Exception
	 */
	public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m, Boolean includeNull)
			throws Exception {
		Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getFieldMap();
		Set<Entry<String, Object>> entrySet = m.entrySet();
		for (Entry<String, Object> entry : entrySet) {

			String fieldName = entry.getKey();
			Object value = entry.getValue();

			FieldHolder fieldHolder = filedMap.get(fieldName);
			if (fieldHolder == null) {
				continue;

			}
			// 虚字段
			if (fieldHolder.getWriteInvoker() == null) {
				continue;
			}
			// 不包括空
			if (value == null && includeNull == false) {
				continue;
			}

			if (value == null) {
				fieldHolder.getWriteInvoker().invoke(obj, new Object[] { null });
				continue;
			}
			Class<?> clazz = fieldHolder.getFieldType();

			if (clazz == null) {
				continue;
			}

			Class<?> clazz1 = value.getClass();

			if (clazz.getName().equals(clazz1.getName())) {
				fieldHolder.getWriteInvoker().invoke(obj, new Object[] { entry.getValue() });
			} else {
				Object newValue = Types.convert(value, clazz);
				fieldHolder.getWriteInvoker().invoke(obj, new Object[] { newValue });
			}

		}
	}

	/**
	 * map中取值设置到object中
	 * 
	 * @param <T>
	 * @param obj
	 * @param m
	 *            3字段1字段转换1000000次注入623
	 * @throws Exception
	 */
	public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m) throws Exception {

		Bean.setObjectValueByFieldNameWithTypeChange(obj, m, true);

	}

	/**
	 * map中取值设置到object中
	 * 
	 * @param obj
	 *            被复制对象
	 * @param m
	 *            Map
	 * @param includeNull
	 *            NULL的值是否要赋值
	 * @param confsStr
	 *            复制字符串 例如 String confsStr =
	 *            "ffieldId->fieldid,core.dialect.Impl.DynamicBeanDialect.staticEncode(ffieldName)->fieldName,ffieldAlisaname->fieldCnName,ffieldType->fieldType,ffieldIndex->index";
	 * @param other
	 *            其他相同的字段需不需要赋值
	 * @return
	 * @throws Exception
	 */
	public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m, Boolean includeNull,
			String confsStr, Boolean other) throws Exception {

		String[] confs = null;
		// 处理confsStr
		if (null == confsStr) {
			confs = new String[0];
		} else if ("".equalsIgnoreCase(confsStr)) {
			confs = new String[0];
		} else {
			confs = confsStr.split(",");
		}

		// Map<String,FieldHolder> filedMap =
		// Bean.getBeanHolder(obj.getClass()).getFieldMap();

		Map<String, Object> tmp = null;
		if (other) {
			tmp = m;
		} else {
			tmp = new HashMap<String, Object>();
		}
		for (int i = 0; i < confs.length; i++) {
			String conf = confs[i];
			String objField = "";
			String toObjField = "";
			Object value = null;
			try {
				String[] txs = conf.split("->");
				objField = txs[0];
				toObjField = txs[1];
			} catch (Exception e) {
				// TODO Auto-generated catch block
				throw new CommonException(confsStr + "转换标识符不符合格式");
			}
			if (StringUtility.isFunction(objField)) {
				String[] functionInfo = StringUtility.getFunctionInfo(objField);
				String functionNames = functionInfo[0];
				String[] propertys = functionInfo[1].split(",");
				if (propertys.length == 1) {
					value = m.get(propertys[0]);
					String className = functionNames.substring(0, functionNames.lastIndexOf("."));
					String functionName = functionNames.substring(functionNames.lastIndexOf(".") + 1,
							functionNames.length());
					Object[] ovalues = new Object[1];
					ovalues[0] = value;
					Class<?> clazz;
					try {
						clazz = Class.forName(className, true, Reflect.getClassLoader());

						value = Function.invokeStaticMethod(clazz, functionName, ovalues);
					} catch (CommonException e) {

						// TODO Auto-generated catch block
						e.printStackTrace();
						throw new CommonException(className + "." + functionName + "出错");

					} catch (ClassNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						throw new CommonException(className + "." + functionName + "出错");
					}
				}
			} else {
				value = m.get(objField);

			}
			tmp.put(toObjField, value);

		}

		Bean.setObjectValueByFieldNameWithTypeChange(obj, tmp, includeNull);

	}

	/**
	 * map中取值设置到object中
	 * 
	 * @param obj
	 *            被复制对象
	 * @param m
	 *            Map
	 * @param confsStr
	 *            复制字符串 例如 String confsStr =
	 *            "ffieldId->fieldid,core.dialect.Impl.DynamicBeanDialect.staticEncode(ffieldName)->fieldName,ffieldAlisaname->fieldCnName,ffieldType->fieldType,ffieldIndex->index";
	 * @param other
	 *            其他相同的字段需不需要赋值
	 * @return
	 * @throws Exception
	 */
	@Deprecated
	public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m, String confsStr,
			Boolean other) throws Exception {

		Bean.setObjectValueByFieldNameWithTypeChange(obj, m, true, confsStr, other);

	}

	public static Class<?> getClassByName(String className) throws ClassNotFoundException {
		return Class.forName(className, true, Thread.currentThread().getContextClassLoader());

	}

	/**
	 * 复制对象
	 * 
	 * @param obj
	 *            被复制对象
	 * @param toObj
	 *            复制到对象
	 * @param confsStr
	 *            复制字符串 例如 String confsStr =
	 *            "ffieldId->fieldid,core.dialect.Impl.DynamicBeanDialect.staticEncode(ffieldName)->fieldName,ffieldAlisaname->fieldCnName,ffieldType->fieldType,ffieldIndex->index";
	 * @param other
	 *            其他相同的字段需不需要赋值
	 * @param includeNull
	 *            NULL的值是否要赋值
	 * @return
	 * @throws Exception
	 */
	public static <T> Object copyObjectToObject(T obj, T toObj, Boolean includeNull, String confsStr, Boolean other)
			throws Exception {
		Map<String, Object> m = Bean.getObjectValue(obj);
		Bean.setObjectValueByFieldNameWithTypeChange(toObj, m, includeNull, confsStr, other);
		return toObj;

	}

	/**
	 * 复制对象
	 * 
	 * @param obj
	 *            被复制对象
	 * @param toObj
	 *            复制到对象
	 * @param includeNull
	 *            NULL的值是否要赋值
	 * @return
	 * @throws Exception
	 */
	public static <T> Object copyObjectToObject(T obj, T toObj, Boolean includeNull) throws Exception {

		Bean.copyObjectToObject(obj, toObj, includeNull, null, true);
		return toObj;

	}

	/**
	 * 复制对象
	 * 
	 * @param obj
	 *            被复制对象
	 * @param toObj
	 *            复制到对象
	 * @param confsStr
	 *            复制字符串 例如 String confsStr =
	 *            "ffieldId->fieldid,core.dialect.Impl.DynamicBeanDialect.staticEncode(ffieldName)->fieldName,ffieldAlisaname->fieldCnName,ffieldType->fieldType,ffieldIndex->index";
	 * @param other
	 *            其他相同的字段需不需要赋值
	 * @return
	 * @throws Exception
	 */
	@Deprecated
	public static <T> Object copyObjectToObject(T obj, T toObj, String confsStr, Boolean other) throws Exception {
		Bean.copyObjectToObject(obj, toObj, true, confsStr, other);
		return toObj;

	}

	/**
	 * 判断是否是指类继承
	 * @param clazz
	 * @param criterionClazz
	 * @return
	 */
	public static Boolean isExtends(Class<?> clazz, Class<?> criterionClazz) {
		if (clazz.getSuperclass() == null) {
			return false;
		}
		if (clazz.getSuperclass().equals(criterionClazz)) {
			return true;
		} else {
			return isExtends(clazz.getSuperclass(), criterionClazz);
		}
	}

	/**
	 * 判断是否是指定接口的实现
	 * 
	 * @param clazz
	 *            判断类
	 * @param criterionClazz
	 *            接口类
	 * @return
	 */
	public static Boolean isInstance(Class<?> clazz, Class<?> criterionClazz) {
		Class<?>[] clazzes = clazz.getInterfaces();
		if (clazzes == null || clazzes.length == 0) {
			return false;
		}
		boolean is = false;
		for (int i = 0; i < clazzes.length; i++) {
			if (clazzes[i].equals(criterionClazz)) {
				is = true;
				if (is == true) {
					return is;
				}
			}
		}
		for (Class<?> clazzInterface : clazzes) {
			is = isInstance(clazzInterface, criterionClazz);
			if (is == true) {
				return is;
			}
		}
		return is;
	}

	public static String arrayToString(Object[] array) {
		StringBuilder sb = new StringBuilder();
		sb.append("array:").append(" values [");
		for (int i = 0; i < array.length; i++) {
			sb.append(Types.valueToString(array[i]));
			if (i < array.length - 1) {
				sb.append(",");
			}
		}
		sb.append("]");
		return sb.toString();
	}

	/**
	 * 是否有字段
	 * 
	 * @param clazz
	 * @param fieldName
	 * @return
	 */
	public static <T> Boolean hasField(Class<T> clazz, String fieldName) {
		Map<String, FieldHolder> filedMap = Bean.getBeanHolder(clazz).getPrivateFieldMap();
		FieldHolder fieldHolder = filedMap.get(fieldName);
		if (fieldHolder == null) {
			return false;
		}
		if (fieldHolder.getWriteInvoker() == null || fieldHolder.getReaderInvoker() == null) {
			return false;
		} else {
			return true;
		}
	}

	public static <T> String toString(T t) {
		if (t.getClass().isArray()) {
			return arrayToString((Object[]) t);
		}

		Map<String, Object> m = Bean.getObjectValue(t);
		StringBuilder sb = new StringBuilder();
		sb.append("class: ").append(t.getClass().getName()).append(" values [ ");

		Iterator<Entry<String, Object>> iterator = m.entrySet().iterator();
		while (iterator.hasNext()) {
			Entry<String, Object> e = iterator.next();
			String value;

			if (e.getValue() == null) {
				value = "null";
			} else {
				try {
					// Converter converter =
					// ConverterType.getConverter(e.getValue().getClass());
					value = Types.valueToString(e.getValue());
				} catch (Exception exception) {

					value = e.getValue().toString();
				}
			}
			sb.append(e.getKey()).append(" = ").append(value).append(",");
		}
		sb.deleteCharAt(sb.length() - 1);
		sb.append(" ]");
		return sb.toString();
	}

	public static boolean isAbstract(Class<?> clazz) {
		return Modifier.isAbstract(clazz.getModifiers());
	}

	static <T extends Annotation> void _getDeclaredMethods(Class<?> clz, List<Method> methodArray,
			Class<T> annotationClazz) {
		Method[] methods;

		methods = clz.getDeclaredMethods();
		for (Method method : methods) {
			if (annotationClazz == null) {
				methodArray.add(method);
			} else {
				if (method.getAnnotation(annotationClazz) != null) {
					methodArray.add(method);
				}
			}
		}
		if (clz.getSuperclass() != null) {
			_getDeclaredMethods(clz.getSuperclass(), methodArray, annotationClazz);
		} else {
			return;
		}

	}

	static <T extends Annotation> void _getClassDeclaredMethods(Class<?> clz, List<Method> methodArray,
			Class<T> annotationClazz) {
		Method[] methods;

		methods = clz.getDeclaredMethods();
		for (Method method : methods) {
			if (annotationClazz == null) {
				methodArray.add(method);
			} else {
				if (method.getAnnotation(annotationClazz) != null) {
					methodArray.add(method);
				}
			}
		}
		// clz.isInterface()
		if (clz.getSuperclass() != null) {
			_getClassDeclaredMethods(clz.getSuperclass(), methodArray, annotationClazz);
		} else {
			return;
		}

	}

	static <T extends Annotation> void _getInterfaceDeclaredMethods(Class<?>[] clzArray, List<Method> methodArray,
			Class<T> annotationClazz) {

		for (Class<?> clz : clzArray) {
			Method[] methods;
			methods = clz.getDeclaredMethods();
			for (Method method : methods) {
				if (annotationClazz == null) {
					methodArray.add(method);
				} else {
					if (method.getAnnotation(annotationClazz) != null) {
						methodArray.add(method);
					}
				}
			}
			if (clz.getInterfaces() != null) {
				_getInterfaceDeclaredMethods(clz.getInterfaces(), methodArray, annotationClazz);
			} else {
				return;
			}
		}

	}

	public static <T extends Annotation> Method[] getDeclaredMethods(Class<?> clz, Class<T> annotationClazz) {
		List<Method> methodArray = new ArrayList<>();
		if (clz.isInterface()) {
			_getInterfaceDeclaredMethods(new Class[] { clz }, methodArray, annotationClazz);
		} else {
			_getClassDeclaredMethods(clz, methodArray, annotationClazz);
		}
		return methodArray.toArray(new Method[methodArray.size()]);
	}

}
