package com.northpool.commons.reflect;

import java.util.List;
import java.util.Map;

/**
 * 储存Bean信息
 * @author matt
 *
 */
public interface BeanHolder<T> {

	/**
	 * 获得该bean的实例
	 * @matt
	 */
	public  T getNewInstance();
	
	/**
	 * 根据传入的fieldNames获得FieldHolder,如果传入为null则获得全部
	 * @return
	 */
	public Map<String,FieldHolder> getFieldMap();	
	/**
	 * 初始化BeanHolder根据传入的CLASS
	 * @param clazz
	 */
	//public void loadBeanHolder(Class<T> clazz);
	
	/**
	 * 获得FieldHolder根据字段名称
	 * @param fieldName
	 * @return
	 */
	public FieldHolder getFieldHolder(String fieldName);
	
	
	//public List<Class<?>> getInterfaceList();
	
	
	public Map<String,FieldHolder> getPrivateFieldMap();
	
	
	 
}
