package com.northpool.commons.reflect;


/**
 * 储存bean信息
 * @author matt
 *
 */
public interface BeanHolderManager {
	
	/**
	 * 获得BeanHolder
	 * @param clazz
	 * @return
	 */
	public  <T> BeanHolder<T>  getBeanHolder(Class<T> clazz);
	
	
	/**
	 * 注册一个BeanHolder
	 * @param clazz
	 * @param beanHolder
	 * @param over true覆盖，false不覆盖
	 */
	public  <T> void registerBeanHolder(Class<T> clazz,BeanHolder<T> beanHolder,Boolean over);
	
	
	/**
	 * 创建一个beanHolder
	 */
	public  <T> BeanHolder<T> createBeanHolder(Class<T> clazz);
	
}
