package com.northpool.commons.reflect;

import java.lang.annotation.Annotation;
import java.util.Map;



/**
 * 保存字段信息
 * @author Matt
 *
 */
public interface FieldHolder {
	
	
	public static enum FIELD_TYPE {
		FIELD_TYPE_NATURE,FIELD_TYPE_ABSTRACT,FIELD_TYPE_SELF,FIELD_TYPE_PARENT
	}
	
	/**
	 * 实字段
	 */
	public static final int FIELD_TYPE_NATURE  = 0;

	/**
	 * 虚字段
	 */
	public static final int FIELD_TYPE_ABSTRACT = 1;
	
	/**
	 * 本类中的
	 */
	public static final int FIELD_TYPE_SELF  = 0;
	
	
	/**
	 * 基类的
	 */
	public static final int FIELD_TYPE_PARENT  = 1;
	
	
	/**
	 * 获得读取Invoker
	 * @return
	 */
	public Invoker getReaderInvoker();
	
	/**
	 * 获得写入Invoker
	 * @return
	 */
	public Invoker getWriteInvoker();
	
	/**
	 * 获得字段的名称
	 * @return
	 */
	public String getFieldName();
	
	
	/**
	 * 获得它的beanHolder
	 * @return
	 */
	public BeanHolder<?>  getBeanHolder();
	
	/**
	 * 获得全部注释
	 * @param clazz
	 * @return
	 */
	public <T extends Annotation> Map<Class<T>, Annotation> getAnnotations();
	
	/**
	 * 获得注释
	 * @param clazz
	 * @return
	 */
	public <T extends Annotation> T getAnnotation(Class<T> clazz);
	
	
	/**
	 * 获得Field的类型
	 * @return
	 */
	public Class<?> getFieldType();
	
	/**
	 * 是否虚字段
	 * @return
	 */
	public Boolean isAbstract();
	
	/**
	 * 写入
	 * @param o
	 * @param value
	 * @throws Exception
	 */
	public void setValue(Object o,Object value) throws Exception ;
	
	/**
	 * 读取
	 * @param o
	 * @throws Exception
	 */
	public Object getValue(Object o) throws Exception ;
	
	
}
