package com.northpool.commons.reflect;

import java.lang.reflect.InvocationTargetException;

import com.northpool.exception.CommonException;

/**
 * 有关于方法反射
 * @author matt
 *
 */
public class Function {
	
    
    
  
    
    
    @Deprecated
    /**
     * 被Reflect替代
     * @param classLoader
     */
    public static void setClassLoader(ClassLoader classloader){
        Reflect.setClassLoader(classloader);
    }
    
    
	/**
	 * 执行静态方法，指定接口类型
	 * @param clazz
	 * @param methodName
	 * @param clazzs
	 * @param args
	 * @return
	 * @throws ReflectFindException
	 */
	public static Object invokeStaticMethod(Class<?> clazz, String methodName,Class<?>[] clazzs,Object[] args) throws ReflectException {

		FunctionHolder functionHolder = Function.getFunctionHolder(clazz, methodName, clazzs);
		
		try {
			return functionHolder.getInvoker().invoke(clazz, args);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			if(e instanceof InvocationTargetException){
				InvocationTargetException ie = (InvocationTargetException)e;
				throw new ReflectException(ie.getTargetException().getMessage());
			}else{
				throw new ReflectException(e.getMessage());
			}
		}
		
		
	}
	
	
	/**
	 * 执行静态方法(参数必须都是接口)
	 * @Title: invokeStaticMethod
	 * @author: 张兆阳
	 * @date: Feb 5, 2013
	 * @param className
	 * @param methodName
	 * @param args
	 * @return
	 * @throws CommonException   设定参数 
	 * @return Object    返回类型
	 * @Description: TODO 
	 */ 
	public static Object invokeStaticMethod(Class<?> clazz, String methodName,Object[] args) throws ReflectException {
		
		Class<?>[] clazzs = null;
    	if(args != null){
			clazzs = new Class[args.length];
			for(int i = 0 ; i < args.length ; i++){
				if(args[i] != null){
					clazzs[i] = args[i].getClass();
				}
			}
		
    	}
		
		//clazz.getMethod(name, parameterTypes)
		
		FunctionHolder functionHolder = Function.getFunctionHolder(clazz, methodName, clazzs);
		
		try {
			return functionHolder.getInvoker().invoke(clazz, args);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			if(e instanceof InvocationTargetException){
				InvocationTargetException ie = (InvocationTargetException)e;
				throw new ReflectException(ie.getTargetException().getMessage());
			}else{
				throw new ReflectException(e.getMessage());
			}
		}
		
		
	}

	
	/**
	 * 执行方法
	 * @param clazz
	 * @param o
	 * @param methodName
	 * @param args
	 * @return
	 * @throws ReflectFindException
	 */
    public static Object invokeMethod(Class<?> clazz,Object o, String methodName,Class<?>[] clazzs,Object[] args) throws ReflectException {
		
		
		FunctionHolder functionHolder = Function.getFunctionHolder(clazz, methodName, clazzs);
		
		try {
			return functionHolder.getInvoker().invoke(o, args);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			
			if(e instanceof InvocationTargetException){
				InvocationTargetException ie = (InvocationTargetException)e;
				
				throw new ReflectException(ie);
				
			}else{
				throw new ReflectException(e.getMessage());
			}
		}
		
		
	}
    
    
    
    /**
	 * 执行方法（参数必须是接口）
	 * @param clazz
	 * @param o
	 * @param methodName
	 * @param args
	 * @return
     * @throws CommonException 
	 */
    public static Object invokeMethod(Class<?> clazz,Object o, String methodName,Object[] args) throws ReflectException {
		
    	Class<?>[] clazzs = null;
    	if(args != null){
			clazzs = new Class[args.length];
			for(int i = 0 ; i < args.length ; i++){
				clazzs[i] = args[i].getClass();
			}
		
    	}
		//clazz.getMethod(name, parameterTypes)
		
		FunctionHolder functionHolder = Function.getFunctionHolder(clazz, methodName, clazzs);
		
		try {
			return functionHolder.getInvoker().invoke(o, args);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			if(e instanceof InvocationTargetException){
				InvocationTargetException ie = (InvocationTargetException)e;
				throw new ReflectException(ie.getTargetException().getMessage());
			}else{
				throw new ReflectException(e.getMessage());
			}
		}
		
		
	}
	
    
    /**
   	 * 执行方法（参数必须是接口）
   	 * @param clazz
   	 * @param o
   	 * @param methodName
   	 * @param args
   	 * @return
     * @throws CommonException 
   	 */
     public static Object invokeMethod(Object o, String methodName,Object[] args) throws ReflectException {
   		
	       	Class<?>[] clazzs = null;
	       	if(args != null){
	   			clazzs = new Class[args.length];
	   			for(int i = 0 ; i < args.length ; i++){
	   				clazzs[i] = args[i].getClass();
	   			}
	   		
	       	}
	   		//clazz.getMethod(name, parameterTypes)
	   		
	   		FunctionHolder functionHolder = Function.getFunctionHolder(o.getClass(), methodName, clazzs);
	   		
	   		try {
				return functionHolder.getInvoker().invoke(o, args);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				// TODO Auto-generated catch block
				if(e instanceof InvocationTargetException){
					InvocationTargetException ie = (InvocationTargetException)e;
					throw new ReflectException(ie.getTargetException().getMessage());
				}else{
					throw new ReflectException(e.getMessage());
				}
			}
   		
   		
   	}
   	
	
	
	
	/**
	 *获得函数的holder
	 * @param clazz
	 * @param methodName
	 * @param args
	 * @return
	 */
	private static FunctionHolder getFunctionHolder(Class<?> clazz,String methodName,Class<?>[] args){
		
		FunctionHolderManager functionHolderManager = Reflect.getFunctionHolderManager();
		FunctionHolder functionHolder = functionHolderManager.getFunctionHolder(clazz, methodName, args);
		
		if(functionHolder == null){
			synchronized(Function.class){
				if(functionHolder == null){
					functionHolder = functionHolderManager.createFunctionHolder(clazz, methodName, args);
					functionHolderManager.registerFunctionHolder(clazz, methodName, args, functionHolder, false);
				}
			}
		}
		return functionHolder;
	}
	
}
