package com.northpool.commons.reflect.beanHolder.FieldHoder;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import com.northpool.commons.reflect.BeanHolder;
import com.northpool.commons.reflect.FieldHolder;
import com.northpool.commons.reflect.Invoker;
import com.northpool.commons.reflect.Reflect;

public abstract class AbstractFieldHolderImpl<T> implements FieldHolder {
	
	
	protected BeanHolder<T> beanHolder;
	
	protected Map<Class<?>, Annotation> annotationMap = new HashMap<Class<?>, Annotation>();
	
	protected String fieldName;
	
	protected Invoker readerInvoker;
	
	protected Invoker writeInvoker;
	
	protected Field field;
	
	
	protected Class<?> fieldType;
	
	/**
	 * 表示这个是实体字段还是虚字段
	 */
	protected int natureType;
	
	/**
	 * 所属属性，表示是该字段是本类的还是基类的
	 */
	protected int classType;
	
	
	public AbstractFieldHolderImpl(Field field,Class<T> clazz,BeanHolder<T> beanHolder){
	    this.fieldName = field.getName();
	    this.classType = FieldHolder.FIELD_TYPE_SELF;
	    this.natureType = FieldHolder.FIELD_TYPE_NATURE;
	    this.field = field;
	    this.field.setAccessible(true);
        
        this.fieldType = field.getType();
        
        Annotation[] annotations = this.field.getAnnotations();
        
        for(Annotation annotation:annotations){
            annotationMap.put(annotation.annotationType(), annotation);
        }
        
        this.readerInvoker = new Invoker(){

            @Override
            public Method method() {
                // TODO Auto-generated method stub
                return null;
            }

            @Override
            public Object invoke(Object host, Object[] args) {
                // TODO Auto-generated method stub
                try {
                    return field.get(host);
                } catch (IllegalArgumentException | IllegalAccessException e) {
                    // TODO Auto-generated catch block
                    throw new RuntimeException(e);
                }
            }
            
        };
        
        this.writeInvoker = new Invoker(){

            @Override
            public Method method() {
                // TODO Auto-generated method stub
                return null;
            }

            @Override
            public Object invoke(Object host, Object[] args) {
                // TODO Auto-generated method stub
                try{
                    field.set(host, args[0]);
                }catch(Exception e){
                    throw new RuntimeException(e);
                }
                return null;
            }
            
        };
        
	}
	
	
	
	public AbstractFieldHolderImpl(PropertyDescriptor p,Class<T> clazz,BeanHolder<T> beanHolder){
		this.fieldName = p.getName();
		Field f = this.getFieldByName(clazz,false);
		if(f == null){
			//字段属于parent;
			this.classType = FieldHolder.FIELD_TYPE_PARENT;
			//去父类找
			f = this.getFieldByName(clazz.getSuperclass(),true);
			
		}else{
			this.classType = FieldHolder.FIELD_TYPE_SELF;
		}
		
		if(f == null){
			this.natureType = FieldHolder.FIELD_TYPE_ABSTRACT;
		}else{
			this.natureType = FieldHolder.FIELD_TYPE_NATURE;
		}
		if(this.natureType == FieldHolder.FIELD_TYPE_NATURE){
			//如果是实体字段，则需要加载field与注释
			this.field = f;
			
			this.fieldType = f.getType();
			
			Annotation[] annotations = this.field.getAnnotations();
			
			for(Annotation annotation:annotations){
				annotationMap.put(annotation.annotationType(), annotation);
			}
			
			
			//加载读Invoker
			Method readMethod = p.getReadMethod();
			
			if(readMethod != null){
				readMethod.setAccessible(true);
				this.readerInvoker = (Invoker) Reflect.getInvokerManager().newInvoker(readMethod);
			}
			//加载写Invoker
			Method writeMethod = p.getWriteMethod();
			
			if(writeMethod != null){
				
				writeMethod.setAccessible(true);
				this.writeInvoker = (Invoker) Reflect.getInvokerManager().newInvoker(writeMethod);
			}
			
			
		}else{
			//加载读Invoker
			Method readMethod = p.getReadMethod();
			if(readMethod != null){
				readMethod.setAccessible(true);
				this.readerInvoker = (Invoker) Reflect.getInvokerManager().newInvoker(readMethod);
			}
			
			
			//加载写Invoker
			Method writeMethod = p.getWriteMethod();
			
			if(writeMethod != null){
				writeMethod.setAccessible(true);
				this.writeInvoker = (Invoker) Reflect.getInvokerManager().newInvoker(writeMethod);
			}
		}
		
	}
	
	
	
	
	
	
		protected Field getFieldByName(Class<?> clazz,Boolean findParent){
		Field f = null;
		if(clazz == null){
			return null;
		}
		try{
			f = clazz.getDeclaredField(this.fieldName);
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		} catch (NoSuchFieldException e) {
			if(findParent){
				f = this.getFieldByName(clazz.getSuperclass(),findParent);
			}
			
		}
		return f;
		
	}
	
	
	
	@Override
	public Map<Class<?>, Annotation> getAnnotations() {
		return this.annotationMap;
	}
	

	
	@Override
	public BeanHolder<?> getBeanHolder() {
		// TODO Auto-generated method stub
		return beanHolder;
	}
	@Override
	public String getFieldName() {
		// TODO Auto-generated method stub
		return fieldName;
	}
	@Override
	public Invoker getReaderInvoker() {
		// TODO Auto-generated method stub
		return readerInvoker;
	}
	@Override
	public Invoker getWriteInvoker() {
		// TODO Auto-generated method stub
		return writeInvoker;
	}
	
	@Override
	@SuppressWarnings({ "unchecked", "hiding" })
	public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
		// TODO Auto-generated method stub
		return (T) this.annotationMap.get(annotationClass);
	}
	
	@Override
	public Class<?> getFieldType(){
		return this.fieldType;
	}
	@Override
	public Boolean isAbstract(){
		if(this.natureType == FieldHolder.FIELD_TYPE_NATURE){
			return false;
		}else{
			return true;
		}
		
	}
	
	
    @Override
    public void setValue(Object o,Object value) throws Exception {
        // TODO Auto-generated method stub
        Invoker invoker = this.getWriteInvoker();
        if(invoker == null){
            throw new Exception("字段" + this.fieldName + "不支持写入方法");
        }
        invoker.invoke(o, new Object[]{value});
    }

    
    @Override
    public Object getValue(Object o) throws Exception {
        // TODO Auto-generated method stub
        Invoker invoker = this.getReaderInvoker();
        if(invoker == null){
            throw new Exception("字段" + this.fieldName + "不支持读取方法");
        }
        return invoker.invoke(o, null);

    } 
	

}
