package com.northpool.commons.util;

import sun.nio.ch.DirectBuffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public abstract class AbstractDoubleBuilder extends AbstractBuilder implements DoubleBuilder {

	protected final int beginSize = 8 * 256;
	
	//private final int beginSize = 8 * 4;
	
	protected int expansionHeapTimes = 1;


	private final int directApplySize = 1024 * 1024;
	
	protected double[] heap;
	
	protected int capacity;
	
	protected int size;

	private Boolean isDirect = false;
	
	protected final int typeSize = 8;
	
	protected final int directApplySizeNum =  directApplySize / this.typeSize;
	
	protected ArrayList<ByteBuffer> directBufferArr;
	
	
	protected ByteBuffer currentDirectByteBuffer = null;

	
	//int s = 0;
	
	//protected DoubleBuffer heapDoubleBuffer = null;

	//final int maxInHeap = 1024;
	//final int maxInHeap = 128;

	abstract public ByteOrder order();

	public AbstractDoubleBuilder() {
		this.capacity = this.beginSize / this.typeSize;
		this.heap = new double[this.capacity];
		//this.capacity = 
	}

		public AbstractDoubleBuilder(double[] arr) {
		this();
		//this.ensureCapacityInternal(arr.length);
		this.append(arr);
	}
	
	public AbstractDoubleBuilder(int size){
		this.capacity = size;
		if(directApplySizeNum > size){
			this.heap = new double[size];
		}else{
			this.isDirect = true;
			ByteBuffer newBuffer = ByteBuffer.allocateDirect(size * typeSize);
			this.directBufferArr = new ArrayList<>(1);
			this.directBufferArr.add(newBuffer);
			this.currentDirectByteBuffer = newBuffer;
		}
	}

	private void clean(final ByteBuffer byteBuffer) {
		if (byteBuffer.isDirect()) {
			DirectBuffer db = (DirectBuffer) byteBuffer;
			db.cleaner().clean();
		}
	}
	@Override
	public Boolean isDirect() {
		return this.isDirect;
	}

	@Override
	public int size() {	
		return this.size;
	}

	private void expansionInHeap(int arrSize) {
		
		int applySize = this.beginSize * expansionHeapTimes / this.typeSize ;
		expansionHeapTimes ++;
		int newSize = (applySize > arrSize) ? this.capacity + applySize : arrSize + arrSize % applySize + this.capacity;
		double[] newHeap = new double[newSize];
		System.arraycopy(this.heap, 0,
				newHeap, 0, this.size);
		this.heap = newHeap;
		this.capacity = newSize;

	}

	private void expansionInDirect(int size) {
		
		//int newSize = (this.directApplySize > size) ? this.capacity * this.typeSize + this.directApplySize : size + size % this.directApplySize + this.capacity;
		if(size > this.directApplySizeNum){
			int times = (int)size/(this.directApplySizeNum) + 1;
			int newCapacity = this.directApplySizeNum * times;
			while(times --> 0){
				ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
				this.directBufferArr.add(newBuffer);
			}
			this.capacity = newCapacity;
		}else{
			ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
			this.directBufferArr.add(newBuffer);
			this.currentDirectByteBuffer = newBuffer;
			this.capacity = this.capacity + this.directApplySizeNum;
		}

	}
	
	protected ByteBuffer getByteBuffer(int index){
		index = (int)(index / this.directApplySize);
		return this.directBufferArr.get(index);
		
	}

	private void toDirect(int size) {
		//int newSize = 0;
		
		//int applySize = this.beginSize * expansionHeapTimes / this.typeSize ;
		this.isDirect = true;
		ByteBuffer newBuffer;
		int newSize = this.directApplySize;
		this.directBufferArr = new ArrayList<ByteBuffer>();
		
		if((size + this.capacity) * this.typeSize > this.directApplySize){
			int times = (int)((size + this.capacity) * this.typeSize)/(this.directApplySize) + 1;
			int copyDone = 0;
			int newCapacity = this.directApplySize / this.typeSize * times;
			
			while(times --> 0){
				
				ByteBuffer b = ByteBuffer.allocateDirect(this.directApplySize);
				this.directBufferArr.add(b);
				int directByteBufferSize = this.directApplySize / this.typeSize;
				if(copyDone < this.size){
					if(this.size > directByteBufferSize){
						this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, directByteBufferSize);
					}else{
						if(this.heap.length - copyDone != 0){
							this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, this.size - copyDone);
						}
						this.currentDirectByteBuffer = b;
					}
				}
				copyDone = copyDone + directByteBufferSize;
			}
			this.capacity = newCapacity;
			
			
		}else{
			this.capacity = this.directApplySize / this.typeSize;
			newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
			this.directBufferArr.add(newBuffer);
			this.currentDirectByteBuffer = newBuffer;
			this.capacity = newSize / this.typeSize;
			this.putArrIntoDirectByteBuffer(newBuffer, this.heap, 0, this.size);
			
		}

	
		

	}

	abstract protected void putArrIntoDirectByteBuffer(ByteBuffer buffer, Object arr, int offset, int length);
	
	@Override
	public void trimToSize() {
		if (!this.isDirect) {
			double[] newHeap = new double[this.size];
			System.arraycopy(this.heap, 0,
					newHeap, 0, size);
			this.heap = newHeap;
		} else {
			ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentDirectByteBuffer.position());
			this.currentDirectByteBuffer.flip();
			newBuffer.put(this.currentDirectByteBuffer);
			DirectBuffer db = (DirectBuffer) this.currentDirectByteBuffer;
			db.cleaner().clean();
			this.directBufferArr.set(this.directBufferArr.size() - 1, newBuffer);
			this.currentDirectByteBuffer = newBuffer;
		}
	}


	
	@Override
	public double get(int index) {
		if (this.isDirect) {
			index = index * this.typeSize;
			if (this.directBufferArr.size () == 1){
				int dataBlockIndex = 0;
				int dbbIndex = index;
				return this.directBufferArr.get(dataBlockIndex).getDouble(dbbIndex);
			}else {
				int dataBlockIndex = (int)(index / this.directApplySize);
				int dbbIndex = index % this.directApplySize;
				return this.directBufferArr.get(dataBlockIndex).getDouble(dbbIndex);
			}


		} else {
			return this.heap[index];
		}
	}
	
/*	protected Object get(ByteBuffer buffer,int index){
		return 
	}*/
	@Override
	public DoubleBuilder append(double d) {
		
		int off = 1;
		if (this.size + off > this.capacity) {
			this.ensureCapacityInternal(1);
		}
		
		if(this.isDirect){
			this.currentDirectByteBuffer.putDouble(d);
		}else{
			this.heap[this.size] = d;
		}
		this.size ++;
		
		return this;
	}
	@Override
	public void set(int index,double d){
		if(index >= this.size){
			throw new RuntimeException("out of range");
		}else{
			if(this.isDirect){
				index = index * this.typeSize;
				int dataBlockIndex = (int)(index / this.directApplySize);
				int dbbIndex = index % this.directApplySize;
				
				this.directBufferArr.get(dataBlockIndex).putDouble(dbbIndex,d);
			}else{
				this.heap[index] = d;
			}
		}
	}

	@Override
	public void destroy() {
		/*if (this.isDirect) {
			for(ByteBuffer bf:this.directBufferArr){
				this.clean(bf);
			}
		}*/
	}

	private void ensureCapacityInternal(int size) {
		if (this.isDirect == false) {
			if (((this.capacity + size) * this.typeSize + this.beginSize * this.expansionHeapTimes)  > this.directApplySize) {
				this.toDirect(size);
			} else {
				this.expansionInHeap(size);
			}
		} else {
			this.expansionInDirect(size);
		}
	}
	@Override
	public DoubleBuilder append(double[] arr) {
		this.append(arr, 0, arr.length);
		return this;
	}
	@Override
	public DoubleBuilder append(double[] arr, int offset, int length) {
		if (arr == null) {
			return this;
		}
		
		
		if (this.capacity <= length - offset + this.size) {
			this.ensureCapacityInternal(length - offset);
		}

		if (this.isDirect) {
			
			int beginBlockIndex = (int)(this.size / this.directApplySizeNum);
			int beginSubIndex = (int)(this.size % this.directApplySizeNum);
			int endBlockIndex = (int)((length - offset + this.size) / this.directApplySizeNum + 1);
			int copyDone = 0;
			for(int i = beginBlockIndex ; i < endBlockIndex ; i ++){
				int copyLength = this.directApplySizeNum;
				ByteBuffer dbb = null;
				try{
					dbb = this.directBufferArr.get(i);
				}catch(Exception e){
					e.printStackTrace();
				}
				if(i == beginBlockIndex){
					copyLength = this.directApplySizeNum - beginSubIndex;
				}
				if(i == endBlockIndex - 1){
					copyLength = length - offset - copyDone;
				}
				this.putArrIntoDirectByteBuffer(dbb, arr, copyDone, copyLength);
				copyDone = copyDone + copyLength;
			}
			
			
			
		//	this.putArrIntoDirectByteBuffer(this.directByteBuffer, arr, offset, length);

		} else {
				
		
			System.arraycopy(arr, offset,
					this.heap, this.size, length - offset);
			
		}
		this.size = this.size + length - offset;
		return this;
	}

	public DoubleBuilder delete(int start, int end) {
		throw new RuntimeException("没有实现");
		// return this;
	}

	public DoubleBuilder deleteAt(int index) {
		throw new RuntimeException("没有实现");
		// return this;
	}

	static void checkBounds(int off, int len, int size) {
		if ((off | len | (off + len) | (size - (off + len))) < 0) {
			throw new IndexOutOfBoundsException();
		}
	}
	@Override
	public String toString() {
		 StringBuffer sb = new StringBuffer();
	        sb.append(getClass().getName());
	        sb.append("[size=");
	        sb.append(this.size);
	        sb.append(" cap=");
	        sb.append(this.capacity);
	        sb.append("]");
	        return sb.toString();
	}
	
	//@Override
/*	public double[] getDoubleArray() {
		if(!this.isDirect){
			return this.heap;
		}else{
			double[] array = new double[];
			
			
		}
		
		
		
		
		return null;
	}*/
	@Override
	public double[] toArray(){
		if(this.isDirect){
			throw new RuntimeException("暂时不支持");
		}else{
			return this.heap;
		}
	}

	@Override
	public void reset(){
		this.size = 0;

		this.capacity = this.beginSize / this.typeSize;
		if(this.isDirect){
			for(ByteBuffer bf:this.directBufferArr){
				this.clean(bf);
			}
			this.directBufferArr = new ArrayList<ByteBuffer>();
			this.isDirect = false;
		}
		
	}
	
	
}
