package com.northpool.commons.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

import sun.nio.ch.DirectBuffer;

public abstract class AbstractStringBuilder implements FStringBuilder {
	
	private final int beginSize = this.charSize * 128;
	
	//private final int beginSize = 8 * 4;
	
	private int expansionHeapTimes = 1;


	private final int directApplySize = 256 * this.charSize / 2;
	
	protected char[] heap;
	
	protected int capacity;
	
	protected int size;

	private Boolean isDirect = false;
	
	protected final int charSize = 2;
	
	protected final int directApplySizeNum =  directApplySize / this.charSize;
	
	protected ArrayList<ByteBuffer> directBufferArr;
	
	
	protected ByteBuffer currentDirectByteBuffer = null;
	
	protected UnsafeFuntion unsafe = UnsafeFuntion.get();

	
	//int s = 0;
	
	//protected DoubleBuffer heapDoubleBuffer = null;

	//final int maxInHeap = 1024;
	//final int maxInHeap = 128;

	abstract public ByteOrder order();

	public AbstractStringBuilder() {
		this.capacity = this.beginSize / this.charSize;
		this.heap = new char[this.capacity];
		//this.capacity = 
	}

	public AbstractStringBuilder(String str) {
		this();
		//this.ensureCapacityInternal(arr.length);
		this.append(str);
	}

	private void clean(final ByteBuffer byteBuffer) {
		if (byteBuffer.isDirect()) {
			DirectBuffer db = (DirectBuffer) byteBuffer;
			db.cleaner().clean();
		}
	}
	@Override
	public Boolean isDirect() {
		return this.isDirect;
	}

	@Override
	public int size() {	
		return this.size;
	}

	private void expansionInHeap(int arrSize) {
		
		int applySize = this.beginSize * expansionHeapTimes / this.charSize ;
		expansionHeapTimes ++;
		int newSize = (applySize > arrSize) ? this.capacity + applySize : arrSize + arrSize % applySize + this.capacity;
		char[] newHeap = new char[newSize];
		System.arraycopy(this.heap, 0,
				newHeap, 0, this.size);
		this.heap = newHeap;
		this.capacity = newSize;
		
	}

	private void expansionInDirect(int size) {
		
		//int newSize = (this.directApplySize > size) ? this.capacity * this.doubleSize + this.directApplySize : size + size % this.directApplySize + this.capacity;
		if(size > this.directApplySizeNum){
			int times = (int)size/(this.directApplySizeNum) + 1;
			int newCapacity = this.directApplySizeNum * times;
			while(times --> 0){
				ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
				this.directBufferArr.add(newBuffer);
			}
			this.capacity = newCapacity;
		}else{
			ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
						
			this.directBufferArr.add(newBuffer);
			this.currentDirectByteBuffer = newBuffer;
			this.capacity = this.capacity + this.directApplySizeNum;
		}
	
		
	}
	
	protected ByteBuffer getByteBuffer(int index){
		index = (int)(index / this.directApplySize);
		return this.directBufferArr.get(index);
		
	}

	private void toDirect(int size) {
		//int newSize = 0;
		
		//int applySize = this.beginSize * expansionHeapTimes / this.doubleSize ;
		this.isDirect = true;
		ByteBuffer newBuffer;
		int newSize = this.directApplySize;
		this.directBufferArr = new ArrayList<ByteBuffer>();
		
		if((size + this.capacity) * this.charSize > this.directApplySize){
			int times = (int)((size + this.capacity) * this.charSize)/(this.directApplySize) + 1;
			int copyDone = 0;
			int newCapacity = this.directApplySize / this.charSize * times;
			
			while(times --> 0){
				
				ByteBuffer b = ByteBuffer.allocateDirect(this.directApplySize);
				this.directBufferArr.add(b);
				int directByteBufferSize = this.directApplySize / this.charSize;
				if(copyDone < this.size){
					if(this.size > directByteBufferSize){
						this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, directByteBufferSize);
					}else{
						if(this.heap.length - copyDone != 0){
							this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, this.size - copyDone);
						}
						this.currentDirectByteBuffer = b;
					}
				}
				copyDone = copyDone + directByteBufferSize;
			}
			this.capacity = newCapacity;
			
			
		}else{
			this.capacity = this.directApplySize / this.charSize;
			newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
			this.directBufferArr.add(newBuffer);
			this.currentDirectByteBuffer = newBuffer;
			this.capacity = newSize / this.charSize;
			this.putArrIntoDirectByteBuffer(newBuffer, this.heap, 0, this.size);
			
		}
		
	
		

	}

	abstract public void putArrIntoDirectByteBuffer(ByteBuffer buffer, Object arr, int offset, int length);
	@Override
	public void trimToSize() {
		if (!this.isDirect) {
			char[] newHeap = new char[this.size];
			System.arraycopy(this.heap, 0,
					newHeap, 0, size);
			this.heap = newHeap;
		} else {
			ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentDirectByteBuffer.position());
			this.currentDirectByteBuffer.flip();
			newBuffer.put(this.currentDirectByteBuffer);
			DirectBuffer db = (DirectBuffer) this.currentDirectByteBuffer;
			db.cleaner().clean();
			this.currentDirectByteBuffer = newBuffer;
		}
	}


	
	@Override
	public char get(int index) {
		if (this.isDirect) {
			index = index * this.charSize;
			int dataBlockIndex = (int)(index / this.directApplySize);
			int dbbIndex = index % this.directApplySize;
			return this.directBufferArr.get(dataBlockIndex).getChar(dbbIndex);
			
		} else {
			return this.heap[index];
		}
	}
	
/*	protected Object get(ByteBuffer buffer,int index){
		return 
	}*/

	@Override

	public void destroy() {
		if (this.isDirect) {
			for(ByteBuffer bf:this.directBufferArr){
				this.clean(bf);
			}
		}
	}

	private void ensureCapacityInternal(int size) {
		if (this.isDirect == false) {
			if (((this.capacity + size) * this.charSize + this.beginSize * this.expansionHeapTimes)  > this.directApplySize) {
				this.toDirect(size);
			} else {
				this.expansionInHeap(size);
			}
		} else {
			this.expansionInDirect(size);
		}
	}


	
	@Override
	public FStringBuilder append(String str) {
		if (str == null) {
			return this;
		}
		int offset = 0;
		int length = str.length();
		
		
		
		if (this.capacity < length - offset + this.size) {
			this.ensureCapacityInternal(length - offset);
		}

		if (this.isDirect) {
			
			int beginBlockIndex = (int)(this.size / this.directApplySizeNum);
			int beginSubIndex = (int)(this.size % this.directApplySizeNum);
			int endBlockIndex = (int)((length - offset + this.size) / this.directApplySizeNum + 1);
			int copyDone = 0;
			for(int i = beginBlockIndex ; i < endBlockIndex ; i ++){
				int copyLength = this.directApplySizeNum;
				ByteBuffer dbb = this.directBufferArr.get(i);
				if(i == beginBlockIndex){
					copyLength = this.directApplySizeNum - beginSubIndex;
				}
				if(i == endBlockIndex - 1){
					copyLength = length - offset - copyDone;
				}
				this.putArrIntoDirectByteBuffer(dbb, unsafe.string2char(str), copyDone, copyLength);
				copyDone = copyDone + copyLength;
			}
			
		} else {
			char[] arr = (char[])unsafe.string2char(str);	
		
			System.arraycopy(arr, offset,
					this.heap, this.size, length - offset);
			
		}
		this.size = this.size + length - offset;
		return this;
	}
	public FStringBuilder delete(int start, int end) {
		throw new RuntimeException("没有实现");
		// return this;
	}

	public FStringBuilder deleteAt(int index) {
		throw new RuntimeException("没有实现");
		// return this;
	}

	static void checkBounds(int off, int len, int size) {
		if ((off | len | (off + len) | (size - (off + len))) < 0) {
			throw new IndexOutOfBoundsException();
		}
	}
	@Override
	public String toString() {
		 StringBuffer sb = new StringBuffer();
	        sb.append(getClass().getName());
	        sb.append("[size=");
	        sb.append(this.size);
	        sb.append(" cap=");
	        sb.append(this.capacity);
	        sb.append("]");
	        return sb.toString();
	}
	
	@Override
	public int capacity() {
		// TODO Auto-generated method stub
		return this.capacity;
	}
	
	
	
	
}
