/**
　 * <p>Title: ByteBufferInputStream.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年8月14日
　 * @version 1.0
*/
package com.northpool.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

/**
 * @author matt
 *
 */
public class ByteBufferInputStream extends InputStream {
    private ByteBuffer buf;
    public ByteBufferInputStream(ByteBuffer buf){
        this.buf = buf;
    }
    @Override
    public int read() throws IOException{
        if(!buf.hasRemaining()){
            return -1;
        }
        return buf.get()& 0xFF;
    }
    @Override
    public int read(byte[] bytes,int off,int len)throws IOException{
        if(!buf.hasRemaining()){
            return -1;
        }
        len = Math.min(len,buf.remaining());
        buf.get(bytes,off,len);
        return len;
    }
    
    public byte[] toBytes(){
    	buf.flip();
    	int len = buf.limit() - buf.position();
        byte[] bytes1 = new byte[len];
        buf.get(bytes1);
        return bytes1;
    }
}
