package com.northpool.commons.util;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import sun.nio.ch.DirectBuffer;

/**
 * 处理小端
 * @author matt
 *
 */
public class DoubleBuilderL extends AbstractDoubleBuilder {


	
	public DoubleBuilderL() {
		super();
	}

	public DoubleBuilderL(int size){
		super(size);
	}
	
	public DoubleBuilderL(double[] arr) {
		super(arr);
	}
	@Override
	public ByteOrder order() {
        return ((ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN)
                ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

	@Override
	protected void putArrIntoDirectByteBuffer(ByteBuffer buffer, Object arr, int offset, int length) {
		
		
		if(!(buffer instanceof DirectBuffer)){
			throw new RuntimeException("buffer必须是DirectBuffer");
		}
		// TODO Auto-generated method stub
		 int pos = buffer.position() / 8;
         int lim = buffer.limit() / 8; 
         assert (pos <= lim);
         int rem = (pos <= lim ? lim - pos : 0);
         if (length > rem){
             throw new BufferOverflowException();
         }
         
         DirectBuffer directBuffer = (DirectBuffer)buffer;
         
       
         
         long dstAddr = directBuffer.address() + ((long)pos  << 3);
         try{
	         if (order() != ByteOrder.nativeOrder()){
	        	 UnsafeFuntion.get().copyFromLongArray(arr, (long)offset << 3, dstAddr,  (long)length << 3);
	         }else{
	        	 UnsafeFuntion.get().copyFromArray(arr, UnsafeFuntion.doubleArrayOffset,(long)offset << 3, dstAddr,  (long)length << 3); 
	         }
         }catch(Exception e){
        	 throw new RuntimeException(e);
         }
         buffer.position((pos + length) * 8);
	}




	
	/*public static void main(String[] aaa) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException{
	double[] aaac = new double[]{-111,-111};
	
		
		
		
		ByteBuffer b = ByteBuffer.allocateDirect(1024);
		b.putDouble(222);
		
		b.putDouble(222);
     // 	b.putDouble(222);
	//	
		DirectBuffer db = (DirectBuffer)b;
		
	
		
		int length = aaac.length;
		  int pos = b.position();
	      int lim = b.limit();
	      assert (pos <= lim);
	  		long t = db.address() + ((long)pos/8 << 3);
	      
	      int rem = (pos <= lim ? lim - pos : 0);
	      if (length > rem)
	          throw new BufferUnderflowException();
	      
	      
		//	UnsafeFuntion.get().copyFromLongArray(aaac,  (long)0 << 3, t,  (long)length << 3);
		//	b.position(32);
	
	      
			DoubleBuilderL dbl = new DoubleBuilderL(); //512588064
			dbl.putArrIntoDirectByteBuffer((ByteBuffer)b, aaac, 0, length);
	     

	      b.flip();
	      
	      
	  
			System.out.println(b.getDouble());
			System.out.println(b.getDouble());
			System.out.println(b.getDouble());
			System.out.println(b.getDouble());
		
	}*/
    

}
