package com.northpool.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.northpool.commons.bits.HexUtils;
/**
 * MD5加密
 * @author matt
 *
 */
public class MD5 {
	

	static MessageDigest messagedigest = null;
	
	static final ThreadLocal<MessageDigest> sThreadLocal = new ThreadLocal<MessageDigest>();

	static {
		try {
			messagedigest = MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException nsaex) {
			System.err.println(MD5.class.getName()
					+ "初始化失败，MessageDigest不支持MD5Util。");
			nsaex.printStackTrace();
		}
	}

	private static synchronized void update(byte[] input){
		messagedigest.update(input);
		
	}

	private static synchronized void update(ByteBuffer input){
		messagedigest.update(input);
	}

	private static synchronized void update(byte[] input, int offset, int len){
		messagedigest.update(input, offset, len);
	}

	private static synchronized byte[] digest(){
		return messagedigest.digest();
	}
	
	/**
	 * 生成字符串的md5校验值
	 * 
	 * @param s
	 * @return
	 */
	public static String getMD5String(String s) {
		if (s == null){//处理密码为空的情况
			s = "";
		}
		return getMD5String(s.getBytes());
	}
	
	/**
	 * 判断字符串的md5校验码是否与一个已知的md5码相匹配
	 * 
	 * @param password 要校验的字符串
	 * @param md5PwdStr 已知的md5校验码
	 * @return
	 */
	public static boolean checkPassword(String password, String md5PwdStr) {
		String s = getMD5String(password);
		return s.equals(md5PwdStr);
	}
	
	/**
	 * 生成文件的md5校验值
	 * 
	 * @param file
	 * @return
	 * @throws IOException
	 */
	/*public static String getFileMD5String(File file) throws IOException {
	    
	    MessageDigest md5 = sThreadLocal.get();
	    try {
	        MessageDigest messagedigestForFile = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }*/
	    
	    
		/*InputStream fis;
	    fis = new FileInputStream(file);
	    byte[] buffer = new byte[1024];
	    int numRead = 0;
	    while ((numRead = fis.read(buffer)) > 0) {
			update(buffer, 0, numRead);
	    }
	    fis.close();
		return bufferToHex(digest());*/
	//}

	/**
	 * JDK1.4中不支持以MappedByteBuffer类型为参数update方法，并且网上有讨论要慎用MappedByteBuffer，
	 * 原因是当使用 FileChannel.map 方法时，MappedByteBuffer 已经在系统内占用了一个句柄，
	 * 而使用 FileChannel.close 方法是无法释放这个句柄的，且FileChannel有没有提供类似 unmap 的方法，
	 * 因此会出现无法删除文件的情况。
	 * 
	 * 不推荐使用
	 * 
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public static String getFileMD5String_old(File file) throws IOException {
		FileInputStream in = new FileInputStream(file);
		FileChannel ch = in.getChannel();
		MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0,
				file.length());
		update(byteBuffer);
		return HexUtils.bytesToHexString(digest());
	}
	
	
	
	/**
	 * 生成字符串的md5校验值
	 * 
	 * @param bytes
	 * @return
	 */
	public static String getMD5String(byte[] bytes) {
		update(bytes);
		return HexUtils.bytesToHexString(digest());
	}

	
	
	public static void main(String[] args) throws IOException {
		long begin = System.currentTimeMillis();

		String p = null;
		String md5 = getMD5String(p);
		System.out.println("md5:" + getMD5String("asdasdasd"));
		System.out.println("md5:" + getMD5String("asdasdasd"));
		System.out.println("md5:" + getMD5String("asdasdasd"));
		System.out.println("md5:" + getMD5String("asdasdasd"));
		System.out.println("md5:" + getMD5String("asdasdasd"));
//		String md5 = getMD5String("a");
		
		long end = System.currentTimeMillis();
		System.out.println("md5:" + md5 + " time:" + ((end - begin) / 1000)	+ "s");
	}
}
