package com.northpool.commons.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName：NumberUtility
 * @author： 许明杰
 * @date： 2011-7-4
 * @Description： TODO
 */

public class NumberUtility {
	/**
	 * @Description: TODO(格式化中国货币)
	 * @Title: formatCurrency
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param money
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatCurrency(double money) {
		NumberFormat format = NumberFormat.getCurrencyInstance(Locale.CHINA);
		return format.format(money);

	}

	/**
	 * @Description: TODO(格式化整数)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatNumber(int number) {
		DecimalFormat df = new DecimalFormat("00000000");
		return df.format(number);
	}

	/**
	 * @Description: TODO(格式化Long)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatNumber(Long number) {
		DecimalFormat df = new DecimalFormat("00000000");
		return df.format(number);
	}

	/**
	 * @Description: TODO(格式化long)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatNumber(long number) {
		DecimalFormat df = new DecimalFormat("00000000");
		return df.format(number);
	}

	/**
	 * @Description: TODO(格式化double保留两位小数)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatDouble(double number) {
		DecimalFormat df = new DecimalFormat("###########0.00");
		return df.format(number);
	}

	/**
	 * @Description: TODO(格式化Double保留两位小数)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatDouble(Double number) {
		DecimalFormat df = new DecimalFormat("##########0.00");
		return df.format(number);
	}

	/**
	 * @Description: TODO(格式化String)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatDouble0(String number) {
		if (!StringUtility.isNullOrBlank(number)) {
			DecimalFormat df = new DecimalFormat("###########");
			return df.format(number);
		} else {
			return "";
		}

	}

	/**
	 * @Description: TODO(格式化Double保留两位小数)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatDouble(String number) {
		if (!StringUtility.isNullOrBlank(number)) {
			DecimalFormat df = new DecimalFormat("##########0.00");
			return df.format(number);
		} else {
			return "";
		}

	}

	/**
	 * @Description: TODO(格式化Double保留四位小数)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatDouble4(Double number) {
		DecimalFormat df = new DecimalFormat("###############.0000");
		return df.format(number);
	}

	/**
	 * @Description: TODO(格式化Double保留四位小数)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatDouble4(double number) {
		DecimalFormat df = new DecimalFormat("3333333333##0.0000");
		return df.format(number);
	}

	/**
	 * @Description: TODO(格式化Double)
	 * @Title: formatNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param number
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatDouble0(double number) {
		DecimalFormat df = new DecimalFormat("########");
		return df.format(number);
	}

	/**
	 * 根据int型除数、被除数做除法，返回size位数的String类型的小数
	 * 
	 * @author hex
	 * 
	 * @param arg1
	 *            除数
	 * @param arg2
	 *            被除数
	 * @param size
	 *            保留小数位数
	 * @return size位数的String类型的小数
	 */
	public static String div(int arg1, int arg2, int size) {
		double a = arg1;
		double b = arg2;
		NumberFormat nbf = NumberFormat.getInstance();
		nbf.setMinimumFractionDigits(size);
		String result = nbf.format(a / b);

		return result;
	}

	/**
	 * @Description: TODO(size 如果 小于1024 * 1024,以KB单位返回,反则以MB单位返回)
	 * @Title: getSintance
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param size
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String getSintance(float size) {
		DecimalFormat df = new DecimalFormat("###.##");
		float f;
		if (size < 1024 * 1024) {
			f = (float) ((float) size / (float) 1024);
			return (df.format(new Float(f).doubleValue()) + "KB");
		} else {
			f = (float) ((float) size / (float) (1024 * 1024));
			return (df.format(new Float(f).doubleValue()) + "MB");
		}
	}
	
	/**
	 * @Description: TODO(判断是否是数字)
	 * @Title: isNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param nums
	 * @return   设定参数 
	 * @return boolean    返回类型
	 * 
	 */
	public static Pattern p_number =  Pattern.compile("[0-9]*");
	
	public static boolean isNumber(String nums) {
		Matcher m = p_number.matcher(nums);
		return m.matches();
	}
	
	/**
	 * @Description: TODO(判断是否是数字)
	 * @Title: isNumber
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param nums
	 * @return   设定参数 
	 * @return boolean    返回类型
	 * 
	 */
	public static boolean isBigNumber(String nums) {
		if (nums == null || nums.equals("") || nums.length() < 7) {
			return false;
		}
		return isNumber(nums);
	}
}
