package com.northpool.commons.util;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
 
/**
 * Created by matt
 * 
 */
public class PackageUtil{
	private final static Logger log = LoggerFactory.getLogger(PackageUtil.class);
    //扫描  scanPackages 下的文件的匹配符
    protected static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    
    
    public  static ClassLoader CLASS_LOADER;
 
    
    
 
    /**
     * 结合spring的类扫描方式
     * 根据需要扫描的包路径及相应的注解，获取最终测method集合
     * 仅返回public方法，如果方法是非public类型的，不会被返回
     * 可以扫描工程下的class文件及jar中的class文件
     *
     * @param scanPackages
     * @param annotation
     * @return
     */
    public static Set<Method> findClassAnnotationMethods(String scanPackages, Class<? extends Annotation> annotation) {
        //获取所有的类
        Set<String> clazzSet = findPackageClass(scanPackages);
        Set<Method> methods = new HashSet<Method>();
        //遍历类，查询相应的annotation方法
        for (String clazz : clazzSet) {
            try {
            	
                Set<Method> ms = findAnnotationMethods(clazz, annotation);
                if (ms != null) {
                    methods.addAll(ms);
                }
            } catch (Exception ignore) {
            	continue;
            }
        }
        return methods;
    }
    /**
     * 结合spring的类扫描方式
     * 根据需要扫描的包路径及相应的注解，获取最终测class集合
     * 可以扫描工程下的class文件及jar中的class文件
     *
     * @param scanPackages
     * @param anno
     * @return
     */
    public static Set<Class<?>> findClassAnnotation(String scanPackages, Class<? extends Annotation> anno) throws ClassNotFoundException {
        //获取所有的类
        Set<String> clazzSet = findPackageClass(scanPackages);
        Set<Class<?>> classSet = new HashSet<Class<?>>();
        //遍历类，查询相应的annotation方法
        for (String clazz : clazzSet) {
        	Class<?> clasz = loadClass(clazz);
        	Annotation annotation  = clasz.getAnnotation(anno);
        //	clasz.getAnnotations()
            if (annotation != null) {
            	classSet.add(clasz);
            }
        }
        return classSet;
    }
    
    
    /**
     * 结合spring的类扫描方式
     * 根据需要扫描的包路径及相应的注解，获取最终测class集合
     * 可以扫描工程下的class文件及jar中的class文件
     *
     * @param scanPackages
     * @param anno
     * @return
     */
    public static Set<Class<?>> findClassAnnotation(String[] scanPackages, Class<? extends Annotation> anno) throws ClassNotFoundException {
        //获取所有的类
        Set<String> clazzSet = new HashSet<>();
        
        for(String scanPackage : scanPackages){
            clazzSet.addAll(findPackageClass(scanPackage));
        }

        Set<Class<?>> classSet = new HashSet<Class<?>>();
        //遍历类，查询相应的annotation方法
        for (String clazz : clazzSet) {
            Class<?> clasz = loadClass(clazz);
            Annotation annotation  = clasz.getAnnotation(anno);
        //  clasz.getAnnotations()
            if (annotation != null) {
                classSet.add(clasz);
            }
        }
        return classSet;
    }
    
    
    
    
    public static Set<Class<?>> findClassByInterface(String[] scanPackages, Class<?> interfaceClass) throws ClassNotFoundException {
        //获取所有的类
      //获取所有的类
        Set<String> clazzSet = new HashSet<>();
        
        for(String scanPackage : scanPackages){
            clazzSet.addAll(findPackageClass(scanPackage));
        }
        
        Set<Class<?>> classSet = new HashSet<Class<?>>();
        //遍历类，查询相应的annotation方法
        for (String clazz : clazzSet) {
            Class clasz = loadClass(clazz);
            if (ArrayUtils.contains(clasz.getInterfaces(), interfaceClass)) {
                classSet.add(clasz);
            }
        }
        return classSet;
    }
    
    
    
    
    public static Set<Class<?>> findClassByInterface(String scanPackages, Class<?> interfaceClass) throws ClassNotFoundException {
        //获取所有的类
        Set<String> clazzSet = findPackageClass(scanPackages);
        Set<Class<?>> classSet = new HashSet<Class<?>>();
        //遍历类，查询相应的annotation方法
        for (String clazz : clazzSet) {
            Class clasz = loadClass(clazz);
            if (ArrayUtils.contains(clasz.getInterfaces(), interfaceClass)) {
                classSet.add(clasz);
            }
        }
        return classSet;
    }
 
    
    
    private static Class loadClass(String clazz) throws ClassNotFoundException{
    	if(CLASS_LOADER == null){
    		return Class.forName(clazz);
    	}else{
    		return CLASS_LOADER.loadClass(clazz);
    	}
    	
    }
    
    /**
     * 根据扫描包的,查询下面的所有类
     *
     * @param scanPackages 扫描的package路径
     * @return
     */
    public static Set<String> findPackageClass(String scanPackages) {
        if (StringUtils.isBlank(scanPackages)) {
            return Collections.EMPTY_SET;
        }
        //验证及排重包路径,避免父子路径多次扫描
        Set<String> packages = checkPackage(scanPackages);
       // ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
      //  MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory(resourcePatternResolver);
        Set<String> clazzSet = new HashSet<String>();
        for (String basePackage : packages) {
            if (StringUtils.isBlank(basePackage)) {
                continue;
            }
           /* String packageSearchPath = ResourcePatternResolver.CLASSPATH_ALL_URL_PREFIX +
                    org.springframework.util.ClassUtils.convertClassNameToResourcePath(SystemPropertyUtils.resolvePlaceholders(basePackage)) + "/" + DEFAULT_RESOURCE_PATTERN;*/
            try {
            	Set<String> resourceNameSet = getClassName(scanPackages,true);
                for (String resourceName : resourceNameSet) {
                    //检查resource，这里的resource都是class
                	Class clasz = null;
                  
                    try{
                    	clasz = loadClass(resourceName);
                    }catch(Throwable e){
                    	continue;
                    }
                    if(clasz.isInterface()){
                    	continue;
                    }
                    
                    clazzSet.add(resourceName);
                }
            } catch (Exception e) {
                log.error("获取包下面的类信息失败,package:" + basePackage, e);
            }
 
        }
        return clazzSet;
    }
    
  
    
 
    /**
     * 排重、检测package父子关系，避免多次扫描
     *
     * @param scanPackages
     * @return 返回检查后有效的路径集合
     */
    private static Set<String> checkPackage(String scanPackages) {
        if (StringUtils.isBlank(scanPackages)) {
            return Collections.EMPTY_SET;
        }
        Set<String> packages = new HashSet<String>();
        //排重路径
        Collections.addAll(packages, scanPackages.split(","));
        for (String pInArr : packages.toArray(new String[packages.size()])) {
            if (StringUtils.isBlank(pInArr) || pInArr.equals(".") || pInArr.startsWith(".")) {
                continue;
            }
            if (pInArr.endsWith(".")) {
                pInArr = pInArr.substring(0, pInArr.length() - 1);
            }
            Iterator<String> packageIte = packages.iterator();
            boolean needAdd = true;
            while (packageIte.hasNext()) {
                String pack = packageIte.next();
                if (pInArr.startsWith(pack + ".")) {
                    //如果待加入的路径是已经加入的pack的子集，不加入
                    needAdd = false;
                } else if (pack.startsWith(pInArr + ".")) {
                    //如果待加入的路径是已经加入的pack的父集，删除已加入的pack
                    packageIte.remove();
                }
            }
            if (needAdd) {
                packages.add(pInArr);
            }
        }
        return packages;
    }
 
 
//    /**
//     * 加载资源，根据resource获取className
//     *
//     * @param metadataReaderFactory spring中用来读取resource为class的工具
//     * @param resource              这里的资源就是一个Class
//     * @throws IOException
//     */
//    private static String loadClassName(MetadataReaderFactory metadataReaderFactory, Resource resource) throws IOException {
//        try {
//            if (resource.isReadable()) {
//                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
//                if (metadataReader != null) {
//                    return metadataReader.getClassMetadata().getClassName();
//                }
//            }
//        } catch (Exception e) {
//            log.error("根据resource获取类名称失败", e);
//        }
//        return null;
//    }
 
    /**
     * 把action下面的所有method遍历一次，标记他们是否需要进行敏感词验证
     * 如果需要，放入cache中
     *
     * @param fullClassName
     */
    public static Set<Method> findAnnotationMethods(String fullClassName, Class<? extends Annotation> anno) throws Exception {
        Set<Method> methodSet = new HashSet<Method>();
        Method[] methods = null;
        try{
        	Class<?> clz = loadClass(fullClassName);

     
        	methods = clz.getDeclaredMethods();
	    }catch(Throwable e){
	    	  
	    }
        for (Method method : methods) {
            if (method.getModifiers() == Modifier.PRIVATE || method.getModifiers() == Modifier.PROTECTED) {
                continue;
            }
            Annotation annotation = method.getAnnotation(anno);
            if (annotation != null) {
                methodSet.add(method);
            }
        }
        return methodSet;
    }
    
    
    /** 
     * 获取某包下所有类 
     * @param packageName 包名 
     * @param childPackage 是否遍历子包 
     * @return 类的完整名称 
     * @throws IOException 
     */  
    public static Set<String> getClassName(String packageName, boolean childPackage) throws IOException {  
    	Set<String> fileNames = new HashSet<>();  
        ClassLoader loader = Thread.currentThread().getContextClassLoader();  
        String packagePath = packageName.replace(".", "/");  
        Enumeration<URL> enumeration = loader.getResources(packagePath);
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
	        if (url != null) {  
	            String type = url.getProtocol();  
	            if (type.equals("file")) {  
	            	fileNames.addAll(getClassNameByFile(url.getPath(), null, childPackage));  
	                
	            } else if (type.equals("jar")) {  
	            	fileNames.addAll(getClassNameByJar(url.getPath(), childPackage));  
	            }  
	        } else {  
	            fileNames.addAll(getClassNameByJars(((URLClassLoader) loader).getURLs(), packagePath, childPackage));  
	        }
        }
        return fileNames;  
    }  
  
    /** 
     * 从项目文件获取某包下所有类 
     * @param filePath 文件路径 
     * @param className 类名集合 
     * @param childPackage 是否遍历子包 
     * @return 类的完整名称 
     */  
    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {  
        List<String> myClassName = new ArrayList<String>();  
        File file = new File(filePath);  
        File[] childFiles = file.listFiles();  
        for (File childFile : childFiles) {  
            if (childFile.isDirectory()) {  
                if (childPackage) {  
                    myClassName.addAll(getClassNameByFile(childFile.getPath(), myClassName, childPackage));  
                }  
            } else {  
                String childFilePath = childFile.getPath();  
                if (childFilePath.endsWith(".class")) {  
                    childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));  
                    childFilePath = childFilePath.replace("\\", ".");  
                    myClassName.add(childFilePath);  
                }  
            }  
        }  
  
        return myClassName;  
    }  
  
    /** 
     * 从jar获取某包下所有类 
     * @param jarPath jar文件路径 
     * @param childPackage 是否遍历子包 
     * @return 类的完整名称 
     */  
    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) {  
        List<String> myClassName = new ArrayList<String>();  
        String[] jarInfo = jarPath.split("!");  
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));  
        String packagePath = jarInfo[1].substring(1);  
        try {  
            JarFile jarFile = new JarFile(jarFilePath);  
            Enumeration<JarEntry> entrys = jarFile.entries();  
            while (entrys.hasMoreElements()) {  
                JarEntry jarEntry = entrys.nextElement();  
                String entryName = jarEntry.getName();  
                if (entryName.endsWith(".class")) {  
                    if (childPackage) {  
                        if (entryName.startsWith(packagePath)) {  
                            entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));  
                            myClassName.add(entryName);  
                        }  
                    } else {  
                        int index = entryName.lastIndexOf("/");  
                        String myPackagePath;  
                        if (index != -1) {  
                            myPackagePath = entryName.substring(0, index);  
                        } else {  
                            myPackagePath = entryName;  
                        }  
                        if (myPackagePath.equals(packagePath)) {  
                            entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));  
                            myClassName.add(entryName);  
                        }  
                    }  
                }  
            }  
        } catch (Exception e) {  
            e.printStackTrace();  
        }  
        return myClassName;  
    }  
  
    /** 
     * 从所有jar中搜索该包，并获取该包下所有类 
     * @param urls URL集合 
     * @param packagePath 包路径 
     * @param childPackage 是否遍历子包 
     * @return 类的完整名称 
     */  
    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) {  
        List<String> myClassName = new ArrayList<String>();  
        if (urls != null) {  
            for (int i = 0; i < urls.length; i++) {  
                URL url = urls[i];  
                String urlPath = url.getPath();  
                // 不必搜索classes文件夹  
                if (urlPath.endsWith("classes/")) {  
                    continue;  
                }  
                String jarPath = urlPath + "!/" + packagePath;  
                myClassName.addAll(getClassNameByJar(jarPath, childPackage));  
            }  
        }  
        return myClassName;  
    }  
    
    
    /*public static void main(String[] aaa) throws IOException{
    	
    	
    
    	
    	Set<String> set = findPackageClass("org/springframework/expression/spel/ast");
    	 System.out.println(set.size());
         for(String i : set){
         	System.out.println(i);
         }
    	
    	
    	
    }*/
    
    
    
    
   
    
 

}