/**
　 * <p>Title: asdasd.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年11月4日
　 * @version 1.0
*/
package com.northpool.commons.util;

/**
 * @author matt
 *
 */
public final class WatchDog {

    private final String label;
    private long begin = 0;
    private long end = 0;
    private boolean showInSec = false;
 
    public WatchDog() {
        this(null, false);
    }

    public WatchDog(String label) {
        this(label, false);
    }

    public WatchDog(String label, boolean showInSec) {
        this.label = label;
        this.showInSec = showInSec;
        start();
    }

    public void setShowInSec(boolean showInSec) {
        this.showInSec = showInSec;
    }

    public void start() {
        begin = System.currentTimeMillis();
    }

    public long stop() {
        end = System.currentTimeMillis();
        return end - begin;
    }

    public void suspend() {
        end = System.currentTimeMillis();
    }

    public void resume() {
        begin += (System.currentTimeMillis() - end);
    }

    public void reset() {
        begin = 0;
        end = 0;
    }

    public long elapsed() {
        if (end != 0) {
            return end - begin;
        } else {
            return System.currentTimeMillis() - begin;
        }
    }

    @Override
    public String toString() {
        final StringBuilder buf = new StringBuilder();
        if (label != null) {
            buf.append(label + " use : ");
        }
        long t = elapsed();
        buf.append(t);
        buf.append(" ms");
        return buf.toString();
    }
    
    
}

