/**
　 * <p>Title: ExceptionToJSON.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年8月21日
　 * @version 1.0
*/
package com.northpool.exception;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.northpool.commons.reflect.Bean;
import com.northpool.commons.util.UnsafeFuntion;

/**
 * @author matt
 *
 */
public class ExceptionToJSON {
    static final String EXCEPTION_CLASS_NAME = "exceptionCLassName";
    static final String EXCEPTION_VALUE = "exceptionValue";
    static final String EXCEPTION_STACK_TRACE = "stackTrace";
    static final String EXCEPTION_MESSAGE = "message";
    static final String EXCEPTION_LOCALIZED_MESSAGE = "localizedMessage";
    
    public static String toJSON(Throwable e){
      //  String JSON.toJSON(e);
        String className = e.getClass().getName();
        JSONObject exception = (JSONObject)JSON.toJSON(e);
        JSONObject returnObject = new JSONObject();
        returnObject.put(EXCEPTION_CLASS_NAME, className);
        returnObject.put(EXCEPTION_VALUE, exception);
        return returnObject.toJSONString();
    }
    
    
    public static <E extends Throwable> String toJSONArray(List<E> errors){
        List<String> stringList = new ArrayList<>();
        for(Throwable throwable : errors){
            stringList.add(ExceptionToJSON.toJSON(throwable));
        }
        return JSON.toJSONString(stringList);
        
    }
    
    public static <E extends Throwable> List<E> fromJSONArrAy(String exceptionArrStr){
       
        JSONArray array = JSON.parseArray(exceptionArrStr);
        List<E> exceptionArr = new ArrayList<>(array.size());
        for(Object str : array){
            String exceptionStr = (String)str;
            E e = fromJSON(exceptionStr);
            exceptionArr.add(e);
        }
        return exceptionArr;
    }
    
    
    //{"fileName":"CompleteData.java","nativeMethod":false,"methodName":"check","className":"com.htht.datatrans.node.builddata.complete.CompleteData","lineNumber":435}
    
    private static StackTraceElement[] getStackTraceElementFromJson(JSONArray jsonArray){
        StackTraceElement[] array = new StackTraceElement[jsonArray.size()];
        for(int i = 0 ; i < jsonArray.size() ; i ++ ){
            JSONObject object = jsonArray.getJSONObject(i);
            String fileName = object.getString("fileName");
            int lineNumber = object.getIntValue("lineNumber");
            String methodName = object.getString("methodName");
            String className = object.getString("className");
            StackTraceElement stackTraceElement = new StackTraceElement(className,methodName,fileName,lineNumber);
            array[i] = stackTraceElement;
        }
        return array;
    }
    
    
    public  static <E extends Throwable> E fromJSON(String exceptionStr){
        JSONObject exception = (JSONObject)JSON.parse(exceptionStr);
        //JSONObject stackTrace = exception.get("exceptionValue").get("stackTrace");
        
        
        
        String className = exception.getString(EXCEPTION_CLASS_NAME);
        JSONObject exceptionValue = exception.getJSONObject(EXCEPTION_VALUE);
        JSONArray jsonStackTraceElementArray = exceptionValue.getJSONArray(EXCEPTION_STACK_TRACE); 
        StackTraceElement[] stackTraceElement = getStackTraceElementFromJson(jsonStackTraceElementArray);
        String message = exceptionValue.getString("message");
        
        
        
        Class<?> exceptionClass = Throwable.class;
        E exceptionObj = null;
        if(className != null){
            try {
                exceptionClass = Bean.getClassByName(className);
                if(!Bean.isExtends(exceptionClass, Throwable.class)){
                    exceptionClass = Throwable.class;
                }
                exceptionObj = (E)UnsafeFuntion.get().createInstance(exceptionClass);
                Bean.setSingleObjectValueByPrivateFieldName(exceptionObj, "detailMessage", message);
                Bean.setSingleObjectValueByPrivateFieldName(exceptionObj, "stackTrace", stackTraceElement);
                
            } catch (ClassNotFoundException e) {
                exceptionClass = Throwable.class;
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return exceptionObj;
    }
}
